/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor.transformation;

import de.fzi.gast.functions.Method;
import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.Branch;
import de.fzi.gast.statements.BranchStatement;
import de.fzi.gast.statements.JumpStatement;
import de.fzi.gast.statements.JumpStatementKind;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.statementsFactory;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.ow2.dsrg.fm.qabstractor.Transformer;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;
import org.ow2.dsrg.fm.qabstractor.transformation.Transformation;

public class JumpReplacer
extends Transformation {
    private boolean needReturnBranch;

    public JumpReplacer(MetadataExtractor extr) {
        super(Logger.getLogger(Transformer.class), extr);
    }

    @Override
    protected void processMethod(Method method) {
        this.needReturnBranch = false;
        super.processMethod(method);
    }

    @Override
    protected void processJumpStatement(JumpStatement jumpStatement) {
        super.processJumpStatement(jumpStatement);
        if (jumpStatement.getKind().equals((Object)JumpStatementKind.RETURN)) {
            this.needReturnBranch = true;
        }
    }

    @Override
    protected void processBlock(BlockStatement block) {
        boolean needBranchRet = false;
        EList list = block.getStatements();
        Vector proces = new Vector(list);
        int i = 0;
        while (i < proces.size()) {
            this.processStatement((Statement)proces.get(i));
            if (this.needReturnBranch) {
                needBranchRet = true;
                BlockStatement newbl = statementsFactory.eINSTANCE.createBlockStatement();
                ++i;
                while (i < proces.size()) {
                    newbl.getStatements().add((Object)((Statement)proces.get(i)));
                    ++i;
                }
                Branch newbr = statementsFactory.eINSTANCE.createBranch();
                newbr.setStatement((Statement)newbl);
                BranchStatement newbs = statementsFactory.eINSTANCE.createBranchStatement();
                newbs.getBranches().add((Object)newbr);
                this.processStatement((Statement)newbs);
                block.getStatements().add((Object)newbs);
            }
            ++i;
        }
        this.needReturnBranch = needBranchRet;
    }
}

