/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor.transformation;

import de.fzi.gast.accesses.BaseAccess;
import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.accesses.SelfAccess;
import de.fzi.gast.accesses.VariableAccess;
import de.fzi.gast.accesses.impl.accessesFactoryImpl;
import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.Root;
import de.fzi.gast.expressions.FunctionCall;
import de.fzi.gast.expressions.MemberAccessor;
import de.fzi.gast.expressions.MemberExpression;
import de.fzi.gast.expressions.Reference;
import de.fzi.gast.expressions.TypeReference;
import de.fzi.gast.expressions.Variable;
import de.fzi.gast.expressions.impl.expressionsFactoryImpl;
import de.fzi.gast.functions.Method;
import de.fzi.gast.statements.Branch;
import de.fzi.gast.statements.BranchStatement;
import de.fzi.gast.statements.GASTExpression;
import de.fzi.gast.statements.SimpleStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.impl.statementsFactoryImpl;
import de.fzi.gast.statements.statementsFactory;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.types.Visibilities;
import de.fzi.gast.types.impl.typesFactoryImpl;
import de.fzi.gast.types.typesFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.ow2.dsrg.fm.qabstractor.Transformer;
import org.ow2.dsrg.fm.qabstractor.exception.RecursiveException;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;
import org.ow2.dsrg.fm.qabstractor.pointsto.PointsTo;
import org.ow2.dsrg.fm.qabstractor.transformation.Transformation;
import org.ow2.dsrg.fm.qabstractor.utils.ClassFinder;
import org.ow2.dsrg.fm.qabstractor.utils.MethodComparator;
import org.ow2.dsrg.fm.qabstractor.utils.MethodUtils;

public class Inline
extends Transformation {
    protected GASTClass result;
    private statementsFactory statementFactory;
    private typesFactory typeFactory;
    private PointsTo pointsTo;
    private Root rootElement;
    private String componentName;
    private List<Collision> collisions = new LinkedList<Collision>();

    public Inline(MetadataExtractor extractor, PointsTo pointsTo, Root root) {
        super(Logger.getLogger(Transformer.class), extractor);
        this.statementFactory = new statementsFactoryImpl();
        this.typeFactory = new typesFactoryImpl();
        this.pointsTo = pointsTo;
        this.rootElement = root;
    }

    @Override
    public void processComponent(String componentName) {
        this.componentName = componentName;
        this.result = this.typeFactory.createGASTClass();
        this.result.setSimpleName(componentName);
        super.processComponent(componentName);
        for (Method m : this.extractor.getProvidedMethods(componentName)) {
            Method nm = (Method)this.copier.copy((EObject)m);
            this.result.getMethods().add((Object)nm);
            this.processMethod(nm);
        }
        for (GASTClass cl : this.extractor.getImplClasses(componentName)) {
            if (!this.isThread(cl)) continue;
            Method m = this.getRunMethod(cl);
            if (m == null) {
                this.log.warn((Object)("Failed to find the run method of the Thread " + cl.getQualifiedName()));
                continue;
            }
            Method nm = (Method)this.copier.copy((EObject)m);
            nm.setSimpleName("Thread_" + cl.getSimpleName() + "_run");
            this.result.getMethods().add((Object)nm);
            this.processMethod(nm);
        }
        this.extractor.setExtractedClass(componentName, this.result);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void processSimpleStatement(SimpleStatement simpleStatement) {
        FunctionAccess fa = null;
        if (simpleStatement.getExpression() != null) {
            if (simpleStatement.getExpression() instanceof MemberAccessor && ((MemberAccessor)simpleStatement.getExpression()).getRight() instanceof FunctionCall) {
                MemberAccessor ma = (MemberAccessor)simpleStatement.getExpression();
                FunctionCall fc = (FunctionCall)ma.getRight();
                fa = fc.getFunction();
            } else {
                if (!(simpleStatement.getExpression() instanceof FunctionCall)) {
                    this.removeStatement((Statement)simpleStatement);
                    return;
                }
                FunctionCall fc = (FunctionCall)simpleStatement.getExpression();
                fa = fc.getFunction();
            }
        } else {
            fa = this.getFunctionAccess(simpleStatement);
            if (fa == null) {
                this.removeStatement((Statement)simpleStatement);
                return;
            }
        }
        String callName = this.getFullyQualifiedCallName(simpleStatement, fa.getTargetFunction().getSimpleName());
        if (this.isRequired(callName)) {
            Statement n = this.cloneStatement((Statement)simpleStatement);
            this.replaceStatement((Statement)simpleStatement, n);
            if (!this.collisions.isEmpty()) {
                this.collisions.get(this.collisions.size() - 1).setContainRequired(true);
            }
            return;
        }
        if (!this.isInCompomenent(fa)) {
            this.removeStatement((Statement)simpleStatement);
            return;
        }
        Set<String> realFunctionsNames = this.getRuntimeclasses(simpleStatement);
        TreeSet<Method> realFunctions = new TreeSet<Method>(new MethodComparator());
        if (((Method)fa.getTargetFunction()).getVisibility().equals((Object)Visibilities.VISIBILITYPRIVAT)) {
            realFunctions.add((Method)fa.getTargetFunction());
        } else {
            for (String str : realFunctionsNames) {
                GASTClass clas = ClassFinder.getClassByQualifiedName(this.rootElement, str);
                if (clas == null) continue;
                for (Method m : clas.getMethods()) {
                    if (!m.getSimpleName().equals(fa.getTargetFunction().getSimpleName()) || !m.getFormalParameters().equals((Object)fa.getTargetFunction().getFormalParameters())) continue;
                    realFunctions.add(m);
                }
            }
        }
        LinkedList<Method> toRemove = new LinkedList<Method>();
        for (Method m : realFunctions) {
            for (Collision c : this.collisions) {
                if (!c.getMethodName().equals(MethodUtils.getFullyQualfiedName(m))) continue;
                for (Collision cc : this.collisions.subList(this.collisions.indexOf(c), this.collisions.size())) {
                    if (!cc.containRequired) continue;
                    throw new RecursiveException(m.getPosition());
                }
                toRemove.add(m);
            }
        }
        realFunctions.removeAll(toRemove);
        Statement n = null;
        assert (!realFunctions.isEmpty()) : "No function to inline after resolving virtual functions";
        if (realFunctions.size() == 1) {
            Method m = (Method)realFunctions.iterator().next();
            if (m.getBody() != null) {
                n = this.cloneStatement((Statement)m.getBody());
                this.collisions.add(new Collision(MethodUtils.getFullyQualfiedName(m)));
                this.processStatement(n);
                this.collisions.remove(this.collisions.size() - 1);
            }
        } else {
            BranchStatement ret = this.statementFactory.createBranchStatement();
            for (Method m : realFunctions) {
                if (m.getBody() == null) continue;
                this.collisions.add(new Collision(MethodUtils.getFullyQualfiedName(m)));
                Branch br = this.statementFactory.createBranch();
                br.setStatement(this.cloneStatement((Statement)m.getBody()));
                ret.getBranches().add((Object)br);
                this.processStatement(br.getStatement());
                this.collisions.remove(this.collisions.size() - 1);
            }
            n = ret;
        }
        this.replaceStatement((Statement)simpleStatement, n);
    }

    protected boolean isRequired(String callName) {
        for (Method m : this.extractor.getRequiredMethods(this.componentName)) {
            String method = m.getSurroundingClass().getQualifiedName();
            if (!(method = String.valueOf(method) + "." + m.getSimpleName()).equals(callName)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFullyQualifiedCallName(SimpleStatement s, String call) {
        GASTType gp = null;
        if (s.getExpression() != null) {
            if (s.getExpression() instanceof MemberAccessor) {
                MemberAccessor ma = (MemberAccessor)s.getExpression();
                if (ma.getLeft() instanceof Variable) {
                    gp = ((Variable)ma.getLeft()).getVariableAccess().getTargetVariable().getType();
                } else {
                    if (!(ma.getLeft() instanceof TypeReference)) throw new UnsupportedOperationException("unsupported type in Member Accessor");
                    gp = ((TypeReference)ma.getLeft()).getTypeaccess().getTargetType();
                }
            }
        } else {
            for (BaseAccess a : s.getAccesses()) {
                if (!(a instanceof VariableAccess)) continue;
                gp = ((VariableAccess)a).getTargetVariable().getType();
            }
        }
        if (gp != null) {
            String ret = gp.getQualifiedName();
            return String.valueOf(ret) + "." + call;
        }
        assert (false) : "No variable access";
        return "call";
    }

    private Set<String> getRuntimeclasses(SimpleStatement s) {
        if (s.getExpression() != null) {
            MemberAccessor ma;
            if (!(s.getExpression() instanceof MemberAccessor) && !(s.getExpression() instanceof FunctionCall)) {
                throw new UnsupportedOperationException("In this phase of transformation only MemAccessor should be presented");
            }
            if (s.getExpression() instanceof FunctionCall) {
                SimpleStatement ns = this.statementFactory.createSimpleStatement();
                MemberAccessor ma2 = expressionsFactoryImpl.eINSTANCE.createMemberAccessor();
                ma2.setRight((Reference)((FunctionCall)s.getExpression()));
                Variable va = expressionsFactoryImpl.eINSTANCE.createVariable();
                SelfAccess sa = accessesFactoryImpl.eINSTANCE.createSelfAccess();
                sa.setAccessedTarget((ModelElement)((FunctionCall)ma2.getRight()).getFunction().getAccessedClass().getSelf());
                va.setVariableAccess((VariableAccess)sa);
                ma2.setLeft((MemberExpression)va);
                ns.setExpression((GASTExpression)ma2);
                s = ns;
            }
            if ((ma = (MemberAccessor)s.getExpression()).getLeft() instanceof Variable) {
                Variable v = (Variable)ma.getLeft();
                if (v.getVariableAccess() instanceof SelfAccess && ((SelfAccess)v.getVariableAccess()).isSuper()) {
                    TreeSet<String> ret = new TreeSet<String>();
                    ret.add(v.getVariableAccess().getTargetVariable().getType().getQualifiedName().replace("$", "."));
                    return ret;
                }
                return this.pointsTo.getRuntimeClass((MemberAccessor)s.getExpression());
            }
            if (ma.getLeft() instanceof TypeReference) {
                TreeSet<String> ret = new TreeSet<String>();
                ret.add(((TypeReference)ma.getLeft()).getTypeaccess().getTargetType().getQualifiedName().replace("$", "."));
                return ret;
            }
            throw new UnsupportedOperationException("Member accesor should have on left side only type or variable");
        }
        FunctionAccess fa = null;
        VariableAccess v = null;
        for (BaseAccess a : s.getAccesses()) {
            if (a instanceof VariableAccess) {
                v = (VariableAccess)a;
                continue;
            }
            if (!(a instanceof FunctionAccess)) continue;
            fa = (FunctionAccess)a;
        }
        if (v instanceof SelfAccess && ((SelfAccess)v).isSuper()) {
            TreeSet<String> ret = new TreeSet<String>();
            ret.add(v.getTargetVariable().getType().getQualifiedName().replace("$", "."));
            return ret;
        }
        return this.pointsTo.getRuntimeClass(fa, v.getTargetVariable());
    }

    private boolean isInCompomenent(FunctionAccess functionAccess) {
        if (functionAccess.getTargetFunction() instanceof Method) {
            GASTClass containedClass = ((Method)functionAccess.getTargetFunction()).getSurroundingClass();
            if (this.extractor.getImplClasses(this.componentName).contains(containedClass)) {
                return true;
            }
        }
        return false;
    }

    private boolean isThread(GASTClass clas) {
        for (GASTClass cl : ClassFinder.getAllAncestors(clas)) {
            if (!cl.getSimpleName().equals("Thread") && !cl.getSimpleName().equals("Runnable")) continue;
            return true;
        }
        return false;
    }

    private Method getRunMethod(GASTClass clas) {
        for (Method m : clas.getMethods()) {
            if (!m.getSimpleName().equals("run")) continue;
            return m;
        }
        return null;
    }

    protected FunctionAccess getFunctionAccess(SimpleStatement simpleStatement) {
        for (BaseAccess a : simpleStatement.getAccesses()) {
            if (!(a instanceof FunctionAccess)) continue;
            return (FunctionAccess)a;
        }
        return null;
    }

    protected class Collision
    implements Comparable<Collision> {
        private boolean containRequired;
        private String methodName;

        public Collision(String name) {
            this.methodName = name;
            this.containRequired = false;
        }

        @Override
        public int compareTo(Collision o) {
            return this.methodName.compareTo(o.toString());
        }

        public boolean containRequired() {
            return this.containRequired;
        }

        public void setContainRequired(boolean containRequired) {
            this.containRequired = containRequired;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }
}

