/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor.transformation;

import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.Branch;
import de.fzi.gast.statements.BranchStatement;
import de.fzi.gast.statements.CatchBlock;
import de.fzi.gast.statements.ExceptionHandler;
import de.fzi.gast.statements.JumpStatement;
import de.fzi.gast.statements.LoopStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.statementsFactory;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.ow2.dsrg.fm.qabstractor.Transformer;
import org.ow2.dsrg.fm.qabstractor.exception.RequireInCatchException;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;
import org.ow2.dsrg.fm.qabstractor.transformation.Transformation;

public class Clean
extends Transformation {
    public Clean(MetadataExtractor extractor) {
        super(Logger.getLogger(Transformer.class), extractor);
    }

    @Override
    protected void processBlock(BlockStatement block) {
        Statement s;
        super.processBlock(block);
        if (block.getStatements().isEmpty()) {
            this.removeStatement((Statement)block);
        }
        if (block.getStatements().size() == 1 && (s = (Statement)block.getStatements().iterator().next()) instanceof BlockStatement) {
            this.replaceStatement((Statement)block, s);
        }
    }

    @Override
    protected void processLoop(LoopStatement loop) {
        super.processLoop(loop);
        if (this.isBodyEmpty(loop.getBody())) {
            this.log.info((Object)("remove: " + loop.getBody().getId()));
            this.removeStatement((Statement)loop);
        }
        if (loop.getBody() instanceof LoopStatement) {
            this.replaceStatement((Statement)loop, loop.getBody());
        }
        if (loop.getBody() instanceof BlockStatement) {
            BranchStatement br;
            BlockStatement body = (BlockStatement)loop.getBody();
            if (body.getStatements().size() == 1 && body.getStatements().iterator().next() instanceof LoopStatement) {
                this.replaceStatement((Statement)loop, (Statement)body.getStatements().iterator().next());
            }
            if (body.getStatements().size() == 1 && body.getStatements().iterator().next() instanceof BranchStatement && (br = (BranchStatement)body.getStatements().iterator().next()).getBranches().size() == 1) {
                loop.setBody(((Branch)br.getBranches().iterator().next()).getStatement());
            }
        }
    }

    @Override
    protected void processJumpStatement(JumpStatement s) {
        this.removeStatement((Statement)s);
    }

    @Override
    protected void processBranch(BranchStatement branch) {
        super.processBranch(branch);
        Vector<Branch> toRemove = new Vector<Branch>();
        for (Branch br : branch.getBranches()) {
            if (br.getStatement() != null) continue;
            toRemove.add(br);
        }
        for (Branch b : toRemove) {
            branch.getBranches().remove((Object)b);
        }
        if (branch.getBranches().isEmpty()) {
            this.removeStatement((Statement)branch);
        }
        if (branch.getBranches().size() == 1) {
            Branch bra = (Branch)branch.getBranches().iterator().next();
            boolean cont = false;
            Statement s = bra.getStatement();
            do {
                cont = false;
                if (s instanceof BranchStatement || s instanceof LoopStatement) {
                    this.replaceStatement((Statement)branch, s);
                    break;
                }
                if (!(s instanceof BlockStatement) || ((BlockStatement)s).getStatements().size() != 1) continue;
                s = (Statement)((BlockStatement)s).getStatements().iterator().next();
                cont = true;
            } while (cont);
        }
    }

    @Override
    protected void processExceptionHandler(ExceptionHandler exceptionHandler) {
        super.processExceptionHandler(exceptionHandler);
        BlockStatement bl = statementsFactory.eINSTANCE.createBlockStatement();
        bl.getStatements().add((Object)exceptionHandler.getGuardedBlock());
        if (exceptionHandler.getFinallyBlock() != null && exceptionHandler.getFinallyBlock().getStatements() != null && !exceptionHandler.getFinallyBlock().getStatements().isEmpty()) {
            bl.getStatements().add((Object)exceptionHandler.getFinallyBlock());
        }
        if (exceptionHandler.getCatchBlocks() != null) {
            for (CatchBlock cb : exceptionHandler.getCatchBlocks()) {
                if (cb.getStatements().size() <= 0) continue;
                this.log.warn((Object)"The catch block contains a required call");
                Statement s = (Statement)cb.getStatements().get(0);
                throw new RequireInCatchException(s.getPosition());
            }
        }
        this.replaceStatement((Statement)exceptionHandler, (Statement)bl);
    }

    protected boolean isBodyEmpty(Statement body) {
        if (body == null) {
            return true;
        }
        if (body instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)body;
            return block.getStatements().isEmpty();
        }
        if (body instanceof LoopStatement) {
            this.processLoop((LoopStatement)body);
            return this.isBodyEmpty(((LoopStatement)body).getBody());
        }
        return false;
    }
}

