/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor.transformation;

import de.fzi.gast.expressions.AssignmentOperatorExpression;
import de.fzi.gast.expressions.Atom;
import de.fzi.gast.expressions.BooleanOperatorExpression;
import de.fzi.gast.expressions.CastExpression;
import de.fzi.gast.expressions.CompareExpression;
import de.fzi.gast.expressions.Conditional;
import de.fzi.gast.expressions.FunctionCall;
import de.fzi.gast.expressions.MemberAccessor;
import de.fzi.gast.expressions.NotExpression;
import de.fzi.gast.expressions.ProductExpression;
import de.fzi.gast.expressions.TermExpression;
import de.fzi.gast.expressions.TypeReference;
import de.fzi.gast.expressions.UnaryArithmeticExpression;
import de.fzi.gast.expressions.Variable;
import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.Branch;
import de.fzi.gast.statements.BranchStatement;
import de.fzi.gast.statements.GASTExpression;
import de.fzi.gast.statements.LoopStatement;
import de.fzi.gast.statements.SimpleStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.impl.statementsFactoryImpl;
import de.fzi.gast.statements.statementsFactory;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.ow2.dsrg.fm.qabstractor.Transformer;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;
import org.ow2.dsrg.fm.qabstractor.transformation.Transformation;

public class Abstract
extends Transformation {
    private statementsFactory sFactory = new statementsFactoryImpl();

    public Abstract(MetadataExtractor extractor) {
        super(Logger.getLogger(Transformer.class), extractor);
    }

    @Override
    protected void processLoop(LoopStatement loopStatement) {
        SimpleStatement st;
        super.processLoop(loopStatement);
        if (loopStatement.getBreakConditionExpression() != null) {
            st = this.getStatement(loopStatement.getBreakConditionExpression());
        } else {
            st = this.sFactory.createSimpleStatement();
            st.getAccesses().addAll((Collection)loopStatement.getAccesses());
        }
        if (st != null) {
            BlockStatement outBlock = this.sFactory.createBlockStatement();
            BlockStatement inBlock = this.sFactory.createBlockStatement();
            inBlock.getStatements().add((Object)loopStatement.getBody());
            inBlock.getStatements().add((Object)this.cloneStatement((Statement)st));
            loopStatement.setBody((Statement)inBlock);
            outBlock.getStatements().add((Object)st);
            this.replaceStatement((Statement)loopStatement, (Statement)outBlock);
            outBlock.getStatements().add((Object)loopStatement);
        }
    }

    @Override
    protected void processBranch(BranchStatement branchStatement) {
        super.processBranch(branchStatement);
        BlockStatement bl = this.sFactory.createBlockStatement();
        for (Branch br : branchStatement.getBranches()) {
            Statement st = this.getStatement(br.getConditionExpression());
            if (st == null) continue;
            bl.getStatements().add((Object)st);
        }
        this.replaceStatement((Statement)branchStatement, (Statement)bl);
        bl.getStatements().add((Object)branchStatement);
    }

    @Override
    protected void processSimpleStatement(SimpleStatement simpleStatement) {
        Statement n;
        if (simpleStatement.getExpression() != null && (n = this.getStatement(simpleStatement.getExpression())) != null) {
            this.replaceStatement((Statement)simpleStatement, n);
        }
    }

    protected Statement getStatement(GASTExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof MemberAccessor) {
            return this.ParseMemberAccesor((MemberAccessor)expression);
        }
        if (expression instanceof AssignmentOperatorExpression) {
            return this.getStatement((GASTExpression)((AssignmentOperatorExpression)expression).getRight());
        }
        if (expression instanceof Conditional) {
            return this.ParseConditional((Conditional)expression);
        }
        if (expression instanceof BooleanOperatorExpression) {
            return this.ParseBooleanExpression((BooleanOperatorExpression)expression);
        }
        if (expression instanceof UnaryArithmeticExpression) {
            return this.getStatement((GASTExpression)((UnaryArithmeticExpression)expression).getInner());
        }
        if (expression instanceof NotExpression) {
            return this.getStatement((GASTExpression)((NotExpression)expression).getInner());
        }
        if (expression instanceof CastExpression) {
            return this.getStatement((GASTExpression)((CastExpression)expression).getExpression());
        }
        if (expression instanceof TermExpression) {
            return this.ParseTermExpression((TermExpression)expression);
        }
        if (expression instanceof ProductExpression) {
            return this.ParseProductExpression((ProductExpression)expression);
        }
        if (expression instanceof CompareExpression) {
            return this.ParseCompareExpression((CompareExpression)expression);
        }
        if (expression instanceof Atom) {
            SimpleStatement ret = this.sFactory.createSimpleStatement();
            ret.setExpression(expression);
            return ret;
        }
        throw new UnsupportedOperationException("unknown statement");
    }

    protected Statement ParseMemberAccesor(MemberAccessor memberAccessor) {
        if ((memberAccessor.getLeft() instanceof Variable || memberAccessor.getLeft() instanceof TypeReference) && memberAccessor.getRight() instanceof FunctionCall) {
            SimpleStatement s = this.sFactory.createSimpleStatement();
            s.setExpression((GASTExpression)memberAccessor);
            this.log.info((Object)("create: " + s.getId()));
            if (((FunctionCall)memberAccessor.getRight()).getParameterexpression() != null && ((FunctionCall)memberAccessor.getRight()).getParameterexpression().size() > 0) {
                BlockStatement bl = this.sFactory.createBlockStatement();
                for (GASTExpression ge : ((FunctionCall)memberAccessor.getRight()).getParameterexpression()) {
                    bl.getStatements().add((Object)this.getStatement(ge));
                }
                bl.getStatements().add((Object)s);
                return bl;
            }
            return s;
        }
        if (memberAccessor.getLeft() instanceof MemberAccessor) {
            return null;
        }
        return null;
    }

    protected Statement ParseConditional(Conditional conditional) {
        Statement cond = this.getStatement((GASTExpression)conditional.getCondition());
        Statement then = this.getStatement((GASTExpression)conditional.getThen());
        Statement other = this.getStatement((GASTExpression)conditional.getElse());
        BranchStatement branchStatement = this.sFactory.createBranchStatement();
        if (then != null) {
            Branch branchPositive = this.sFactory.createBranch();
            branchPositive.setStatement(then);
            branchStatement.getBranches().add((Object)branchPositive);
        }
        if (other != null) {
            Branch branchNegative = this.sFactory.createBranch();
            branchNegative.setStatement(other);
            branchStatement.getBranches().add((Object)branchNegative);
        }
        BlockStatement result = this.sFactory.createBlockStatement();
        if (cond != null) {
            result.getStatements().add((Object)cond);
        }
        if (!branchStatement.getBranches().isEmpty()) {
            result.getStatements().add((Object)branchStatement);
        }
        return result;
    }

    protected Statement ParseBooleanExpression(BooleanOperatorExpression booleanOperatorExpression) {
        Statement result = this.getStatement((GASTExpression)booleanOperatorExpression.getLeft());
        Statement right = this.getStatement((GASTExpression)booleanOperatorExpression.getRight());
        if (right != null) {
            Branch branch = this.sFactory.createBranch();
            branch.setStatement(right);
            BranchStatement branchStatement = this.sFactory.createBranchStatement();
            branchStatement.getBranches().add((Object)branch);
            if (result != null) {
                BlockStatement block = this.sFactory.createBlockStatement();
                block.getStatements().add((Object)result);
                block.getStatements().add((Object)branchStatement);
                result = block;
            } else {
                result = branchStatement;
            }
        }
        return result;
    }

    protected Statement ParseTermExpression(TermExpression termExpression) {
        Statement left = this.getStatement((GASTExpression)termExpression.getLeft());
        Statement right = this.getStatement((GASTExpression)termExpression.getRight());
        return this.createFromTwoExpressions(left, right);
    }

    protected Statement ParseProductExpression(ProductExpression productExpression) {
        Statement left = this.getStatement((GASTExpression)productExpression.getLeft());
        Statement right = this.getStatement((GASTExpression)productExpression.getRight());
        return this.createFromTwoExpressions(left, right);
    }

    protected Statement ParseCompareExpression(CompareExpression compareExpression) {
        Statement left = this.getStatement((GASTExpression)compareExpression.getLeft());
        Statement right = this.getStatement((GASTExpression)compareExpression.getRight());
        return this.createFromTwoExpressions(left, right);
    }

    protected Statement createFromTwoExpressions(Statement first, Statement second) {
        if (first != null && second != null) {
            BlockStatement b = this.sFactory.createBlockStatement();
            b.getStatements().add((Object)first);
            b.getStatements().add((Object)second);
            this.log.info((Object)("create: " + b.getId()));
            return b;
        }
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        return null;
    }
}

