/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor.extract;

import de.fzi.gast.core.Root;
import de.fzi.gast.functions.Method;
import de.fzi.gast.types.GASTClass;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractorImpl;
import org.ow2.dsrg.fm.qabstractor.utils.ClassFinder;

public class SpecFileLoader {
    private static MetadataExtractorImpl result;
    private static String currentComponent;
    private static ActiveItem activeItem;
    private static final Pattern component;
    private static final Pattern implclass;
    private static final Pattern required;
    private static final Pattern provided;
    private static Root root;

    static {
        component = Pattern.compile("^\\s*component\\s*:.*");
        implclass = Pattern.compile("^\\s*classes\\s*:.*");
        required = Pattern.compile("^\\s*required\\s*:.*");
        provided = Pattern.compile("^\\s*provided\\s*:.*");
    }

    public static MetadataExtractor loadSpecFile(String path, Root gastRoot) throws IOException {
        root = gastRoot;
        result = new MetadataExtractorImpl();
        FileInputStream fstream = new FileInputStream(path);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String line = br.readLine();
            while (line != null) {
                SpecFileLoader.parseLine(line);
                line = br.readLine();
            }
        }
        finally {
            br.close();
        }
        return result;
    }

    private static void parseLine(String line) {
        if ((line = line.trim()).contains(":")) {
            SpecFileLoader.parseMeta(line);
        } else {
            SpecFileLoader.parseValue(line);
        }
    }

    private static void parseMeta(String line) {
        if (component.matcher(line).matches()) {
            activeItem = ActiveItem.COMPONENT;
        } else if (implclass.matcher(line).matches()) {
            activeItem = ActiveItem.IMPLCLASS;
        } else if (required.matcher(line).matches()) {
            activeItem = ActiveItem.REQUIRED;
        } else if (provided.matcher(line).matches()) {
            activeItem = ActiveItem.PROVIDED;
        } else {
            throw new RuntimeException("unknown element " + line);
        }
        String value = line.substring(line.indexOf(":") + 1).trim();
        if (!value.isEmpty()) {
            SpecFileLoader.parseValue(value);
        }
    }

    private static void parseValue(String line) {
        if (line.isEmpty()) {
            return;
        }
        switch (activeItem) {
            case COMPONENT: {
                currentComponent = line;
                break;
            }
            case IMPLCLASS: {
                GASTClass cl = ClassFinder.getClassByQualifiedName(root, line);
                if (cl == null) break;
                result.addImplClass(currentComponent, cl);
                break;
            }
            case PROVIDED: {
                if (!line.contains("->")) {
                    Logger.getAnonymousLogger().severe("line doesn't contain provide interface. Skipping");
                    return;
                }
                String[] tmp = line.split("->");
                Method m = ClassFinder.findMethod(root, line = tmp[0].trim());
                if (m == null) break;
                result.addProvidedMethod(currentComponent, m, tmp[1].trim());
                break;
            }
            case REQUIRED: {
                if (!line.contains("->")) {
                    Logger.getAnonymousLogger().severe("line doesn't contain require interface. Skipping");
                    return;
                }
                String[] tmp2 = line.split("->");
                GASTClass clr = ClassFinder.getClassByQualifiedName(root, line = tmp2[0].trim());
                if (clr != null) {
                    for (Method mrc : clr.getMethods()) {
                        result.addRequiredMethod(currentComponent, mrc, tmp2[1].trim());
                    }
                    break;
                }
                Method mr = ClassFinder.findMethod(root, line);
                if (mr == null) break;
                result.addRequiredMethod(currentComponent, mr, tmp2[1].trim());
            }
        }
    }

    private SpecFileLoader() {
    }

    private static enum ActiveItem {
        COMPONENT,
        IMPLCLASS,
        REQUIRED,
        PROVIDED;

    }
}

