/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor.extract;

import de.fzi.gast.functions.Method;
import de.fzi.gast.types.GASTClass;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ow2.dsrg.fm.qabstractor.Settings;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;

public class MetadataExtractorImpl
implements MetadataExtractor {
    private Map<String, ComponentInfo> components = new HashMap<String, ComponentInfo>();

    private ComponentInfo getComponentInfo(String cName) {
        ComponentInfo ci = this.components.get(cName);
        if (ci == null) {
            ci = new ComponentInfo(cName);
            this.components.put(cName, ci);
        }
        return ci;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Architectural info:\n");
        for (ComponentInfo ci : this.components.values()) {
            ci.toStringBuffer(sb);
        }
        return sb.toString();
    }

    @Override
    public void addImplClasses(String cName, Collection<GASTClass> implCl) {
        this.getComponentInfo(cName).addImplClasses(implCl);
    }

    public void addImplClass(String cName, GASTClass implCl) {
        this.getComponentInfo(cName).addImplClass(implCl);
    }

    public void addProvidedMethods(String cname, Map<Method, String> providedMethods) {
        this.getComponentInfo(cname).addProvidedMethods(providedMethods);
    }

    public void addProvidedMethod(String cname, Method m, String modelName) {
        this.getComponentInfo(cname).addProvidedMethod(m, modelName);
    }

    public void addRequiredMethod(String cname, Method m, String modelName) {
        this.getComponentInfo(cname).addRequiredMethod(m, modelName);
    }

    public void addRequiredMethods(String cname, Map<Method, String> requiredMethods) {
        this.getComponentInfo(cname).addRequiredMethods(requiredMethods);
    }

    @Override
    public Set<GASTClass> getImplClasses(String name) {
        return this.components.get(name).getImplClasses();
    }

    @Override
    public Set<Method> getProvidedMethods(String name) {
        return this.components.get(name).getProvidedMethods().keySet();
    }

    @Override
    public Set<Method> getRequiredMethods(String name) {
        return this.components.get(name).getRequiredMethods().keySet();
    }

    @Override
    public Set<String> getComponents() {
        return this.components.keySet();
    }

    @Override
    public String getInterfaceForProvidedMethod(String component, Method method) {
        HashMap providedMethods = this.components.get(component).providedMethods;
        for (Method m : providedMethods.keySet()) {
            if (!m.getSimpleName().equals(method.getSimpleName())) continue;
            return (String)providedMethods.get(m);
        }
        if (method.getSimpleName().matches("Thread_.*_run")) {
            return "Thread";
        }
        assert (false) : "Cannot find the interface for a method which is provided";
        return "interface";
    }

    @Override
    public String getInterfaceForRequiredMethod(String component, Method method) {
        HashMap requiredMethods = this.components.get(component).requiredMethods;
        String result = (String)requiredMethods.get(method);
        if (result == null) {
            assert (false) : "Cannot find the interface for a method which is required";
            return "interface";
        }
        return result;
    }

    @Override
    public boolean isKnown(GASTClass c) {
        for (ComponentInfo ci : this.components.values()) {
            if (!ci.implClasses.contains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setExtractedClass(String componentName, GASTClass c) {
        this.components.get(componentName).setExtractedClass(c);
    }

    @Override
    public GASTClass getExtractedClass(String componentName) {
        return this.components.get(componentName).getExtractedClass();
    }

    public static class ComponentInfo {
        private String component;
        private Set<GASTClass> implClasses = new HashSet<GASTClass>();
        private GASTClass extractedClass;
        private HashMap<Method, String> requiredMethods = new HashMap();
        private HashMap<Method, String> providedMethods = new HashMap();

        public ComponentInfo(String cName) {
            this.component = cName;
        }

        public void addImplClass(GASTClass implClass) {
            this.implClasses.add(implClass);
            this.addImplClasses((Collection<GASTClass>)implClass.getInnerClasses());
            if (Settings.instance().isIncludeInterface()) {
                for (GASTClass gc : implClass.getSuperTypes()) {
                    if (!gc.isInterface()) continue;
                    this.addImplClass(gc);
                }
            }
        }

        public void addImplClasses(Collection<GASTClass> _implClasses) {
            for (GASTClass cls : _implClasses) {
                this.addImplClass(cls);
            }
        }

        public void addProvidedMethod(Method m, String modelName) {
            this.providedMethods.put(m, modelName);
        }

        public void addProvidedMethods(Map<Method, String> _providedMethods) {
            this.providedMethods.putAll(_providedMethods);
        }

        public void addRequiredMethod(Method m, String modelName) {
            this.requiredMethods.put(m, modelName);
        }

        public void addRequiredMethods(Map<Method, String> _requiredMethods) {
            this.requiredMethods.putAll(_requiredMethods);
        }

        public Set<GASTClass> getImplClasses() {
            return Collections.unmodifiableSet(this.implClasses);
        }

        public Map<Method, String> getProvidedMethods() {
            return Collections.unmodifiableMap(this.providedMethods);
        }

        public Map<Method, String> getRequiredMethods() {
            return Collections.unmodifiableMap(this.requiredMethods);
        }

        private void appendMethodInfo(StringBuffer sb, Method m) {
            sb.append(String.valueOf(m.getSurroundingClass().getSimpleName()) + "::" + m.getSimpleName() + " ");
        }

        public void toStringBuffer(StringBuffer sb) {
            sb.append("Component: " + this.component + "\n");
            sb.append("\t implemented by: " + this.implClasses + "\n");
            sb.append("\t provided methods: ");
            for (Method m : this.providedMethods.keySet()) {
                this.appendMethodInfo(sb, m);
            }
            sb.append("\n");
            sb.append("\t required methods: ");
            for (Method m : this.requiredMethods.keySet()) {
                this.appendMethodInfo(sb, m);
            }
            sb.append("\n");
        }

        public void setExtractedClass(GASTClass c) {
            this.extractedClass = c;
        }

        public GASTClass getExtractedClass() {
            return this.extractedClass;
        }
    }
}

