/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor.extract;

import de.fzi.gast.core.File;
import de.fzi.gast.functions.Method;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.types.Member;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.sourcecodedecorator.FileLevelSourceCodeLink;
import eu.qimpress.sourcecodedecorator.MethodLevelSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractorImpl;

public class GastServiceExtractorLoader {
    private SourceCodeDecoratorRepository sourceCodeDecoratorRepository;
    private Set<String> components = new HashSet<String>();
    private Map<String, Set<GASTClass>> implClasses = new HashMap<String, Set<GASTClass>>();
    private Map<String, Map<Method, String>> requiredMethods = new HashMap<String, Map<Method, String>>();
    private Map<String, Map<Method, String>> providedMethods = new HashMap<String, Map<Method, String>>();

    public GastServiceExtractorLoader(SourceCodeDecoratorRepository sourceCodeDecoratorRepository) {
        this.sourceCodeDecoratorRepository = sourceCodeDecoratorRepository;
    }

    public MetadataExtractor load() {
        MetadataExtractorImpl result = new MetadataExtractorImpl();
        this.processComponents(result);
        return result;
    }

    private void processComponents(MetadataExtractorImpl result) {
        this.components.clear();
        this.implClasses.clear();
        this.requiredMethods.clear();
        this.providedMethods.clear();
        for (FileLevelSourceCodeLink codeLink : this.sourceCodeDecoratorRepository.getFileLevelSourceCodeLink()) {
            if (codeLink.getFile() == null) continue;
            File f = codeLink.getFile();
            ComponentType ctype = codeLink.getComponentType();
            String componentName = ctype.getName();
            this.components.add(componentName);
            HashSet<GASTClass> implClasses = new HashSet<GASTClass>();
            for (GASTType clas : f.getTypes()) {
                if (!(clas instanceof GASTClass)) continue;
                implClasses.add((GASTClass)clas);
            }
            result.addImplClasses(componentName, implClasses);
            this.processMethods(ctype, result);
        }
    }

    private void processMethods(ComponentType ctype, MetadataExtractorImpl result) {
        String componentName = ctype.getName();
        result.addProvidedMethods(componentName, this.processInterfacePort((EList<InterfacePort>)ctype.getProvided(), false));
        result.addRequiredMethods(componentName, this.processInterfacePort((EList<InterfacePort>)ctype.getRequired(), true));
    }

    private Map<Method, String> processInterfacePort(EList<InterfacePort> ports, boolean propagateToOverriden) {
        HashMap<Method, String> result = new HashMap<Method, String>();
        for (InterfacePort port : ports) {
            Interface i = port.getInterfaceType();
            String iname = i.getName();
            for (Operation o : i.getSignatures()) {
                Method m = this.findMethod(o);
                result.put(m, iname);
                if (!propagateToOverriden) continue;
                Member overriden = null;
                while ((overriden = m.getOverriddenMember()) != null) {
                    m = (Method)overriden;
                    result.put(m, iname);
                }
            }
        }
        return result;
    }

    private Method findMethod(Operation operation) {
        for (MethodLevelSourceCodeLink link : this.sourceCodeDecoratorRepository.getMethodLevelSourceCodeLink()) {
            if (!link.getOperation().equals(operation)) continue;
            Method retItem = (Method)link.getFunction();
            return retItem;
        }
        return null;
    }
}

