/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor.extract;

import de.fzi.gast.accesses.BaseAccess;
import de.fzi.gast.accesses.CompositeAccess;
import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.functions.Constructor;
import de.fzi.gast.statements.SimpleStatement;
import de.fzi.gast.types.GASTClass;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.ow2.dsrg.fm.qabstractor.Settings;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;
import org.ow2.dsrg.fm.qabstractor.transformation.Transformation;
import org.ow2.dsrg.fm.qabstractor.utils.ClassComparator;

public class ClassExtractor {
    public static void extractClasses(MetadataExtractor extr) {
        Extract extract = new Extract(extr);
        for (String component : extr.getComponents()) {
            extract.processComponent(component);
            extr.addImplClasses(component, extract.getResult());
        }
    }

    private ClassExtractor() {
    }

    private static class Extract
    extends Transformation {
        private Set<GASTClass> result;
        private List<GASTClass> stack;

        Extract(MetadataExtractor extr) {
            super(Logger.getLogger(ClassExtractor.class), extr);
        }

        public Set<GASTClass> getResult() {
            return this.result;
        }

        @Override
        public void processComponent(String componentName) {
            this.result = new TreeSet<GASTClass>(new ClassComparator());
            this.stack = new LinkedList<GASTClass>(this.extractor.getImplClasses(componentName));
            while (!this.stack.isEmpty()) {
                GASTClass cl = this.stack.get(0);
                this.stack.remove(0);
                if (this.result.contains(cl)) continue;
                this.log.debug((Object)("add class " + cl.getQualifiedName() + " to component " + componentName));
                this.result.add(cl);
                if (!cl.getInnerClasses().isEmpty()) {
                    this.stack.addAll((Collection<GASTClass>)cl.getInnerClasses());
                }
                if (Settings.instance().isIncludeInterface()) {
                    for (GASTClass gc : cl.getSuperTypes()) {
                        if (!gc.isInterface()) continue;
                        this.stack.add(gc);
                    }
                }
                this.processClass(cl);
            }
        }

        @Override
        public void processClass(GASTClass clas) {
            super.processClass(clas);
            for (Constructor c : clas.getConstructors()) {
                if (c.getBody() == null) continue;
                this.processBlock(c.getBody());
            }
        }

        @Override
        protected void processSimpleStatement(SimpleStatement simpleStatement) {
            super.processSimpleStatement(simpleStatement);
            for (BaseAccess a : simpleStatement.getAccesses()) {
                this.findClass(a);
            }
        }

        private void findClass(BaseAccess access) {
            GASTClass cls;
            FunctionAccess fa;
            if (access instanceof CompositeAccess) {
                for (BaseAccess ac : ((CompositeAccess)access).getAccesses()) {
                    this.findClass(ac);
                }
            } else if (access instanceof FunctionAccess && (fa = (FunctionAccess)access).getTargetFunction() instanceof Constructor && !this.extractor.isKnown(cls = ((Constructor)fa.getTargetFunction()).getSurroundingClass())) {
                this.stack.add(cls);
            }
        }
    }
}

