/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor;

import de.fzi.gast.core.Root;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.ow2.dsrg.fm.qabstractor.Settings;
import org.ow2.dsrg.fm.qabstractor.exception.CodeException;
import org.ow2.dsrg.fm.qabstractor.extract.ClassExtractor;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;
import org.ow2.dsrg.fm.qabstractor.pointsto.DummyRuntimeClassResolver;
import org.ow2.dsrg.fm.qabstractor.transformation.Abstract;
import org.ow2.dsrg.fm.qabstractor.transformation.Clean;
import org.ow2.dsrg.fm.qabstractor.transformation.Inline;
import org.ow2.dsrg.fm.qabstractor.transformation.JumpReplacer;
import org.ow2.dsrg.fm.qabstractor.transformation.ToTBP;
import org.ow2.dsrg.fm.tbplib.architecture.Component;
import org.ow2.dsrg.fm.tbplib.node.TBPSpecification;
import org.ow2.dsrg.fm.tbplib.util.CodeWriter;
import org.ow2.dsrg.fm.tbplib.util.TransformationChain;

public class Transformer {
    public static void exportToXML(Root root, String outputFile) throws IOException {
        Root eobj = root;
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        URI uri = URI.createFileURI((String)outputFile);
        Resource resource = rs.createResource(uri);
        resource.getContents().add((Object)eobj);
        resource.save(null);
    }

    public static List<TBPSpecification<String>> transform(String filePrefix, Root r, MetadataExtractor extractor, SourceCodeDecoratorRepository scdrep) throws IOException, CodeException {
        ClassExtractor.extractClasses(extractor);
        Inline inline = new Inline(extractor, new DummyRuntimeClassResolver(r), r);
        Abstract abstrac = new Abstract(extractor);
        JumpReplacer jr = new JumpReplacer(extractor);
        LinkedList<TBPSpecification<String>> ret = new LinkedList<TBPSpecification<String>>();
        Logger logger = Logger.getLogger(Transformer.class);
        logger.info((Object)"==============================================================");
        logger.info((Object)"Q-Abstractor");
        logger.info((Object)"Copyright (C) 2009  DSRG, Charles University in Prague");
        logger.info((Object)"http://dsrg.mff.cuni.cz/");
        logger.info((Object)"==============================================================");
        for (String component : extractor.getComponents()) {
            try {
                logger.info((Object)("Process component " + component));
                logger.debug((Object)"Start abstracting ... ");
                abstrac.processComponent(component);
                if (Settings.instance().isReplacedReturns()) {
                    logger.debug((Object)"Start replacing returns ...");
                    jr.processComponent(component);
                }
                logger.debug((Object)"Start inlining ...");
                inline.processComponent(component);
                logger.debug((Object)"Start cleaning ...");
                Clean cleaner = new Clean(extractor);
                cleaner.processClass(extractor.getExtractedClass(component));
                logger.debug((Object)"Start creating TBP ...");
                ToTBP gparser = new ToTBP();
                TBPSpecification<String> res = gparser.createComponentSpecification(extractor, component, scdrep);
                ret.add(res);
                logger.debug((Object)"Start writing TBP ...");
                String filename = Transformer.createFilename(filePrefix, new String(component));
                CodeWriter wr = new CodeWriter(String.valueOf(filename) + ".tbp");
                TransformationChain.printTBP((CodeWriter)wr, res, (Component)new Component(component, new LinkedList()));
                wr.close();
                logger.debug((Object)("Finish analyzing component " + component));
            }
            catch (CodeException e) {
                logger.warn((Object)("Warning - recursive method call, no protocol for '" + component + "' will be created: " + e.getMessage()));
            }
        }
        return ret;
    }

    private Transformer() {
    }

    private static String createFilename(String filePrefix, String src) {
        src = Transformer.fixName(src);
        return String.valueOf(filePrefix) + File.separator + src;
    }

    public static String fixName(String src) {
        src = src.replaceAll("<", "_");
        src = src.replaceAll(">", "_");
        src = src.replaceAll(" ", "_");
        src = src.replaceAll("\\.", "_");
        return src;
    }
}

