/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class Settings {
    private boolean replacedReturns = true;
    private String pointsTo = "dummy";
    private boolean includeInterface = true;
    private static Settings instance;

    public void loadFromFile(String file) throws IOException, ConfigurationError {
        FileInputStream fstream = new FileInputStream(file);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String line = br.readLine();
            while (line != null) {
                if (!line.matches("^\\s*#.*") && !line.trim().isEmpty()) {
                    String[] elem = line.split("=", 2);
                    if (elem.length != 2) {
                        throw new InvalidLine(line);
                    }
                    try {
                        switch (Options.valueOf(elem[0])) {
                            case INCLUDE_INTERFACE: {
                                this.includeInterface = Boolean.valueOf(elem[1].trim());
                                break;
                            }
                            case POINTS_TO: {
                                this.pointsTo = elem[1].trim();
                                break;
                            }
                            case REPLACED_RETURNS: {
                                this.replacedReturns = Boolean.valueOf(elem[1].trim());
                                break;
                            }
                            default: {
                                assert (false) : "Unknown option from enum";
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new UnknownOption(elem[0]);
                    }
                    catch (Exception exception) {
                        throw new InvalidValue(elem[0], elem[1]);
                    }
                }
                line = br.readLine();
            }
        }
        finally {
            br.close();
        }
    }

    public static Settings instance() {
        if (instance == null) {
            instance = new Settings();
        }
        return instance;
    }

    private Settings() {
    }

    public String getPointsTo() {
        return this.pointsTo;
    }

    public void setPointsTo(String pointsTo) {
        this.pointsTo = pointsTo;
    }

    public boolean isReplacedReturns() {
        return this.replacedReturns;
    }

    public void setReplacedReturns(boolean replacedReturns) {
        this.replacedReturns = replacedReturns;
    }

    public boolean isIncludeInterface() {
        return this.includeInterface;
    }

    public void setIncludeInterface(boolean includeInterface) {
        this.includeInterface = includeInterface;
    }

    public class ConfigurationError
    extends Exception {
        protected ConfigurationError(String message) {
            super(message);
        }
    }

    public class InvalidLine
    extends ConfigurationError {
        public InvalidLine(String line) {
            super("Line " + line + " from configuration file is not recognized as configuration line");
        }
    }

    public class InvalidValue
    extends ConfigurationError {
        public InvalidValue(String variable, String value) {
            super("Variable " + variable + " from configuration file has invalid value " + value);
        }
    }

    private static enum Options {
        REPLACED_RETURNS,
        POINTS_TO,
        INCLUDE_INTERFACE;

    }

    public class UnknownOption
    extends ConfigurationError {
        public UnknownOption(String variable) {
            super("Variable " + variable + " from configuration file is unknown");
        }
    }
}

