/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.reverseengineering.gast2seff.visitors;

import de.fzi.gast.accesses.BaseAccess;
import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.statements.SimpleStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.types.GASTClass;
import eu.qimpress.reverseengineering.gast2seff.visitors.BasicFunctionClassificationStrategy;
import eu.qimpress.reverseengineering.gast2seff.visitors.FunctionCallClassificationVisitor;
import eu.qimpress.reverseengineering.gast2seff.visitors.IFunctionClassificationStrategy;
import java.util.BitSet;
import org.apache.log4j.Logger;

public abstract class AbstractFunctionClassificationStrategy
implements IFunctionClassificationStrategy {
    private Logger logger = Logger.getLogger(BasicFunctionClassificationStrategy.class);

    @Override
    public BitSet classifySimpleStatement(SimpleStatement object) {
        BitSet result = new BitSet();
        FunctionAccess functionAccess = this.getFunctionAccess(object);
        if (functionAccess != null) {
            if (this.isExternalCall(functionAccess)) {
                this.logger.debug((Object)("Found external call: " + functionAccess.getTargetFunction().getSimpleName()));
                result.set(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EXTERNAL));
            } else if (this.isLibraryCall(functionAccess)) {
                this.logger.debug((Object)("Found library call: " + functionAccess.getTargetFunction().getSimpleName()));
                result.set(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.LIBRARY));
            } else {
                this.logger.debug((Object)("Found internal call: " + functionAccess.getTargetFunction().getSimpleName()));
                result.set(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.INTERNAL));
            }
        }
        return result;
    }

    @Override
    public void mergeFunctionCallType(BitSet myType, BitSet functionCallType) {
        myType.or(functionCallType);
    }

    protected abstract boolean isExternalCall(FunctionAccess var1);

    protected abstract boolean isLibraryCall(FunctionAccess var1);

    protected GASTClass findHostingClass(Statement statement) {
        Statement current = statement;
        while (current != null && !(current instanceof GASTClass)) {
            current = current.eContainer();
        }
        return (GASTClass)current;
    }

    private FunctionAccess getFunctionAccess(SimpleStatement object) {
        for (BaseAccess a : object.getAccesses()) {
            if (!(a instanceof FunctionAccess)) continue;
            return (FunctionAccess)a;
        }
        return null;
    }
}

