/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.reverseengineering.gast2seff.jobs;

import de.fzi.gast.statements.BlockStatement;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import eu.qimpress.qimpressgast.GASTBehaviour;
import eu.qimpress.qimpressgast.GASTBehaviourRepository;
import eu.qimpress.reverseengineering.gast2seff.jobs.DefaultQosAnnotationsBuilder;
import eu.qimpress.reverseengineering.gast2seff.visitors.BasicFunctionClassificationStrategy;
import eu.qimpress.reverseengineering.gast2seff.visitors.FunctionCallClassificationVisitor;
import eu.qimpress.reverseengineering.gast2seff.visitors.GastStatementVisitor;
import eu.qimpress.samm.behaviour.Behaviour;
import eu.qimpress.samm.behaviour.BehaviourFactory;
import eu.qimpress.samm.behaviour.GastBehaviourStub;
import eu.qimpress.samm.behaviour.SeffBehaviourStub;
import eu.qimpress.samm.qosannotation.QosAnnotations;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.seff.AbstractAction;
import eu.qimpress.seff.ResourceDemandingBehaviour;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.SeffRepository;
import eu.qimpress.seff.StartAction;
import eu.qimpress.seff.StopAction;
import eu.qimpress.seff.seffFactory;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;

public class GAST2SEFFJob
implements IJob {
    private Logger logger = Logger.getLogger(GAST2SEFFJob.class);
    private ResourceSet resourceSet = new ResourceSetImpl();
    private Resource sammInstance = null;
    private Resource gastInstance = null;
    private Resource gastBehaviourRepository = null;
    private Resource seffBehaviourRepository = null;
    private Resource sammQosAnnotations = null;
    private GASTBehaviourRepository gastBehaviourRepositoryModel = null;
    private Resource sourceCodeDecorator = null;
    private SourceCodeDecoratorRepository sourceCodeDecoratorModel = null;
    private QosAnnotations sammQosAnnotationsModel = null;
    private static final String SEFF_BEHAVIOUR_EXTENSION = "samm_seff";
    private static final String GAST_BEHAVIOUR_EXTENSION = "samm_gastbehaviour";
    private static final String GAST_EXTENSION = "gast";
    private static final String SAMM_QOS_ANNOTATIONS = "samm_qosannotation";
    private static final String SOURCE_CODE_DECORATOR_EXTENSION = "sourcecodedecorator";
    private FunctionCallClassificationVisitor typeVisitor = null;
    private URI sammInstanceURI;
    private URI gastBehaviourRepositoryURI;
    private URI seffBehaviourRepositoryURI;
    private URI sammQosAnnotationsURI;
    private URI sourceCodeDecoratorURI;
    private HashMap<String, EObject> idToeObjectMap;
    private HashMap<Object, Object> xmlNameToFeatureMap;

    public GAST2SEFFJob(URI sammInstanceURI) {
        this(sammInstanceURI, sammInstanceURI.trimFileExtension().appendFileExtension(GAST_BEHAVIOUR_EXTENSION), sammInstanceURI.trimFileExtension().appendFileExtension(SEFF_BEHAVIOUR_EXTENSION), sammInstanceURI.trimFileExtension().appendFileExtension(SAMM_QOS_ANNOTATIONS), sammInstanceURI.trimFileExtension().appendFileExtension(SOURCE_CODE_DECORATOR_EXTENSION));
    }

    public GAST2SEFFJob(URI sammInstanceURI, URI gastBehaviourRepositoryURI, URI seffBehaviourRepositoryURI, URI sammQosAnnotationsURI, URI sourceCodeDecoratorURI) {
        HashMap cache = new HashMap();
        ((ResourceSetImpl)this.resourceSet).setURIResourceMap(cache);
        this.idToeObjectMap = new HashMap();
        this.xmlNameToFeatureMap = new HashMap();
        this.sammInstanceURI = sammInstanceURI;
        this.gastBehaviourRepositoryURI = gastBehaviourRepositoryURI;
        this.seffBehaviourRepositoryURI = seffBehaviourRepositoryURI;
        this.sammQosAnnotationsURI = sammQosAnnotationsURI;
        this.sourceCodeDecoratorURI = sourceCodeDecoratorURI;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        if (this.sammInstanceURI.isEmpty() || !this.sammInstanceURI.isFile() || this.gastBehaviourRepositoryURI.isEmpty() || !this.gastBehaviourRepositoryURI.isFile()) {
            String error = "missing model files (samm or gast behaviour repository) to apply GAST2SEFF";
            this.logger.error((Object)error);
            throw new JobFailedException(error);
        }
        monitor.subTask("loading models from resources");
        this.sammInstance = this.loadResource(this.sammInstanceURI, false);
        URI gastURI = this.sammInstanceURI.trimFileExtension().appendFileExtension(GAST_EXTENSION);
        this.gastInstance = this.loadResource(gastURI, true);
        this.gastBehaviourRepository = this.loadResource(this.gastBehaviourRepositoryURI, false);
        this.gastBehaviourRepositoryModel = (GASTBehaviourRepository)this.gastBehaviourRepository.getContents().get(0);
        this.sammQosAnnotations = this.loadResource(this.sammQosAnnotationsURI, false);
        this.sammQosAnnotationsModel = (QosAnnotations)this.sammQosAnnotations.getContents().get(0);
        this.sourceCodeDecorator = this.loadResource(this.sourceCodeDecoratorURI, false);
        this.sourceCodeDecoratorModel = (SourceCodeDecoratorRepository)this.sourceCodeDecorator.getContents().get(0);
        this.seffBehaviourRepository = this.createResource(this.seffBehaviourRepositoryURI);
        SeffRepository seffRepository = seffFactory.eINSTANCE.createSeffRepository();
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
        subMonitor.setTaskName("Creating SEFF behaviour");
        TreeIterator iterator = this.sammInstance.getAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof GastBehaviourStub)) continue;
            String name = ((GastBehaviourStub)eObject).getName();
            this.logger.info((Object)("Found GAST behaviour, generating SEFF behaviour for it: " + name));
            ResourceDemandingSEFF resourceDemandingSEFF = this.generateSEFFForGASTBehaviour((GastBehaviourStub)eObject);
            seffRepository.getResourceDemandingSeff().add((Object)resourceDemandingSEFF);
            monitor.worked(1);
        }
        DefaultQosAnnotationsBuilder qosAnnotationBuilder = new DefaultQosAnnotationsBuilder(this.sammQosAnnotationsModel, seffRepository);
        qosAnnotationBuilder.buildDefaultQosAnnotations();
        subMonitor.done();
        monitor.subTask("saving models");
        this.saveResources(seffRepository);
    }

    private void saveResources(SeffRepository seffRepository) throws JobFailedException {
        this.seffBehaviourRepository.getContents().add((Object)seffRepository);
        this.saveResource(this.seffBehaviourRepository);
        this.saveResource(this.sammInstance);
        this.saveResource(this.sammQosAnnotations);
        this.saveResource(this.gastBehaviourRepository);
    }

    public String getName() {
        return "GAST2SEFF Transformation Job";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    private Resource loadResource(URI uri, boolean loadFailAcceptable) throws JobFailedException {
        this.logger.debug((Object)("load start " + uri));
        Resource resource = this.resourceSet.createResource(uri);
        Map loadOptions = ((XMIResourceImpl)resource).getDefaultLoadOptions();
        loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", this.xmlNameToFeatureMap);
        ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(this.idToeObjectMap);
        try {
            resource.load(loadOptions);
        }
        catch (IOException e) {
            if (loadFailAcceptable) {
                this.logger.warn((Object)"Loading of a required resource failed. This could result in a reduced model loading performance.", (Throwable)e);
            }
            throw new JobFailedException("Loading of a required resource failed", (Throwable)e);
        }
        this.logger.debug((Object)"load end");
        return resource;
    }

    private Resource createResource(URI uri) {
        Resource resource = this.resourceSet.createResource(uri);
        return resource;
    }

    private void saveResource(Resource resource) throws JobFailedException {
        try {
            resource.save(new HashMap());
        }
        catch (IOException e) {
            throw new JobFailedException("Saving model output failed", (Throwable)e);
        }
    }

    private ResourceDemandingSEFF createSeff(GastBehaviourStub gastBehaviourStub, ResourceDemandingSEFF seff) throws JobFailedException {
        StartAction start = seffFactory.eINSTANCE.createStartAction();
        StopAction stop = seffFactory.eINSTANCE.createStopAction();
        PrimitiveComponent primitiveComponent = (PrimitiveComponent)gastBehaviourStub.eContainer();
        this.typeVisitor = new FunctionCallClassificationVisitor(new BasicFunctionClassificationStrategy(this.sourceCodeDecoratorModel, primitiveComponent));
        seff.getSteps().add((Object)start);
        BlockStatement body = this.findBody(gastBehaviourStub);
        this.logger.trace((Object)("visiting (seff entry): " + gastBehaviourStub.getName()));
        if (body != null) {
            this.typeVisitor.doSwitch((EObject)body);
            GastStatementVisitor visitor = new GastStatementVisitor(this.typeVisitor.getAnnotations(), (ResourceDemandingBehaviour)seff, this.sourceCodeDecoratorModel, primitiveComponent);
            visitor.doSwitch((EObject)body);
        } else {
            this.logger.warn((Object)("Found GAST behaviour (" + gastBehaviourStub.getName() + ") without a method body... Skipping it..."));
        }
        seff.getSteps().add((Object)stop);
        GAST2SEFFJob.connectActions((ResourceDemandingBehaviour)seff);
        return seff;
    }

    private BlockStatement findBody(GastBehaviourStub gastBehaviourStub) throws JobFailedException {
        assert (this.onlyOnceAsGastBehaviour((EList<GASTBehaviour>)this.gastBehaviourRepositoryModel.getGastbehaviour(), gastBehaviourStub));
        for (GASTBehaviour behaviour : this.gastBehaviourRepositoryModel.getGastbehaviour()) {
            if (!behaviour.getGastbehaviourstub().getId().equals(gastBehaviourStub.getId())) continue;
            return behaviour.getBlockstatement();
        }
        this.logger.warn((Object)("Checked gastBehaviourRepository for " + gastBehaviourStub.getName() + " " + gastBehaviourStub.getId() + " but found none"));
        return null;
    }

    private boolean onlyOnceAsGastBehaviour(EList<GASTBehaviour> gastbehaviour, GastBehaviourStub gastBehaviourStub) {
        int i = 0;
        for (GASTBehaviour behaviour : gastbehaviour) {
            if (!behaviour.getGastbehaviourstub().getId().equals(gastBehaviourStub.getId())) continue;
            ++i;
        }
        return i == 1;
    }

    public static void connectActions(ResourceDemandingBehaviour seff) {
        AbstractAction previous = null;
        for (AbstractAction a : seff.getSteps()) {
            a.setPredecessor_AbstractAction(previous);
            previous = a;
        }
    }

    private ResourceDemandingSEFF generateSEFFForGASTBehaviour(GastBehaviourStub gastBehaviourStub) throws JobFailedException {
        ResourceDemandingSEFF resourceDemandingSEFF = seffFactory.eINSTANCE.createResourceDemandingSEFF();
        this.createSeff(gastBehaviourStub, resourceDemandingSEFF);
        SeffBehaviourStub seffBehaviourStub = this.findOrCreateBehaviourStub(gastBehaviourStub);
        resourceDemandingSEFF.setSeffBehaviourStub(seffBehaviourStub);
        return resourceDemandingSEFF;
    }

    private SeffBehaviourStub findOrCreateBehaviourStub(GastBehaviourStub gastBehaviourStub) {
        PrimitiveComponent parentComponent = (PrimitiveComponent)gastBehaviourStub.eContainer();
        SeffBehaviourStub seffBehaviourStub = null;
        for (Behaviour behaviour : parentComponent.getOperationBehaviour()) {
            SeffBehaviourStub candidateStub;
            if (!(behaviour instanceof SeffBehaviourStub) || (candidateStub = (SeffBehaviourStub)behaviour).getOperation() != gastBehaviourStub.getOperation()) continue;
            this.logger.debug((Object)"Found SEFF behaviour stub, reusing it...");
            seffBehaviourStub = candidateStub;
            break;
        }
        if (seffBehaviourStub == null) {
            seffBehaviourStub = BehaviourFactory.eINSTANCE.createSeffBehaviourStub();
        }
        seffBehaviourStub.setOperation(gastBehaviourStub.getOperation());
        parentComponent.getOperationBehaviour().add((Object)seffBehaviourStub);
        return seffBehaviourStub;
    }
}

