/*
 * Decompiled with CFR 0.152.
 */
package klaper.probability.impl;

import klaper.probability.Constant;
import klaper.probability.Exponential;
import klaper.probability.Geometric;
import klaper.probability.Histogram;
import klaper.probability.HistogramSample;
import klaper.probability.Normal;
import klaper.probability.Poisson;
import klaper.probability.ProbabilityDistributionFunction;
import klaper.probability.ProbabilityFactory;
import klaper.probability.ProbabilityPackage;
import klaper.probability.Uniform;
import klaper.probability.impl.ConstantImpl;
import klaper.probability.impl.ExponentialImpl;
import klaper.probability.impl.GeometricImpl;
import klaper.probability.impl.HistogramImpl;
import klaper.probability.impl.HistogramSampleImpl;
import klaper.probability.impl.NormalImpl;
import klaper.probability.impl.PoissonImpl;
import klaper.probability.impl.ProbabilityDistributionFunctionImpl;
import klaper.probability.impl.UniformImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class ProbabilityFactoryImpl
extends EFactoryImpl
implements ProbabilityFactory {
    public static ProbabilityFactory init() {
        try {
            ProbabilityFactory theProbabilityFactory = (ProbabilityFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.ing.uniroma2.it/klaper/probability/1.0");
            if (theProbabilityFactory != null) {
                return theProbabilityFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ProbabilityFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createProbabilityDistributionFunction();
            }
            case 1: {
                return this.createNormal();
            }
            case 2: {
                return this.createPoisson();
            }
            case 3: {
                return this.createUniform();
            }
            case 4: {
                return this.createExponential();
            }
            case 5: {
                return this.createConstant();
            }
            case 6: {
                return this.createHistogram();
            }
            case 7: {
                return this.createHistogramSample();
            }
            case 8: {
                return this.createGeometric();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    @Override
    public ProbabilityDistributionFunction createProbabilityDistributionFunction() {
        ProbabilityDistributionFunctionImpl probabilityDistributionFunction = new ProbabilityDistributionFunctionImpl();
        return probabilityDistributionFunction;
    }

    @Override
    public Normal createNormal() {
        NormalImpl normal = new NormalImpl();
        return normal;
    }

    @Override
    public Poisson createPoisson() {
        PoissonImpl poisson = new PoissonImpl();
        return poisson;
    }

    @Override
    public Uniform createUniform() {
        UniformImpl uniform = new UniformImpl();
        return uniform;
    }

    @Override
    public Exponential createExponential() {
        ExponentialImpl exponential = new ExponentialImpl();
        return exponential;
    }

    @Override
    public Constant createConstant() {
        ConstantImpl constant = new ConstantImpl();
        return constant;
    }

    @Override
    public Histogram createHistogram() {
        HistogramImpl histogram = new HistogramImpl();
        return histogram;
    }

    @Override
    public HistogramSample createHistogramSample() {
        HistogramSampleImpl histogramSample = new HistogramSampleImpl();
        return histogramSample;
    }

    @Override
    public Geometric createGeometric() {
        GeometricImpl geometric = new GeometricImpl();
        return geometric;
    }

    @Override
    public ProbabilityPackage getProbabilityPackage() {
        return (ProbabilityPackage)this.getEPackage();
    }

    @Deprecated
    public static ProbabilityPackage getPackage() {
        return ProbabilityPackage.eINSTANCE;
    }
}

