/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.ui.dialogs.selection;

import eu.qimpress.ide.ui.dialogs.DialogsImages;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;

public abstract class SelectEObjectDialog
extends TitleAreaDialog {
    protected String resourceName = "";
    private String DIALOG_TITLE = "Select Object...";
    private String DIALOG_WARNUNG_MSG = "model resources must first be loaded";
    private ToolBar toolBar;
    private ToolItem addItem;
    private ToolItem editItem;
    private ToolItem deleteItem;
    private TreeViewer viewer;
    private EObject selection;
    private EObject rootOfSelection;
    private Class<?> providedService;
    private Label label;
    private Button OKbutton;
    private Button CANCELbutton;
    private Button loadResourceButton;

    public SelectEObjectDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(1104);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.DIALOG_TITLE);
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SelectEObjectDialog.this.selection = null;
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FormLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.viewer = new TreeViewer(container, 2048);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection sel = (ITreeSelection)event.getSelection();
                SelectEObjectDialog.this.selection = (EObject)sel.getFirstElement();
                SelectEObjectDialog.this.rootOfSelection = (EObject)sel.getPaths()[0].getFirstSegment();
                SelectEObjectDialog.this.label.setText(((AdapterFactoryLabelProvider)SelectEObjectDialog.this.viewer.getLabelProvider()).getText((Object)SelectEObjectDialog.this.selection));
                if (SelectEObjectDialog.this.selection != null && SelectEObjectDialog.this.rootOfSelection != null && SelectEObjectDialog.this.isInstanceOfProvidedService(SelectEObjectDialog.this.selection)) {
                    SelectEObjectDialog.this.setOkButtonEnabled(true);
                } else {
                    SelectEObjectDialog.this.setOkButtonEnabled(false);
                }
            }
        });
        Tree tree = this.viewer.getTree();
        FormData fd_tree = new FormData();
        fd_tree.bottom = new FormAttachment(100, -61);
        fd_tree.top = new FormAttachment(0, 5);
        fd_tree.left = new FormAttachment(0, 5);
        tree.setLayoutData((Object)fd_tree);
        Label selectedObjectLabel = new Label(container, 0);
        FormData fd_selectedObjectLabel = new FormData();
        fd_selectedObjectLabel.bottom = new FormAttachment(100, -35);
        fd_selectedObjectLabel.top = new FormAttachment((Control)tree, 9, -1);
        fd_selectedObjectLabel.left = new FormAttachment(0, 7);
        fd_selectedObjectLabel.right = new FormAttachment(0, 85);
        selectedObjectLabel.setLayoutData((Object)fd_selectedObjectLabel);
        selectedObjectLabel.setText("Selected object:");
        selectedObjectLabel.setBounds(10, 260, 97, 13);
        this.label = new Label(container, 0);
        FormData fd_label = new FormData();
        fd_label.bottom = new FormAttachment(100, -35);
        fd_label.top = new FormAttachment((Control)tree, 9, -1);
        fd_label.right = new FormAttachment(0, 457);
        fd_label.left = new FormAttachment(0, 100);
        this.label.setLayoutData((Object)fd_label);
        this.label.setText("...");
        this.label.setBounds(113, 260, 188, 13);
        this.toolBar = new ToolBar(container, 512);
        fd_tree.right = new FormAttachment((Control)this.toolBar, -5, 16384);
        FormData fd_toolBar = new FormData();
        fd_toolBar.left = new FormAttachment(100, -29);
        fd_toolBar.right = new FormAttachment(100, -5);
        fd_toolBar.bottom = new FormAttachment(0, 210);
        fd_toolBar.top = new FormAttachment(0, 5);
        this.toolBar.setLayoutData((Object)fd_toolBar);
        this.addItem = new ToolItem(this.toolBar, 8);
        this.addItem.setImage(DialogsImages.imageRegistry.get("add_action"));
        this.addItem.setEnabled(false);
        this.editItem = new ToolItem(this.toolBar, 8);
        this.editItem.setImage(DialogsImages.imageRegistry.get("edit_action"));
        this.editItem.setEnabled(false);
        this.deleteItem = new ToolItem(this.toolBar, 8);
        this.deleteItem.setImage(DialogsImages.imageRegistry.get("delete_action"));
        this.deleteItem.setEnabled(false);
        Label separator = new Label(container, 258);
        FormData fd_separator = new FormData();
        fd_separator.left = new FormAttachment(0, -2);
        fd_separator.right = new FormAttachment(100, 4);
        fd_separator.top = new FormAttachment(100, -7);
        fd_separator.bottom = new FormAttachment(100, 1);
        separator.setLayoutData((Object)fd_separator);
        this.loadResourceButton = new Button(container, 0);
        FormData fd_loadResourceButton = new FormData();
        fd_loadResourceButton.left = new FormAttachment(100, -130);
        fd_loadResourceButton.top = new FormAttachment(100, -33);
        fd_loadResourceButton.bottom = new FormAttachment((Control)separator, -3, -1);
        fd_loadResourceButton.right = new FormAttachment(100, -9);
        this.loadResourceButton.setLayoutData((Object)fd_loadResourceButton);
        this.loadResourceButton.setText("Load Resource...");
        this.loadResourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = e.display.getActiveShell();
                LoadResourceAction.LoadResourceDialog dialog = new LoadResourceAction.LoadResourceDialog(shell);
                dialog.open();
                String uri = dialog.getURIText();
                if (uri != null) {
                    SelectEObjectDialog.this.addModelToResourceSet(shell, uri);
                    SelectEObjectDialog.this.viewer.refresh();
                    SelectEObjectDialog.this.viewer.expandAll();
                }
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.CANCELbutton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.CANCELbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectEObjectDialog.this.selection = null;
            }
        });
        this.OKbutton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.setOkButtonEnabled(false);
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this.selection = null;
    }

    public int open() {
        if (this.resourceName.equals("")) {
            this.setMessage(this.DIALOG_WARNUNG_MSG, 2);
        } else {
            this.setMessage(String.valueOf(this.DIALOG_WARNUNG_MSG) + " (*." + this.resourceName.toLowerCase() + ")", 2);
            this.loadResourceButton.setText("Load " + this.resourceName + "...");
        }
        return super.open();
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.OKbutton.setEnabled(enabled);
        if (this.providedService == null) {
            this.OKbutton.setEnabled(true);
        }
        if (!enabled && this.providedService != null) {
            this.setErrorMessage("No " + this.providedService.getSimpleName() + " selected!");
        } else {
            this.setErrorMessage(null);
            this.setMessage(null, 2);
        }
    }

    protected Point getInitialSize() {
        return new Point(500, 400);
    }

    public void setViewerContentProvider(IContentProvider provider) {
        this.viewer.setContentProvider(provider);
    }

    public void setViewerLabelProvider(IBaseLabelProvider labelProvider) {
        this.viewer.setLabelProvider(labelProvider);
    }

    public void setViewerInput(Object input) {
        this.viewer.setInput(input);
        this.viewer.expandAll();
    }

    public void enableToolBar(Boolean addEnabled, Boolean deleteEnabled, Boolean editedEnabled) {
        this.toolBar.setEnabled(true);
        this.addItem.setEnabled(addEnabled.booleanValue());
        this.deleteItem.setEnabled(deleteEnabled.booleanValue());
        this.editItem.setEnabled(editedEnabled.booleanValue());
    }

    protected void setAddSelectionListener(SelectionListener listener) {
        this.addItem.addSelectionListener(listener);
    }

    protected void setDeleteSelectionListener(SelectionListener listener) {
        this.deleteItem.addSelectionListener(listener);
    }

    protected void setEditeSelectionListener(SelectionListener listener) {
        this.editItem.addSelectionListener(listener);
    }

    public void setProvidedService(Class<?> providedService) {
        this.providedService = providedService;
        this.setTitle("Select " + providedService.getSimpleName() + "...");
    }

    private boolean isInstanceOfProvidedService(Object object) {
        if (this.providedService == null) {
            return true;
        }
        return this.providedService.isAssignableFrom(object.getClass());
    }

    protected abstract void setInputDialogResourceName(Collection<Object> var1);

    protected abstract void addModelToResourceSet(Shell var1, String var2);

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public EObject getResult() {
        return this.selection;
    }

    public EObject getRootOfResult() {
        return this.rootOfSelection;
    }

    protected void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setInitialSelection(Object selection) {
        this.viewer.setSelection((ISelection)new StructuredSelection(selection), true);
    }
}

