/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.tradeoff.ahp;

import Jama.Matrix;
import eu.qimpress.ide.tradeoff.ahp.AHPWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class QualityRatingPage
extends WizardPage {
    private static int numberOfQualities = AHPWizard.QualityNames.length;
    public static final String PAGE_NAME = "Determine relative criteria priority";
    private static double[] translate = new double[]{0.1111111111111111, 0.14285714285714285, 0.2, 0.3333333333333333, 1.0, 3.0, 5.0, 7.0, 9.0};
    private Matrix qualityMatrix;
    private int[] settings;
    private boolean[] QualityInUse;
    private ScrolledComposite sc;
    private Composite globalParent;

    public QualityRatingPage(Matrix m, int[] is, boolean[] qualityInUse) {
        super(PAGE_NAME, PAGE_NAME, null);
        this.setDescription("Please rate pairwise the quality criterias according to their relative level of importance.");
        this.qualityMatrix = m;
        this.settings = is;
        this.QualityInUse = qualityInUse;
    }

    public void createControl(Composite parent) {
        this.globalParent = parent;
        this.drawControl(this.QualityInUse);
    }

    public void drawControl(boolean[] qualityInUse2) {
        Composite parent = this.globalParent;
        this.QualityInUse = qualityInUse2;
        if (this.sc != null) {
            this.sc.dispose();
        }
        this.sc = new ScrolledComposite(parent, 768);
        Composite topLevel = new Composite((Composite)this.sc, 0);
        this.sc.setContent((Control)topLevel);
        topLevel.setLayout((Layout)new GridLayout(3, false));
        GridData radioWidth = new GridData();
        radioWidth.widthHint = 30;
        radioWidth.horizontalAlignment = 2;
        radioWidth.verticalAlignment = 2;
        Label q1 = new Label(topLevel, 16384);
        q1.setText("Quality");
        q1.setLayoutData((Object)new GridData(131072));
        Composite titlesComposite = new Composite(topLevel, 0);
        titlesComposite.setLayout((Layout)new GridLayout(9, false));
        String[] titles = new String[]{"EX", "VS", "ST", "MO", "EQ", "MO", "ST", "VS", "EX"};
        int i = 0;
        while (i < 9) {
            Label l = new Label(titlesComposite, 0x1000000);
            l.setText(titles[i]);
            l.setLayoutData((Object)radioWidth);
            ++i;
        }
        titlesComposite.pack();
        Label q2 = new Label(topLevel, 16384);
        q2.setText("Quality");
        q2.setLayoutData((Object)new GridData(1));
        String[] qualities = AHPWizard.QualityNames;
        int I = 0;
        while (I < numberOfQualities) {
            if (this.QualityInUse[I]) {
                int J = I + 1;
                while (J < numberOfQualities) {
                    if (this.QualityInUse[J]) {
                        Label a = new Label(topLevel, 16384);
                        a.setText(qualities[I]);
                        a.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                        Composite radioGroup = new Composite(topLevel, 0);
                        radioGroup.setLayout((Layout)new GridLayout(9, false));
                        int i2 = 0;
                        while (i2 < 9) {
                            Button b = new Button(radioGroup, 16);
                            b.setLayoutData((Object)radioWidth);
                            b.addSelectionListener((SelectionListener)new RadioListener(this.qualityMatrix, I, J, i2));
                            b.setSelection(i2 == this.settings[I * numberOfQualities + J]);
                            ++i2;
                        }
                        radioGroup.pack();
                        Label b = new Label(topLevel, 16384);
                        b.setText(qualities[J]);
                        b.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                    }
                    ++J;
                }
            }
            ++I;
        }
        Label description = new Label(topLevel, 0);
        description.setText("Legend of quality ratings:\nEX Extreme\nVS Very Strong\nST Strong\nMO Moderate\nEQ Equal");
        GridData descgrid = new GridData();
        descgrid.verticalSpan = 3;
        description.setLayoutData((Object)descgrid);
        description.pack(true);
        topLevel.pack(true);
        parent.layout(true, true);
        parent.redraw();
        this.setControl((Control)this.sc);
        this.setPageComplete(true);
    }

    class RadioListener
    implements SelectionListener {
        private int quality1;
        private int quality2;
        private int value;
        private Matrix qualityMatrix;

        public RadioListener(Matrix m, int quality1, int quality2, int value) {
            this.quality1 = quality1;
            this.quality2 = quality2;
            this.value = value;
            this.qualityMatrix = m;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.qualityMatrix.set(this.quality2, this.quality1, translate[this.value]);
            this.qualityMatrix.set(this.quality1, this.quality2, 1.0 / translate[this.value]);
            ((QualityRatingPage)QualityRatingPage.this).settings[this.quality1 * numberOfQualities + this.quality2] = this.value;
        }
    }
}

