/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.tradeoff.ahp;

import Jama.Matrix;
import eu.qimpress.ide.tradeoff.ahp.AHPWizard;
import java.io.Serializable;

public class AHPDataPoint
implements Serializable {
    private static final long serialVersionUID = -1666101797987380367L;
    private static final int numberOfQualities = AHPWizard.QualityNames.length;
    Matrix[] valueMatrix;
    Matrix qualityMatrix;
    int[] qualitySettings;
    int[][] valueSettings;
    boolean[] QualityInUse = new boolean[numberOfQualities];

    public AHPDataPoint(int numberOfResults) {
        int j;
        int i = 0;
        while (i < numberOfQualities) {
            this.QualityInUse[i] = true;
            ++i;
        }
        this.qualityMatrix = Matrix.identity((int)numberOfQualities, (int)numberOfQualities);
        i = 0;
        while (i < numberOfQualities) {
            j = 0;
            while (j < numberOfQualities) {
                this.qualityMatrix.set(i, j, 1.0);
                ++j;
            }
            ++i;
        }
        this.valueMatrix = new Matrix[numberOfQualities];
        this.valueMatrix[0] = Matrix.identity((int)numberOfResults, (int)numberOfResults);
        i = 0;
        while (i < numberOfResults) {
            j = 0;
            while (j < numberOfResults) {
                this.valueMatrix[0].set(i, j, 1.0);
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i < numberOfQualities) {
            this.valueMatrix[i] = this.valueMatrix[0].copy();
            ++i;
        }
        this.qualitySettings = new int[numberOfQualities * numberOfQualities];
        i = 0;
        while (i < numberOfQualities * numberOfQualities) {
            this.qualitySettings[i] = 4;
            ++i;
        }
        this.valueSettings = new int[numberOfQualities][numberOfResults * numberOfResults];
        i = 0;
        while (i < numberOfResults * numberOfResults) {
            j = 0;
            while (j < numberOfQualities) {
                this.valueSettings[j][i] = 4;
                ++j;
            }
            ++i;
        }
    }

    public Matrix[] getValueMatrix() {
        return this.valueMatrix;
    }

    public void setValueMatrix(Matrix[] valueMatrix) {
        this.valueMatrix = valueMatrix;
    }

    public Matrix getQualityMatrix() {
        return this.qualityMatrix;
    }

    public void setQualityMatrix(Matrix qualityMatrix) {
        this.qualityMatrix = qualityMatrix;
    }

    public void setQualitySettings(int[] qualitySettings) {
        this.qualitySettings = qualitySettings;
    }

    public int[] getQualitySettings() {
        return this.qualitySettings;
    }

    public void setValueSettings(int[][] valueSettings) {
        this.valueSettings = valueSettings;
    }

    public int[][] getValueSettings() {
        return this.valueSettings;
    }

    public boolean[] getQualityInUse() {
        return this.QualityInUse;
    }

    public void setQualityInUse(boolean[] qualityInUse) {
        this.QualityInUse = qualityInUse;
    }
}

