/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.text.formatting;

import eu.qimpress.ide.editors.text.services.EdificeGrammarAccess;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.FormattingConfig;

public class EdificeFormatter
extends AbstractDeclarativeFormatter {
    private static final Logger logger = Logger.getLogger(EdificeFormatter.class);

    protected void configureFormatting(FormattingConfig c) {
        R[] parserRuleElementFinders;
        EdificeGrammarAccess f = (EdificeGrammarAccess)this.getGrammarAccess();
        c.setAutoLinewrap(120);
        List<Method> accessMethods = this.getMethodsByPattern(f, "Access");
        R[] RArray = parserRuleElementFinders = this.getResultsByCallingMethods(f, accessMethods);
        int n = parserRuleElementFinders.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = RArray[n2];
            if (o instanceof IGrammarAccess.IParserRuleAccess) {
                IGrammarAccess.IParserRuleAccess ruleElementFinder = (IGrammarAccess.IParserRuleAccess)o;
                this.addNewlineAfterEachRuleByPattern(c, ruleElementFinder, "SemicolonKeyword");
                this.addNewlineAfterEachRuleByPattern(c, ruleElementFinder, "LeftCurlyBracketKeyword");
                this.addNewlineAfterEachRuleByPattern(c, ruleElementFinder, "RightCurlyBracketKeyword");
                this.addIndentation(c, ruleElementFinder, "LeftCurlyBracketKeyword", "RightCurlyBracketKeyword");
            }
            ++n2;
        }
    }

    protected <T> void addIndentation(FormattingConfig c, T target, String topPattern, String bottomPattern) {
        List<Method> topIndentMethods = this.getMethodsByPattern(target, topPattern);
        List<Method> bottomIndentMethods = this.getMethodsByPattern(target, bottomPattern);
        if (topIndentMethods.size() == bottomIndentMethods.size()) {
            int size = topIndentMethods.size();
            int i = 0;
            while (i < size) {
                try {
                    c.setIndentation((AbstractElement)topIndentMethods.get(i).invoke(target, new Object[0]), (AbstractElement)bottomIndentMethods.get(i).invoke(target, new Object[0]));
                }
                catch (Exception exception) {
                    logger.warn((Object)("Cannot invoke methods on " + target));
                }
                ++i;
            }
        }
    }

    protected <T> void addNewlineAfterEachRuleByPattern(FormattingConfig c, T target, String pattern) {
        List<Method> semicolonMethods = this.getMethodsByPattern(target, pattern);
        for (Method m : semicolonMethods) {
            try {
                c.setLinewrap().after((EObject)m.invoke(target, new Object[0]));
            }
            catch (Exception exception) {
                logger.warn((Object)("Cannot invoke method " + m + " on " + target));
            }
        }
    }

    protected <R, T> R[] getResultsByCallingMethods(T f, List<Method> methods) {
        LinkedList<Object> results = new LinkedList<Object>();
        for (Method m : methods) {
            try {
                Object r = m.invoke(f, new Object[0]);
                results.add(r);
            }
            catch (Exception exception) {
                logger.warn((Object)("Cannot invoke method " + m + " on " + f));
            }
        }
        return results.toArray();
    }

    protected <T> List<Method> getMethodsByPattern(T f, String pattern) {
        Method[] allMethods;
        LinkedList<Method> methods = new LinkedList<Method>();
        Method[] methodArray = allMethods = f.getClass().getMethods();
        int n = allMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().contains(pattern)) {
                methods.add(m);
            }
            ++n2;
        }
        return methods;
    }
}

