/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.seff.part;

import eu.qimpress.ide.editors.gmf.seff.part.SeffDiagramEditorPlugin;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.seffPackage;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class SeffVisualIDRegistry {
    private static final String DEBUG_KEY = "eu.qimpress.ide.editors.gmf.seff/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Seff".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return SeffVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                SeffDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (seffPackage.eINSTANCE.getResourceDemandingSEFF().isSuperTypeOf(domainElement.eClass()) && SeffVisualIDRegistry.isDiagram((ResourceDemandingSEFF)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = SeffVisualIDRegistry.getModelID(containerView);
        if (!"Seff".equals(containerModelID)) {
            return -1;
        }
        if ("Seff".equals(containerModelID)) {
            containerVisualID = SeffVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 3001: {
                if (!seffPackage.eINSTANCE.getResourceDemandingBehaviour().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7001: {
                if (!seffPackage.eINSTANCE.getProbabilisticBranchTransition().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7002: {
                if (seffPackage.eINSTANCE.getStartAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (seffPackage.eINSTANCE.getStopAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (seffPackage.eINSTANCE.getInternalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (seffPackage.eINSTANCE.getExternalCallAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (seffPackage.eINSTANCE.getLoopAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (seffPackage.eINSTANCE.getBranchAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (!seffPackage.eINSTANCE.getForkAction().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7008: {
                if (!seffPackage.eINSTANCE.getResourceDemandingBehaviour().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 7003: {
                if (seffPackage.eINSTANCE.getStartAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (seffPackage.eINSTANCE.getStopAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (seffPackage.eINSTANCE.getInternalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (seffPackage.eINSTANCE.getExternalCallAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (seffPackage.eINSTANCE.getLoopAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (seffPackage.eINSTANCE.getForkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (!seffPackage.eINSTANCE.getBranchAction().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
            case 7004: {
                if (!seffPackage.eINSTANCE.getForkedBehaviour().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 7005: {
                if (seffPackage.eINSTANCE.getStartAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (seffPackage.eINSTANCE.getStopAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (seffPackage.eINSTANCE.getInternalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (seffPackage.eINSTANCE.getExternalCallAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (seffPackage.eINSTANCE.getLoopAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (seffPackage.eINSTANCE.getForkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (!seffPackage.eINSTANCE.getBranchAction().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
            case 7006: {
                if (!seffPackage.eINSTANCE.getProbabilisticBranchTransition().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7009: {
                if (!seffPackage.eINSTANCE.getResourceDemandingBehaviour().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 7007: {
                if (!seffPackage.eINSTANCE.getForkedBehaviour().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 1000: {
                if (seffPackage.eINSTANCE.getStartAction().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (seffPackage.eINSTANCE.getExternalCallAction().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (seffPackage.eINSTANCE.getInternalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (seffPackage.eINSTANCE.getBranchAction().isSuperTypeOf(domainElement.eClass())) {
                    return 2004;
                }
                if (seffPackage.eINSTANCE.getLoopAction().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (seffPackage.eINSTANCE.getForkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (seffPackage.eINSTANCE.getStopAction().isSuperTypeOf(domainElement.eClass())) {
                    return 2007;
                }
                if (seffPackage.eINSTANCE.getAcquireAction().isSuperTypeOf(domainElement.eClass())) {
                    return 2008;
                }
                if (!seffPackage.eINSTANCE.getReleaseAction().isSuperTypeOf(domainElement.eClass())) break;
                return 2009;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = SeffVisualIDRegistry.getModelID(containerView);
        if (!"Seff".equals(containerModelID)) {
            return false;
        }
        if ("Seff".equals(containerModelID)) {
            containerVisualID = SeffVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2002: {
                if (5002 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5003 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7001 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (7009 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (7007 != nodeVisualID) break;
                return true;
            }
            case 2008: {
                if (5013 != nodeVisualID) break;
                return true;
            }
            case 2009: {
                if (5014 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 3005: {
                if (5008 != nodeVisualID) break;
                return true;
            }
            case 3006: {
                if (5009 != nodeVisualID) break;
                return true;
            }
            case 3007: {
                if (5012 == nodeVisualID) {
                    return true;
                }
                if (7008 != nodeVisualID) break;
                return true;
            }
            case 3008: {
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 3009: {
                if (5011 == nodeVisualID) {
                    return true;
                }
                if (7004 != nodeVisualID) break;
                return true;
            }
            case 3010: {
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 3011: {
                if (5010 == nodeVisualID) {
                    return true;
                }
                if (7006 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3010 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3010 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2008 == nodeVisualID) {
                    return true;
                }
                if (2009 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        return -1;
    }

    private static boolean isDiagram(ResourceDemandingSEFF element) {
        return true;
    }
}

