/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.seff.part;

import eu.qimpress.ide.editors.gmf.seff.part.Messages;
import eu.qimpress.ide.editors.gmf.seff.part.SeffDiagramEditorPlugin;
import eu.qimpress.ide.editors.gmf.seff.part.SeffDiagramEditorUtil;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.SeffRepository;
import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class SeffInitDiagramFileForEObjectAction
implements IObjectActionDelegate {
    private ResourceDemandingSEFF seff;
    private IWorkbenchPart targetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        resourceSet.getResource(this.seff.eResource().getURI(), true);
        this.createDiagramFromEObject(this.seff.eResource().getURI(), this.seff, editingDomain);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        this.seff = (ResourceDemandingSEFF)((IStructuredSelection)selection).getFirstElement();
        action.setEnabled(true);
    }

    private Shell getShell() {
        return this.targetPart.getSite().getShell();
    }

    private void createDiagramFromEObject(URI domainModelURI, final ResourceDemandingSEFF diagramRoot, TransactionalEditingDomain editingDomain) {
        String stub_id = "";
        stub_id = diagramRoot.getSeffBehaviourStub() != null ? diagramRoot.getSeffBehaviourStub().getId() : Integer.toString(((SeffRepository)diagramRoot.eContainer()).getResourceDemandingSeff().indexOf((Object)diagramRoot));
        URI diagramModelURI = domainModelURI.trimSegments(1).appendSegment(String.valueOf(domainModelURI.trimFileExtension().lastSegment()) + "_" + "seff" + stub_id + ".samm_seff_diagram");
        ResourceSet resourceSet = editingDomain.getResourceSet();
        final Resource diagramResource = resourceSet.createResource(diagramModelURI);
        LinkedList<IFile> affectedFiles = new LinkedList<IFile>();
        String platformString = diagramModelURI.toPlatformString(true);
        IFile diagramFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
        SeffDiagramEditorUtil.setCharset(diagramFile);
        affectedFiles.add(diagramFile);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, Messages.SeffNewDiagramFileWizard_InitDiagramCommand, affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Diagram diagram = ViewService.createDiagram((EObject)diagramRoot, (String)"Seff", (PreferencesHint)SeffDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                diagramResource.getContents().add((Object)diagram);
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            diagramResource.save(SeffDiagramEditorUtil.getSaveOptions());
            SeffDiagramEditorUtil.openDiagram(diagramResource);
        }
        catch (ExecutionException e) {
            SeffDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        catch (IOException ex) {
            SeffDiagramEditorPlugin.getInstance().logError("Save operation failed for: " + diagramModelURI, ex);
        }
        catch (PartInitException ex) {
            SeffDiagramEditorPlugin.getInstance().logError("Unable to open editor", ex);
        }
    }
}

