/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.seff.part;

import eu.qimpress.ide.editors.gmf.seff.part.BlackboardListener;
import eu.qimpress.ide.editors.gmf.seff.part.ComponentSelectorPage;
import eu.qimpress.ide.editors.gmf.seff.part.Messages;
import eu.qimpress.ide.editors.gmf.seff.part.OperationSelectorPage;
import eu.qimpress.ide.editors.gmf.seff.part.RepositorySelectorPage;
import eu.qimpress.ide.editors.gmf.seff.part.SeffDiagramEditorPlugin;
import eu.qimpress.ide.editors.gmf.seff.part.SeffDiagramEditorUtil;
import eu.qimpress.ide.editors.gmf.seff.part.SeffNewDiagramFileBlackboard;
import eu.qimpress.ide.editors.gmf.seff.part.SeffVisualIDRegistry;
import eu.qimpress.samm.behaviour.BehaviourFactory;
import eu.qimpress.samm.behaviour.OperationBehaviour;
import eu.qimpress.samm.behaviour.SeffBehaviourStub;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.SeffRepository;
import eu.qimpress.seff.impl.SeffRepositoryImpl;
import eu.qimpress.seff.seffFactory;
import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class SeffAddSeffWizard
extends Wizard {
    private WizardNewFileCreationPage myFileCreationPage;
    private RepositorySelectorPage myRepositorySelectorPage;
    private ComponentSelectorPage myComponentSelectorPage;
    private OperationSelectorPage myOperationSelectorPage;
    private SeffNewDiagramFileBlackboard blackboard;
    private TransactionalEditingDomain myEditingDomain;
    private SeffRepository myDiagramRoot = null;
    private URI domainModelURI = null;

    public SeffAddSeffWizard(URI domainModelURI, EObject diagramRoot, TransactionalEditingDomain editingDomain) {
        assert (domainModelURI != null) : "Domain model uri must be specified";
        assert (diagramRoot != null) : "Diagram root element must be specified";
        assert (diagramRoot instanceof SeffRepositoryImpl) : "Root element must be a Seff Repository!";
        assert (editingDomain != null) : "Editing domain must be specified";
        if (diagramRoot instanceof SeffRepositoryImpl) {
            this.myDiagramRoot = (SeffRepository)diagramRoot;
        }
        this.domainModelURI = domainModelURI;
        this.myEditingDomain = editingDomain;
    }

    private void preparePages() {
        Path filePath;
        this.blackboard = new SeffNewDiagramFileBlackboard();
        this.blackboard.addBlackboardListener(new BlackboardListener(){

            @Override
            public void componentChanged() {
            }

            @Override
            public void filenameChanged() {
                SeffAddSeffWizard.this.myFileCreationPage.setFileName(SeffAddSeffWizard.this.blackboard.getFilename());
            }

            @Override
            public void repositoryChanged() {
            }
        });
        this.myRepositorySelectorPage = new RepositorySelectorPage(this.myDiagramRoot, this.blackboard);
        this.myComponentSelectorPage = new ComponentSelectorPage(this.myDiagramRoot, this.blackboard);
        this.myOperationSelectorPage = new OperationSelectorPage(this.myDiagramRoot, "Select operation", this.blackboard);
        this.myFileCreationPage = new WizardNewFileCreationPage(Messages.SeffNewDiagramFileWizard_CreationPageName, (IStructuredSelection)StructuredSelection.EMPTY);
        this.myFileCreationPage.setTitle(Messages.SeffNewDiagramFileWizard_CreationPageTitle);
        this.myFileCreationPage.setDescription(NLS.bind((String)Messages.SeffNewDiagramFileWizard_CreationPageDescription, (Object)"Seff"));
        String fileName = URI.decode((String)this.domainModelURI.trimFileExtension().lastSegment());
        if (this.domainModelURI.isPlatformResource()) {
            filePath = new Path(this.domainModelURI.trimSegments(1).toPlatformString(true));
        } else if (this.domainModelURI.isFile()) {
            filePath = new Path(this.domainModelURI.trimSegments(1).toFileString());
        } else {
            throw new IllegalArgumentException("Unsupported URI: " + this.domainModelURI);
        }
        this.myFileCreationPage.setContainerFullPath((IPath)filePath);
        this.myFileCreationPage.setFileName(SeffDiagramEditorUtil.getUniqueFileName((IPath)filePath, fileName, "samm_seff_diagram"));
    }

    public void addPages() {
        this.preparePages();
        if (this.myRepositorySelectorPage.getSelectedRepository() == null) {
            this.addPage((IWizardPage)this.myRepositorySelectorPage);
        }
        this.addPage((IWizardPage)this.myComponentSelectorPage);
        this.addPage((IWizardPage)this.myOperationSelectorPage);
        this.addPage((IWizardPage)this.myFileCreationPage);
    }

    public boolean performFinish() {
        LinkedList<IFile> affectedFiles = new LinkedList<IFile>();
        IFile diagramFile = this.myFileCreationPage.createNewFile();
        SeffDiagramEditorUtil.setCharset(diagramFile);
        affectedFiles.add(diagramFile);
        URI diagramModelURI = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true);
        ResourceSet resourceSet = this.myEditingDomain.getResourceSet();
        final Resource diagramResource = resourceSet.createResource(diagramModelURI);
        AbstractTransactionalCommand firstCommand = new AbstractTransactionalCommand(this.myEditingDomain, Messages.SeffNewDiagramFileWizard_InitDiagramCommand, affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                SeffAddSeffWizard.this.myEditingDomain.loadResource(SeffAddSeffWizard.this.blackboard.getComponent().eResource().getURI().toString());
                return CommandResult.newOKCommandResult();
            }
        };
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(this.myEditingDomain, Messages.SeffNewDiagramFileWizard_InitDiagramCommand, affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ResourceDemandingSEFF seff = seffFactory.eINSTANCE.createResourceDemandingSEFF();
                SeffBehaviourStub stub = null;
                System.out.println("Is component read only: " + SeffAddSeffWizard.this.myEditingDomain.isReadOnly(SeffAddSeffWizard.this.blackboard.getComponent().eResource()));
                System.out.println("Repo resource set: " + SeffAddSeffWizard.this.blackboard.getComponent().eResource().getURI().toString());
                for (Resource resources : SeffAddSeffWizard.this.myEditingDomain.getResourceSet().getResources()) {
                    System.out.println("Resource URI: " + resources.getURI().toString() + ", " + SeffAddSeffWizard.this.myEditingDomain.isReadOnly(resources));
                }
                if (SeffAddSeffWizard.this.myEditingDomain.isReadOnly(SeffAddSeffWizard.this.myDiagramRoot.eResource())) {
                    System.out.println("Cannot write to SEFF repository!");
                }
                for (OperationBehaviour behaviour : SeffAddSeffWizard.this.blackboard.getComponent().getOperationBehaviour()) {
                    if (!(behaviour instanceof SeffBehaviourStub) || !behaviour.getOperation().equals(SeffAddSeffWizard.this.blackboard.getOperation())) continue;
                    stub = (SeffBehaviourStub)behaviour;
                    break;
                }
                if (stub == null) {
                    stub = BehaviourFactory.eINSTANCE.createSeffBehaviourStub();
                    stub.setOperation(SeffAddSeffWizard.this.blackboard.getOperation());
                    SeffAddSeffWizard.this.blackboard.getComponent().getOperationBehaviour().add((Object)stub);
                }
                seff.setSeffBehaviourStub(stub);
                SeffAddSeffWizard.this.myDiagramRoot.getResourceDemandingSeff().add((Object)seff);
                try {
                    SeffAddSeffWizard.this.myDiagramRoot.eResource().save(null);
                    SeffAddSeffWizard.this.blackboard.getComponent().eResource().save(null);
                }
                catch (IOException iOException) {
                    return CommandResult.newErrorCommandResult((String)Messages.SeffCreationWizardCreationError);
                }
                int diagramVID = SeffVisualIDRegistry.getDiagramVisualID((EObject)seff);
                if (diagramVID != 1000) {
                    return CommandResult.newErrorCommandResult((String)Messages.SeffNewDiagramFileWizard_IncorrectRootError);
                }
                Diagram diagram = ViewService.createDiagram((EObject)seff, (String)"Seff", (PreferencesHint)SeffDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                diagramResource.getContents().add((Object)diagram);
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)firstCommand, (IProgressMonitor)new NullProgressMonitor(), null);
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            diagramResource.save(SeffDiagramEditorUtil.getSaveOptions());
            SeffDiagramEditorUtil.openDiagram(diagramResource);
        }
        catch (ExecutionException e) {
            SeffDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        catch (IOException ex) {
            SeffDiagramEditorPlugin.getInstance().logError("Save operation failed for: " + diagramModelURI, ex);
        }
        catch (PartInitException ex) {
            SeffDiagramEditorPlugin.getInstance().logError("Unable to open editor", ex);
        }
        return true;
    }
}

