/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.seff.part;

import eu.qimpress.ide.editors.gmf.seff.part.BlackboardListener;
import eu.qimpress.ide.editors.gmf.seff.part.SeffNewDiagramFileBlackboard;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.SeffRepository;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class OperationSelectorPage
extends WizardPage {
    private SeffRepository seffRepository;
    private Combo myCombo;
    private List<Operation> myFoundOperations;
    private Operation myOperation;
    private SeffNewDiagramFileBlackboard blackboard;

    protected OperationSelectorPage(SeffRepository seffRepository, String pageName, SeffNewDiagramFileBlackboard blackboard) {
        super(pageName);
        this.seffRepository = seffRepository;
        this.setTitle("Diagram Operation");
        this.setDescription("Select the operation to be used for the diagram.");
        this.blackboard = blackboard;
        this.myCombo = null;
        this.myFoundOperations = new Vector<Operation>();
        this.myOperation = null;
        blackboard.addBlackboardListener(new BlackboardListener(){

            @Override
            public void componentChanged() {
                OperationSelectorPage.this.findOperations();
                OperationSelectorPage.this.populateComboBox();
                OperationSelectorPage.this.myCombo.update();
            }

            @Override
            public void filenameChanged() {
            }

            @Override
            public void repositoryChanged() {
            }
        });
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        this.setControl((Control)topLevel);
        this.createPageContent(topLevel);
    }

    private void createPageContent(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 0);
        label.setText("Select Operation:");
        label.setLayoutData((Object)new GridData(32));
        this.myCombo = new Combo(panel, 12);
        this.findOperations();
        this.populateComboBox();
        this.myCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OperationSelectorPage.this.setPageComplete(OperationSelectorPage.this.validatePage());
            }
        });
    }

    private void populateComboBox() {
        if (this.myCombo == null) {
            return;
        }
        this.myCombo.removeAll();
        for (Operation operation : this.myFoundOperations) {
            this.myCombo.add("Operation " + operation.getName() + " id: " + operation.getId());
        }
        if (this.myCombo.getVisibleItemCount() > 0) {
            this.myCombo.select(0);
        }
    }

    private void findOperations() {
        this.myFoundOperations.clear();
        ComponentType myComponent = this.blackboard.getComponent();
        if (myComponent == null) {
            return;
        }
        for (InterfacePort providedInterface : myComponent.getProvided()) {
            for (Operation operation : providedInterface.getInterfaceType().getSignatures()) {
                this.myFoundOperations.add(operation);
            }
        }
    }

    public Operation getOperation() {
        return this.myOperation;
    }

    protected boolean validatePage() {
        this.myOperation = null;
        if (this.myCombo.getSelectionIndex() == -1) {
            return false;
        }
        try {
            this.myOperation = this.myFoundOperations.get(this.myCombo.getSelectionIndex());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return false;
        }
        for (ResourceDemandingSEFF seff : this.seffRepository.getResourceDemandingSeff()) {
            if (seff.getSeffBehaviourStub() == null) {
                this.setErrorMessage("The repository contains a SEFF with an empty stub. Please fix this first in the seff Model Editor.");
                return false;
            }
            if (!seff.getSeffBehaviourStub().eContainer().equals(this.blackboard.getComponent()) || !seff.getSeffBehaviourStub().getOperation().getId().equals(this.myOperation.getId())) continue;
            this.setErrorMessage("A SEFF is already specified for selected operation!");
            return false;
        }
        this.blackboard.setOperation(this.myOperation);
        String fileName = String.valueOf(this.blackboard.getComponent().getName()) + "." + this.myOperation.getName() + ".samm_seff_diagram";
        this.blackboard.setFilename(fileName);
        this.setErrorMessage(null);
        return true;
    }
}

