/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.seff.navigator;

import eu.qimpress.ide.editors.gmf.seff.navigator.SeffAbstractNavigatorItem;
import eu.qimpress.ide.editors.gmf.seff.navigator.SeffNavigatorGroup;
import eu.qimpress.ide.editors.gmf.seff.navigator.SeffNavigatorItem;
import eu.qimpress.ide.editors.gmf.seff.part.SeffDiagramEditorPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;

public class SeffNavigatorLinkHelper
implements ILinkHelper {
    private static IEditorInput getEditorInput(Diagram diagram) {
        Resource diagramResource = diagram.eResource();
        for (EObject nextEObject : diagramResource.getContents()) {
            if (nextEObject == diagram) {
                return new FileEditorInput(WorkspaceSynchronizer.getFile((Resource)diagramResource));
            }
            if (nextEObject instanceof Diagram) break;
        }
        URI uri = EcoreUtil.getURI((EObject)diagram);
        String editorName = String.valueOf(uri.lastSegment()) + "#" + diagram.eResource().getContents().indexOf((Object)diagram);
        URIEditorInput editorInput = new URIEditorInput(uri, editorName);
        return editorInput;
    }

    public IStructuredSelection findSelection(IEditorInput anInput) {
        IDiagramDocument document = SeffDiagramEditorPlugin.getInstance().getDocumentProvider().getDiagramDocument(anInput);
        if (document == null) {
            return StructuredSelection.EMPTY;
        }
        Diagram diagram = document.getDiagram();
        IFile file = WorkspaceSynchronizer.getFile((Resource)diagram.eResource());
        if (file != null) {
            SeffNavigatorItem item = new SeffNavigatorItem((View)diagram, file, false);
            return new StructuredSelection((Object)item);
        }
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        SeffNavigatorGroup navigatorGroup;
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        if (!(aSelection.getFirstElement() instanceof SeffAbstractNavigatorItem)) {
            return;
        }
        SeffAbstractNavigatorItem abstractNavigatorItem = (SeffAbstractNavigatorItem)((Object)aSelection.getFirstElement());
        View navigatorView = null;
        if (abstractNavigatorItem instanceof SeffNavigatorItem) {
            navigatorView = ((SeffNavigatorItem)abstractNavigatorItem).getView();
        } else if (abstractNavigatorItem instanceof SeffNavigatorGroup && (navigatorGroup = (SeffNavigatorGroup)abstractNavigatorItem).getParent() instanceof SeffNavigatorItem) {
            navigatorView = ((SeffNavigatorItem)((Object)navigatorGroup.getParent())).getView();
        }
        if (navigatorView == null) {
            return;
        }
        IEditorInput editorInput = SeffNavigatorLinkHelper.getEditorInput(navigatorView.getDiagram());
        IEditorPart editor = aPage.findEditor(editorInput);
        if (editor == null) {
            return;
        }
        aPage.bringToTop((IWorkbenchPart)editor);
        if (editor instanceof DiagramEditor) {
            DiagramEditor diagramEditor = (DiagramEditor)editor;
            ResourceSet diagramEditorResourceSet = diagramEditor.getEditingDomain().getResourceSet();
            EObject selectedView = diagramEditorResourceSet.getEObject(EcoreUtil.getURI((EObject)navigatorView), true);
            if (selectedView == null) {
                return;
            }
            GraphicalViewer graphicalViewer = (GraphicalViewer)diagramEditor.getAdapter(GraphicalViewer.class);
            EditPart selectedEditPart = (EditPart)graphicalViewer.getEditPartRegistry().get(selectedView);
            if (selectedEditPart != null) {
                graphicalViewer.select(selectedEditPart);
            }
        }
    }
}

