/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.seff.navigator;

import eu.qimpress.ide.editors.gmf.seff.navigator.SeffAbstractNavigatorItem;
import eu.qimpress.ide.editors.gmf.seff.navigator.SeffNavigatorGroup;
import eu.qimpress.ide.editors.gmf.seff.navigator.SeffNavigatorItem;
import eu.qimpress.ide.editors.gmf.seff.part.Messages;
import eu.qimpress.ide.editors.gmf.seff.part.SeffVisualIDRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class SeffNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public SeffNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (SeffNavigatorContentProvider.this.myViewer != null) {
                    SeffNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : SeffNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (SeffNavigatorContentProvider.this.myViewer != null) {
                    SeffNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(SeffNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : SeffNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (SeffNavigatorContentProvider.this.myViewer != null) {
                    SeffNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(SeffNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : SeffNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (SeffNavigatorContentProvider.this.myViewer != null) {
                    SeffNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(SeffNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            result.addAll(this.createNavigatorItems(this.selectViewsByType((Collection)resource.getContents(), "Seff"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof SeffNavigatorGroup) {
            SeffNavigatorGroup group = (SeffNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof SeffNavigatorItem) {
            SeffNavigatorItem navigatorItem = (SeffNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (SeffVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup links = new SeffNavigatorGroup(Messages.NavigatorGroupName_ResourceDemandingSEFF_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2001));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2002));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2004));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2005));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2006));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2007));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2008));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2009));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                if (!links.isEmpty()) {
                    result.add(links);
                }
                return result.toArray();
            }
            case 2001: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StartAction_2001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StartAction_2001_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2002: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ExternalCallAction_2002_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ExternalCallAction_2002_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2003: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_InternalAction_2003_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_InternalAction_2003_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2004: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_BranchAction_2004_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_BranchAction_2004_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7001));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3001));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2005: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_LoopAction_2005_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_LoopAction_2005_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7009));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3008));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2006: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ForkAction_2006_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ForkAction_2006_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7007));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3010));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2007: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StopAction_2007_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StopAction_2007_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2008: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_AcquireAction_2008_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_AcquireAction_2008_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2009: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ReleaseAction_2009_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ReleaseAction_2009_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3001: {
                ArrayList result = new ArrayList();
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3002));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                return result.toArray();
            }
            case 3002: {
                ArrayList result = new ArrayList();
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3004));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3005));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3006));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3007));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3011));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3009));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                return result.toArray();
            }
            case 3003: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StartAction_3003_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StartAction_3003_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3004: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StopAction_3004_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StopAction_3004_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3005: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_InternalAction_3005_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_InternalAction_3005_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3006: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ExternalCallAction_3006_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ExternalCallAction_3006_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3007: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_LoopAction_3007_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_LoopAction_3007_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7008));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3008));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3008: {
                ArrayList result = new ArrayList();
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3004));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3005));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3006));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3007));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3009));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3011));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                return result.toArray();
            }
            case 3009: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ForkAction_3009_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ForkAction_3009_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7004));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3010));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3010: {
                ArrayList result = new ArrayList();
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7005));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7005));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3004));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7005));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3005));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7005));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3006));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7005));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3007));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7005));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3009));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7005));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3011));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                return result.toArray();
            }
            case 3011: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_BranchAction_3011_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_BranchAction_3011_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(7006));
                connectedViews = this.getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(3001));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 4001: {
                ArrayList<SeffNavigatorGroup> result = new ArrayList<SeffNavigatorGroup>();
                SeffNavigatorGroup target = new SeffNavigatorGroup(Messages.NavigatorGroupName_AbstractActionSuccessor_AbstractAction_4001_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                SeffNavigatorGroup source = new SeffNavigatorGroup(Messages.NavigatorGroupName_AbstractActionSuccessor_AbstractAction_4001_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2001));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2003));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2004));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2005));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2006));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2008));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2009));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3003));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3004));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3005));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3006));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3009));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2001));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2002));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2003));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2004));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2005));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2006));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2008));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(2009));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3003));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3004));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3005));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3006));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3009));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(3011));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection getLinksSourceByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection getLinksTargetByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection getOutgoingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getSourceEdges(), type));
        }
        return result;
    }

    private Collection getIncomingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getTargetEdges(), type));
        }
        return result;
    }

    private Collection getChildrenByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, String type) {
        ArrayList result = new ArrayList();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection selectViewsByType(Collection views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "Seff".equals(SeffVisualIDRegistry.getModelID(view));
    }

    private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
        ArrayList<SeffNavigatorItem> result = new ArrayList<SeffNavigatorItem>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            result.add(new SeffNavigatorItem((View)it.next(), parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof SeffAbstractNavigatorItem) {
            SeffAbstractNavigatorItem abstractNavigatorItem = (SeffAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

