/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.composite.diagram.part;

import eu.qimpress.ide.editors.gmf.composite.diagram.part.Messages;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammCreationWizardPage;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammDiagramEditorPlugin;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammDiagramEditorUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class SammCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected SammCreationWizardPage diagramModelFilePage;
    protected SammCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.SammCreationWizardTitle);
        this.setDefaultPageImageDescriptor(SammDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewStaticstructureWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new SammCreationWizardPage("DiagramModelFile", this.getSelection(), "samm_servicearchitecturemodel_diagram");
        this.diagramModelFilePage.setTitle(Messages.SammCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.SammCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new SammCreationWizardPage("DomainModelFile", this.getSelection(), "samm_servicearchitecturemodel"){

            public void setVisible(boolean visible) {
                if (visible) {
                    String fileName = SammCreationWizard.this.diagramModelFilePage.getFileName();
                    fileName = fileName.substring(0, fileName.length() - ".samm_servicearchitecturemodel_diagram".length());
                    this.setFileName(SammDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), fileName, "samm_servicearchitecturemodel"));
                }
                super.setVisible(visible);
            }
        };
        this.domainModelFilePage.setTitle(Messages.SammCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.SammCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                SammCreationWizard.this.diagram = SammDiagramEditorUtil.createDiagram(SammCreationWizard.this.diagramModelFilePage.getURI(), SammCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (SammCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && SammCreationWizard.this.diagram != null) {
                    try {
                        SammDiagramEditorUtil.openDiagram(SammCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)SammCreationWizard.this.getContainer().getShell(), (String)Messages.SammCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.SammCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                SammDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

