/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies;

import eu.qimpress.ide.editors.gmf.composite.diagram.expressions.SammAbstractExpression;
import eu.qimpress.ide.editors.gmf.composite.diagram.expressions.SammOCLFactory;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammDiagramEditorPlugin;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammVisualIDRegistry;
import eu.qimpress.ide.editors.gmf.composite.diagram.providers.SammElementTypes;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;

public class SammBaseItemSemanticEditPolicy
extends SemanticEditPolicy {
    public static final String VISUAL_ID_KEY = "visual_id";
    private final IElementType myElementType;

    protected SammBaseItemSemanticEditPolicy(IElementType elementType) {
        this.myElementType = elementType;
    }

    public Command getCommand(Request request) {
        Object view;
        if (request instanceof ReconnectRequest && (view = ((ReconnectRequest)request).getConnectionEditPart().getModel()) instanceof View) {
            Integer id = new Integer(SammVisualIDRegistry.getVisualID((View)view));
            request.getExtendedData().put(VISUAL_ID_KEY, id);
        }
        return super.getCommand(request);
    }

    protected int getVisualID(IEditCommandRequest request) {
        Object id = request.getParameter(VISUAL_ID_KEY);
        return id instanceof Integer ? (Integer)id : -1;
    }

    protected Command getSemanticCommand(IEditCommandRequest request) {
        IEditCommandRequest completedRequest = this.completeRequest(request);
        Command semanticCommand = this.getSemanticCommandSwitch(completedRequest);
        semanticCommand = this.getEditHelperCommand(completedRequest, semanticCommand);
        if (completedRequest instanceof DestroyRequest) {
            DestroyRequest destroyRequest = (DestroyRequest)completedRequest;
            return this.shouldProceed(destroyRequest) ? this.addDeleteViewCommand(semanticCommand, destroyRequest) : null;
        }
        return semanticCommand;
    }

    protected Command addDeleteViewCommand(Command mainCommand, DestroyRequest completedRequest) {
        Command deleteViewCommand = this.getGEFWrapper((ICommand)new DeleteCommand(this.getEditingDomain(), (View)this.getHost().getModel()));
        return mainCommand == null ? deleteViewCommand : mainCommand.chain(deleteViewCommand);
    }

    private Command getEditHelperCommand(IEditCommandRequest request, Command editPolicyCommand) {
        if (editPolicyCommand != null) {
            CommandProxy command = editPolicyCommand instanceof ICommandProxy ? ((ICommandProxy)editPolicyCommand).getICommand() : new CommandProxy(editPolicyCommand);
            request.setParameter("edit policy command", (Object)command);
        }
        IElementType requestContextElementType = this.getContextElementType(request);
        request.setParameter("context element type", (Object)requestContextElementType);
        ICommand command = requestContextElementType.getEditCommand(request);
        request.setParameter("edit policy command", null);
        request.setParameter("context element type", null);
        if (command != null) {
            if (!(command instanceof CompositeTransactionalCommand)) {
                command = new CompositeTransactionalCommand(this.getEditingDomain(), command.getLabel()).compose((IUndoableOperation)command);
            }
            return new ICommandProxy(command);
        }
        return editPolicyCommand;
    }

    private IElementType getContextElementType(IEditCommandRequest request) {
        IElementType requestContextElementType = SammElementTypes.getElementType(this.getVisualID(request));
        return requestContextElementType != null ? requestContextElementType : this.myElementType;
    }

    protected Command getSemanticCommandSwitch(IEditCommandRequest req) {
        if (req instanceof CreateRelationshipRequest) {
            return this.getCreateRelationshipCommand((CreateRelationshipRequest)req);
        }
        if (req instanceof CreateElementRequest) {
            return this.getCreateCommand((CreateElementRequest)req);
        }
        if (req instanceof ConfigureRequest) {
            return this.getConfigureCommand((ConfigureRequest)req);
        }
        if (req instanceof DestroyElementRequest) {
            return this.getDestroyElementCommand((DestroyElementRequest)req);
        }
        if (req instanceof DestroyReferenceRequest) {
            return this.getDestroyReferenceCommand((DestroyReferenceRequest)req);
        }
        if (req instanceof DuplicateElementsRequest) {
            return this.getDuplicateCommand((DuplicateElementsRequest)req);
        }
        if (req instanceof GetEditContextRequest) {
            return this.getEditContextCommand((GetEditContextRequest)req);
        }
        if (req instanceof MoveRequest) {
            return this.getMoveCommand((MoveRequest)req);
        }
        if (req instanceof ReorientReferenceRelationshipRequest) {
            return this.getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest)req);
        }
        if (req instanceof ReorientRelationshipRequest) {
            return this.getReorientRelationshipCommand((ReorientRelationshipRequest)req);
        }
        if (req instanceof SetRequest) {
            return this.getSetCommand((SetRequest)req);
        }
        return null;
    }

    protected Command getConfigureCommand(ConfigureRequest req) {
        return null;
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        return null;
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        return null;
    }

    protected Command getSetCommand(SetRequest req) {
        return null;
    }

    protected Command getEditContextCommand(GetEditContextRequest req) {
        return null;
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        return null;
    }

    protected Command getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return null;
    }

    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        return null;
    }

    protected Command getMoveCommand(MoveRequest req) {
        return null;
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected final Command getGEFWrapper(ICommand cmd) {
        return new ICommandProxy(cmd);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected void addDestroyShortcutsCommand(ICompositeCommand cmd, View view) {
        assert (view.getEAnnotation("Shortcut") == null);
        for (View nextView : view.getDiagram().getChildren()) {
            if (nextView.getEAnnotation("Shortcut") == null || !nextView.isSetElement() || nextView.getElement() != view.getElement()) continue;
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), nextView));
        }
    }

    public static class LinkConstraints {
        private static final String OPPOSITE_END_VAR = "oppositeEnd";
        private static SammAbstractExpression SubcomponentEndpoint_4001_SourceExpression;
        private static SammAbstractExpression ComponentEndpoint_4002_SourceExpression;
        private static SammAbstractExpression ComponentEndpoint_4002_TargetExpression;

        public static boolean canCreateSubcomponentEndpoint_4001(Connector source, Port target) {
            return LinkConstraints.canExistSubcomponentEndpoint_4001(source, target);
        }

        public static boolean canCreateComponentEndpoint_4002(Connector source, Port target) {
            return LinkConstraints.canExistComponentEndpoint_4002(source, target);
        }

        public static boolean canExistSubcomponentEndpoint_4001(Connector source, Port target) {
            try {
                if (source != null) {
                    Object sourceVal;
                    if (SubcomponentEndpoint_4001_SourceExpression == null) {
                        Map<String, EClass> env = Collections.singletonMap(OPPOSITE_END_VAR, StaticstructurePackage.eINSTANCE.getPort());
                        SubcomponentEndpoint_4001_SourceExpression = SammOCLFactory.getExpression("-- if target port has been already selected\r\noppositeEnd <> null implies \r\n-- then its enclosing ComponentType should not be the same as the connector's parent (port of a SubcomponentInstance)\r\n(oppositeEnd.oclAsType(ecore::EObject).eContainer() <> self.oclAsType(ecore::EObject).eContainer() and \r\n-- and no other endpoint should point to this port (port is not bound yet)\r\n\n(not self.oclAsType(ecore::EObject).eContainer().oclAsType(CompositeStructure).connector->exists(endpoints->exists(port = oppositeEnd))) \r\n-- except the target port is a provided port (which can be connected to multiple requiring ports) \r\nor (oppositeEnd.oclIsKindOf(InterfacePort) implies not oppositeEnd.oclAsType(InterfacePort).isRequired)\r\n-- except the target port is an event port\r\n-- TODO: clarify event connector semantics\r\nor oppositeEnd.oclIsKindOf(EventPort))", (EClassifier)StaticstructurePackage.eINSTANCE.getConnector(), env);
                    }
                    if (!((sourceVal = SubcomponentEndpoint_4001_SourceExpression.evaluate(source, Collections.singletonMap(OPPOSITE_END_VAR, target))) instanceof Boolean) || !((Boolean)sourceVal).booleanValue()) {
                        return false;
                    }
                }
                return true;
            }
            catch (Exception e) {
                SammDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                return false;
            }
        }

        public static boolean canExistComponentEndpoint_4002(Connector source, Port target) {
            Map<String, EClass> env;
            block7: {
                try {
                    Object sourceVal;
                    if (source == null) break block7;
                    if (ComponentEndpoint_4002_SourceExpression == null) {
                        env = Collections.singletonMap(OPPOSITE_END_VAR, StaticstructurePackage.eINSTANCE.getPort());
                        ComponentEndpoint_4002_SourceExpression = SammOCLFactory.getExpression("-- source connector should not have any other ComponentEndpoints\r\nnot self.endpoints->exists(oclIsKindOf(ComponentEndpoint))\r and\r\n-- and the target port's enclosing ComponetType should be the same as the connector's parent (external Port)\r\n(oppositeEnd <> null implies (oppositeEnd.oclAsType(ecore::EObject).eContainer() = self.oclAsType(ecore::EObject).eContainer()))", (EClassifier)StaticstructurePackage.eINSTANCE.getConnector(), env);
                    }
                    if ((sourceVal = ComponentEndpoint_4002_SourceExpression.evaluate(source, Collections.singletonMap(OPPOSITE_END_VAR, target))) instanceof Boolean && ((Boolean)sourceVal).booleanValue()) break block7;
                    return false;
                }
                catch (Exception e) {
                    SammDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                    return false;
                }
            }
            if (target != null) {
                Object targetVal;
                if (ComponentEndpoint_4002_TargetExpression == null) {
                    env = Collections.singletonMap(OPPOSITE_END_VAR, StaticstructurePackage.eINSTANCE.getConnector());
                    ComponentEndpoint_4002_TargetExpression = SammOCLFactory.getExpression("-- for the target port there is no existing endpoint referencing it (port is not bound yet)\r\nnot self.oclAsType(ecore::EObject).eContainer().oclAsType(CompositeStructure).connector->exists(endpoints->exists(port = self)) \r\n-- except it is required interface port (which can be connected to multiple inner components)\r\nor (self.oclIsKindOf(InterfacePort) implies self.oclAsType(InterfacePort).isRequired)\r\r\n\r-- TODO: clarify event connector semantics \r\n-- or it is an EventPort\r\n \n\nor self.oclIsKindOf(EventPort)", (EClassifier)StaticstructurePackage.eINSTANCE.getPort(), env);
                }
                if (!((targetVal = ComponentEndpoint_4002_TargetExpression.evaluate(target, Collections.singletonMap(OPPOSITE_END_VAR, source))) instanceof Boolean) || !((Boolean)targetVal).booleanValue()) {
                    return false;
                }
            }
            return true;
        }
    }
}

