/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.composite.diagram.edit.commands;

import eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies.SammBaseItemSemanticEditPolicy;
import eu.qimpress.samm.staticstructure.ComponentEndpoint;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.Port;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class ComponentEndpointReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ComponentEndpointReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof ComponentEndpoint)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Connector) || !(this.newEnd instanceof Connector)) {
            return false;
        }
        Port target = this.getLink().getPort();
        return SammBaseItemSemanticEditPolicy.LinkConstraints.canExistComponentEndpoint_4002(this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Port) || !(this.newEnd instanceof Port)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof Connector)) {
            return false;
        }
        Connector source = (Connector)this.getLink().eContainer();
        return SammBaseItemSemanticEditPolicy.LinkConstraints.canExistComponentEndpoint_4002(source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getEndpoints().remove((Object)this.getLink());
        this.getNewSource().getEndpoints().add((Object)this.getLink());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setPort(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected ComponentEndpoint getLink() {
        return (ComponentEndpoint)this.getElementToEdit();
    }

    protected Connector getOldSource() {
        return (Connector)this.oldEnd;
    }

    protected Connector getNewSource() {
        return (Connector)this.newEnd;
    }

    protected Port getOldTarget() {
        return (Port)this.oldEnd;
    }

    protected Port getNewTarget() {
        return (Port)this.newEnd;
    }
}

