/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.common.diagram.custom.util;

import eu.qimpress.ide.editors.gmf.common.diagram.custom.util.LogFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class FileUtil {
    private static Logger log = LogFactory.getLog(FileUtil.class);

    public static URI getURI(IFile file) {
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }

    public static IFile getIFile(URI uri) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
    }

    public static List<IFile> getFile(IContainer folder, String extension) {
        try {
            ArrayList<IFile> files = new ArrayList<IFile>();
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                IResource res = iResourceArray[n2];
                if (res instanceof IFile && extension.equals((file = (IFile)res).getFileExtension())) {
                    files.add(file);
                }
                ++n2;
            }
            return files;
        }
        catch (Throwable e) {
            log.error((Object)("error while accessing members of '" + folder.getLocation().toString() + "'"), e);
            return null;
        }
    }

    public static final List<EObject> getContents(String resourceURI, EObject context) {
        ResourceSet resourceSet;
        try {
            resourceSet = context.eResource().getResourceSet();
        }
        catch (Exception exception) {
            resourceSet = new ResourceSetImpl();
        }
        Resource resource = resourceSet.getResource(URI.createURI((String)resourceURI), true);
        return resource.getContents();
    }
}

