/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.form.qoseditor.wizards.pages;

import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.ui.models.ShadowModelEditorUtils;
import eu.qimpress.ide.editors.form.qoseditor.QoSEditorUtils;
import eu.qimpress.ide.editors.form.qoseditor.properties.AssociatedQoSAnnotationSection;
import eu.qimpress.ide.editors.form.qoseditor.properties.EMFExtendedPropertySheetPage;
import eu.qimpress.ide.editors.form.qoseditor.wizards.QoSAnnotationWizard;
import eu.qimpress.ide.editors.form.qoseditor.wizards.pages.SelectProjectPage;
import eu.qimpress.ide.editors.form.qoseditor.wizards.widgets.AnnotableEntitiesViewer;
import eu.qimpress.samm.qosannotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class SelectAnnotationAndEntitiesPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(AssociatedQoSAnnotationSection.class);
    Button showAllEntities;
    List annotationSelector;
    AnnotableEntitiesViewer entityViewer;
    private EMFExtendedPropertySheetPage annotationEntityPrototypeEditor = null;
    private EMFExtendedPropertySheetPage annotatedObjectPropertyDisplayer = null;
    private EClass[] annotationTypes;
    private Map<EClass, Annotation> annotationPrototypes;

    public SelectAnnotationAndEntitiesPage(IQProject selectedProject) {
        super("Annotation Wizard - select annotation and entity page");
        this.setTitle("Annotation Wizard");
        this.setDescription("Select project, where annotatios should be changed");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout(2, true));
        this.setControl((Control)composite);
        Label annotationSelectorLabel = new Label(composite, 0);
        annotationSelectorLabel.setText("Select Annotation Type");
        GridDataFactory.generate((Control)annotationSelectorLabel, (int)1, (int)1);
        Label entityList = new Label(composite, 0);
        entityList.setText("Select Entities");
        GridDataFactory.generate((Control)entityList, (int)1, (int)1);
        this.annotationSelector = this.createAnnotationTypeList(composite);
        this.annotationTypes = ((QoSAnnotationWizard)this.getWizard()).annotationTypes;
        this.annotationPrototypes = QoSEditorUtils.createPrototypeInstances(this.annotationTypes);
        this.annotationSelector.removeAll();
        EClass[] eClassArray = this.annotationTypes;
        int n = this.annotationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EClass annotation = eClassArray[n2];
            String key = annotation.getName();
            this.annotationSelector.add(key);
            ++n2;
        }
        this.entityViewer = new AnnotableEntitiesViewer(composite, 268438276, this.annotationTypes.length);
        GridDataFactory.generate((Control)this.annotationSelector, (int)1, (int)1);
        GridDataFactory.generate((Control)this.entityViewer.getControl(), (int)1, (int)1);
        this.showAllEntities = new Button(composite, 32);
        this.showAllEntities.setText("Show all");
        this.showAllEntities.setSelection(true);
        GridDataFactory.defaultsFor((Control)this.showAllEntities).span(2, 1).align(0x1000008, 0x1000000).applyTo((Control)this.showAllEntities);
        Label annotationEntityPrototypeLabel = new Label(composite, 0);
        annotationEntityPrototypeLabel.setText("Annotation prototype");
        GridDataFactory.generate((Control)annotationEntityPrototypeLabel, (int)1, (int)1);
        Label entityDisplayerLabel = new Label(composite, 0);
        entityDisplayerLabel.setText("Selected entity");
        GridDataFactory.generate((Control)entityDisplayerLabel, (int)1, (int)1);
        this.annotationEntityPrototypeEditor = new EMFExtendedPropertySheetPage();
        this.annotationEntityPrototypeEditor.createControl(composite);
        GridDataFactory.generate((Control)this.annotationEntityPrototypeEditor.getControl(), (int)1, (int)1);
        this.annotatedObjectPropertyDisplayer = new EMFExtendedPropertySheetPage();
        this.annotatedObjectPropertyDisplayer.createControl(composite);
        GridDataFactory.generate((Control)this.annotatedObjectPropertyDisplayer.getControl(), (int)1, (int)1);
        this.annotationSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = 0;
                index = SelectAnnotationAndEntitiesPage.this.annotationSelector.getSelectionIndex();
                if (index != -1) {
                    EClass eClass = SelectAnnotationAndEntitiesPage.this.annotationTypes[index];
                    Annotation annotation = (Annotation)SelectAnnotationAndEntitiesPage.this.annotationPrototypes.get(eClass);
                    SelectAnnotationAndEntitiesPage.this.annotationEntityPrototypeEditor.selectionChanged(null, (ISelection)new StructuredSelection((Object)annotation));
                    try {
                        SelectAnnotationAndEntitiesPage.this.annotationEntityPrototypeEditor.setEditingDomain((AdapterFactoryEditingDomain)ShadowModelEditorUtils.getDefaultEditingDomain((IProject)((SelectProjectPage)SelectAnnotationAndEntitiesPage.this.getPreviousPage()).getSelectedProject().getProject()));
                    }
                    catch (RepositoryException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.entityViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectAnnotationAndEntitiesPage.this.annotatedObjectPropertyDisplayer.selectionChanged(null, event.getSelection());
                SelectAnnotationAndEntitiesPage.this.validatePage();
            }
        });
    }

    public EObject[] getSelectedEntitiesForAnnoataionType(EClass annType) {
        int index = -1;
        int i = 0;
        while (i < this.annotationTypes.length) {
            if (annType == this.annotationTypes[i]) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            logger.error((Object)"Trying to get selected objectts for non existing annnotation Type");
            return new EObject[0];
        }
        return ((ArrayList)this.entityViewer.selectedEntities[index]).toArray(new EObject[((ArrayList)this.entityViewer.selectedEntities[index]).size()]);
    }

    public void handleAnnotationSelection(int index) {
        this.entityViewer.selectedAnotationChanged(this.annotationTypes[index], ((SelectProjectPage)this.getPreviousPage()).getSelectedProject(), index);
    }

    private List createAnnotationTypeList(Composite parent) {
        final List annotationTypeList = new List(parent, 2052);
        GridDataFactory.fillDefaults().span(1, 2).grab(true, true).applyTo((Control)annotationTypeList);
        annotationTypeList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = 0;
                index = annotationTypeList.getSelectionIndex();
                if (index != -1) {
                    SelectAnnotationAndEntitiesPage.this.handleAnnotationSelection(index);
                }
            }
        });
        return annotationTypeList;
    }

    public boolean validatePage() {
        boolean valid = false;
        this.entityViewer.saveCurrentSelection();
        int i = 0;
        while (i < this.annotationTypes.length) {
            if (((ArrayList)this.entityViewer.selectedEntities[i]).size() > 0) {
                valid = true;
                break;
            }
            ++i;
        }
        this.setPageComplete(valid);
        return valid;
    }
}

