/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.checkers.jpfcheck.workflow;

import de.fzi.gast.types.GASTClass;
import de.fzi.gast.variables.Field;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.checkers.jpfcheck.JPFCheckPlugin;
import eu.qimpress.ide.checkers.jpfcheck.log.Log4jOutputStream;
import eu.qimpress.ide.checkers.jpfcheck.ui.JPFCheckConfiguration;
import eu.qimpress.ide.checkers.jpfcheck.workflow.JPFCheckCIStatus;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.InterfaceSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;
import org.ow2.dsrg.fm.tbpjava.Checker;

public class JPFCheckJob
implements IJob {
    private Logger logger = Logger.getLogger(JPFCheckJob.class);
    protected static final String SRC_GEN_DIRECTORY = "src-gen";
    protected static final String LIB_DIRECTORY = "lib/jpfcheck-bp";
    protected static final String[] INTERNAL_JARS = new String[]{"jpfchecker-tool.jar"};
    private SourceCodeDecoratorRepository scdrep;
    protected static final String[] LIBRARIES_JARS = new String[]{"jpf.jar", "jpf-classes.jar", "jpfchecker-tool.jar"};
    private JPFCheckConfiguration config;

    public JPFCheckJob(JPFCheckConfiguration config) {
        this.config = config;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        this.logger.info((Object)"Preparing environment for JPFCheck");
        File tempDir = this.getTemporaryDir(this.config.getProject());
        Collection<File> internalJarFiles = this.getInternalJarFiles(INTERNAL_JARS);
        internalJarFiles.add(tempDir);
        List<File> appBinaries = this.getAppBinaries(this.config.getAlternative().getRepository().getQProject().getProject());
        appBinaries.add(tempDir);
        this.logger.debug((Object)" - modifying context classloader for current thread");
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassloader = currentThread.getContextClassLoader();
        try {
            LinkedList<URL> urls = new LinkedList<URL>();
            for (File f : internalJarFiles) {
                urls.add(f.toURI().toURL());
            }
            for (File f : appBinaries) {
                urls.add(f.toURI().toURL());
            }
            urls.add(tempDir.toURI().toURL());
            URLClassLoader newClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), oldClassloader);
            currentThread.setContextClassLoader(newClassLoader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.debug((Object)" - modifying env. var. java.class.path for JPF");
        StringBuffer sb = new StringBuffer(System.getProperty("java.class.path"));
        for (File f : this.getInternalJarFiles(LIBRARIES_JARS)) {
            sb.append(File.pathSeparatorChar);
            sb.append(f.getAbsolutePath());
        }
        for (File f : appBinaries) {
            sb.append(File.pathSeparatorChar);
            sb.append(f.getAbsolutePath());
        }
        System.setProperty("java.class.path", sb.toString());
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        PrintStream osInfo = null;
        PrintStream osDebug = null;
        try {
            try {
                IQModel sourceCodeDecoratorInstance = this.config.getAlternative().getModel("sourcecodedecorator");
                this.scdrep = (SourceCodeDecoratorRepository)sourceCodeDecoratorInstance.getTopLevelEObject(SourceCodeDecoratorRepository.class);
                EList codeLinks = this.scdrep.getInterfaceSourceCodeLink();
                Map<String, String> provIfaces = this.getIfacesMap((EList<InterfacePort>)this.config.getComponentType().getProvided(), (EList<InterfaceSourceCodeLink>)codeLinks);
                Map<String, String> reqIfaces = this.getRequiredIfacesMap(this.config.getComponentType(), (EList<InterfaceSourceCodeLink>)codeLinks);
                osInfo = new PrintStream(new Log4jOutputStream(this.logger, Level.INFO, oldClassloader));
                osDebug = new PrintStream(new Log4jOutputStream(this.logger, Level.DEBUG, oldClassloader));
                System.setOut(osInfo);
                System.setErr(osDebug);
                this.printAnalysisParameters(this.config.getComponentType().getName(), this.config.getComponentImpl(), provIfaces, reqIfaces, this.config.getProtocolFile(), this.config.getAdditionalParameters().get("env.valuesets"), tempDir, internalJarFiles, osDebug);
                this.logger.info((Object)"Launching JPFCheck tool");
                StackTraceElement[] counterExampleTrace = Checker.runFromEclipse((String)this.config.getComponentType().getName(), (String)this.config.getComponentImpl(), provIfaces, reqIfaces, (File)this.config.getProtocolFile(), (String)this.config.getAdditionalParameters().get("env.valuesets"), (File)tempDir, internalJarFiles, (OutputStream)osInfo);
                try {
                    this.refreshTempFolder();
                }
                catch (CoreException coreException) {
                    this.logger.warn((Object)"Cannot refresh generated folder src-gen");
                }
                this.processResults(counterExampleTrace);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.logger.error((Object)"Exception occured during launching JPFChecker", e);
                final Throwable e2 = e;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"JPFCheck error", (String)"Error occured during calling JPFCheck tool!", (IStatus)new Status(4, "eu.qimpress.analysis.jpfcheck", "JPFCheck exception", e2));
                    }
                });
                System.setOut(oldOut);
                System.setErr(oldErr);
                osDebug.close();
                osInfo.close();
                currentThread.setContextClassLoader(oldClassloader);
            }
        }
        finally {
            System.setOut(oldOut);
            System.setErr(oldErr);
            osDebug.close();
            osInfo.close();
            currentThread.setContextClassLoader(oldClassloader);
        }
    }

    public String getName() {
        return "JPFCheck job";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    protected File getTemporaryDir(IProject project) throws JobFailedException {
        File tempDir = null;
        try {
            IFolder srcGenFolder = project.getFolder(SRC_GEN_DIRECTORY);
            if (!srcGenFolder.exists()) {
                srcGenFolder.create(true, true, null);
                project.refreshLocal(0, null);
            }
            tempDir = Platform.getLocation().append(srcGenFolder.getFullPath()).toFile();
        }
        catch (CoreException e) {
            throw new JobFailedException(e);
        }
        return tempDir;
    }

    protected Collection<File> getInternalJarFiles(String[] jarNames) {
        Bundle thisBundle = JPFCheckPlugin.getDefault().getBundle();
        LinkedList<File> result = new LinkedList<File>();
        String[] stringArray = jarNames;
        int n = jarNames.length;
        int n2 = 0;
        while (n2 < n) {
            String jarName = stringArray[n2];
            try {
                URL url = thisBundle.getEntry("/lib/jpfcheck-bp/" + jarName);
                if (url != null) {
                    result.add(new File(FileLocator.toFileURL((URL)url).getPath()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return result;
    }

    public void setConfig(JPFCheckConfiguration config) {
        this.config = config;
    }

    public JPFCheckConfiguration getConfig() {
        return this.config;
    }

    private Map<String, String> getIfacesMap(EList<InterfacePort> ifacePorts, EList<InterfaceSourceCodeLink> codelinks) {
        HashMap<String, String> result = new HashMap<String, String>();
        block0: for (InterfacePort ifacePort : ifacePorts) {
            for (InterfaceSourceCodeLink link : codelinks) {
                if (!link.getInterface().getName().equals(ifacePort.getInterfaceType().getName())) continue;
                result.put(link.getGastClass().getQualifiedName(), link.getGastClass().getQualifiedName());
                continue block0;
            }
        }
        return result;
    }

    private Map<String, String> getRequiredIfacesMap(ComponentType ctype, EList<InterfaceSourceCodeLink> codelinks) {
        EList ports = ctype.getRequired();
        HashMap<String, String> result = new HashMap<String, String>();
        for (InterfacePort port : ports) {
            Interface i = port.getInterfaceType();
            String iname = i.getName();
            GASTClass implIface = null;
            for (InterfaceSourceCodeLink link : this.scdrep.getInterfaceSourceCodeLink()) {
                if (!link.getInterface().getName().equals(iname)) continue;
                implIface = link.getGastClass();
                break;
            }
            EList classes = this.scdrep.getComponentImplementingClassesLink();
            for (ComponentImplementingClassesLink links : classes) {
                if (!links.getComponent().getName().equals(ctype.getName())) continue;
                for (GASTClass c : links.getImplementingClasses()) {
                    for (Field f : c.getFields()) {
                        if (!f.getType().getQualifiedName().equals(implIface.getQualifiedName())) continue;
                        iname = f.getSimpleName();
                        result.put(iname, implIface.getQualifiedName());
                    }
                }
            }
        }
        return result;
    }

    private List<File> getAppBinaries(IProject project) {
        LinkedList<File> result = new LinkedList<File>();
        IWorkspaceRoot wRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IClasspathEntry[] cpEntries;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPath entryPath = null;
            entryPath = javaProject.getOutputLocation();
            result.add(new File(wRoot.getFile(entryPath).getLocationURI()));
            IClasspathEntry[] iClasspathEntryArray = cpEntries = javaProject.getResolvedClasspath(true);
            int n = cpEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpEntry = iClasspathEntryArray[n2];
                File file = null;
                entryPath = cpEntry.getPath();
                switch (cpEntry.getEntryKind()) {
                    case 1: 
                    case 3: {
                        if (entryPath.toFile().exists()) {
                            file = entryPath.toFile();
                            break;
                        }
                        IFile ifile = wRoot.getFile(entryPath);
                        if (ifile == null) break;
                        file = new File(wRoot.getFile(entryPath).getLocationURI());
                        break;
                    }
                }
                if (file != null) {
                    result.add(file);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void printAnalysisParameters(String componentName, String componentImpl, Map<String, String> provIfaces, Map<String, String> reqIfaces, File protocolFile, String valueSetsClassName, File tempDir, Collection<File> internalJarFiles, PrintStream msgStream) {
        msgStream.println("JPFCheck tool");
        msgStream.println("------------------");
        msgStream.println("Input parameters:");
        msgStream.println("  componentName: " + componentName);
        msgStream.println("  componentImpl: " + componentImpl);
        msgStream.println("  provided ifaces:");
        for (Map.Entry<String, String> e : provIfaces.entrySet()) {
            msgStream.println("    " + e.getKey() + " : " + e.getValue());
        }
        msgStream.println("  required ifaces:");
        for (Map.Entry<String, String> e : reqIfaces.entrySet()) {
            msgStream.println("    " + e.getKey() + " : " + e.getValue());
        }
        msgStream.println("  protocolFile: " + protocolFile);
        msgStream.println("  valueSetsClassName: " + valueSetsClassName);
        msgStream.println("  tempDir: " + tempDir);
        msgStream.println("  internal JARS:");
        for (File f : internalJarFiles) {
            msgStream.println("    " + f);
        }
        msgStream.println("------------------");
    }

    protected void processResults(final StackTraceElement[] counterExampleTrace) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (counterExampleTrace != null && counterExampleTrace.length > 0) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        List markers = JPFCheckJob.this.createMarkers(counterExampleTrace);
                        if (markers.size() > 0) {
                            System.err.println("opening console");
                            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IMarker)((IMarker)markers.get(0)));
                        }
                    }
                    catch (CoreException e1) {
                        e1.printStackTrace();
                        System.err.println(e1.getMessage());
                    }
                    ErrorDialog.openError((Shell)display.getActiveShell(), (String)"JPFChecker result", (String)"JPFChecker found counter example", (IStatus)new JPFCheckCIStatus("JPFCheck found counter example!", counterExampleTrace));
                }
            });
        } else {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"JPFChecker result", (String)"No error was found");
                }
            });
        }
    }

    private List<IMarker> createMarkers(StackTraceElement[] elements) throws CoreException {
        IProject project = this.config.getProject();
        LinkedList<IFolder> folders = new LinkedList<IFolder>();
        LinkedList<IMarker> resultingMarkers = new LinkedList<IMarker>();
        Object[] objectArray = project.members();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = objectArray[n2];
            if (r.getType() == 2) {
                folders.add((IFolder)r);
            }
            ++n2;
        }
        objectArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            IResource element = objectArray[n2];
            for (IFolder folder : folders) {
                Path stPath;
                IResource res = folder.findMember((stPath = new Path(element.getFileName())).segment(stPath.segmentCount() - 1));
                if (res == null || res.getType() != 1 || !res.exists()) continue;
                res.refreshLocal(0, null);
                IMarker marker = res.createMarker("org.eclipse.core.resources.textmarker");
                marker.setAttribute("lineNumber", element.getLineNumber());
                marker.setAttribute("org.eclipse.ui.editorID", (Object)"org.eclipse.ui.JavaEditor");
                resultingMarkers.add(marker);
                break;
            }
            ++n2;
        }
        return resultingMarkers;
    }

    protected void refreshTempFolder() throws CoreException {
        IProject project = this.config.getProject();
        IFolder folder = project.getFolder(SRC_GEN_DIRECTORY);
        if (folder != null && folder.exists()) {
            folder.refreshLocal(2, null);
        }
    }
}

