/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.checkers.jpfcheck.ui.tabs;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewer;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory;
import eu.qimpress.ide.checkers.jpfcheck.ui.tabs.JPFCheckConfigTab;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.provider.StaticstructureItemProviderAdapterFactory;
import eu.qimpress.sourcecodedecorator.FileLevelSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectAlternativeTab
extends AbstractLaunchConfigurationTab {
    private QAlternativesTreeViewer alternativeViewer;
    private CheckboxTableViewer componentList;
    protected Text compImplText;
    private Boolean isImplSelected = false;
    private ILaunchConfigurationTab jpfConfigTabReference;
    private IQAlternative selectedAlternative;
    private IQModel selectedModel;
    private ComponentType selectedComponent = null;

    private static String createTBPFilename(IQAlternative alternative, String src) {
        src = src.replaceAll("<", "_");
        src = src.replaceAll(">", "_");
        src = src.replaceAll(" ", "_");
        src = src.replaceAll("\\.", "_");
        return alternative.getAlternativeFolder().getFile(String.valueOf(src) + ".tbp").getProjectRelativePath().toOSString();
    }

    public void setJPFCheckerConfigTabReference(ILaunchConfigurationTab jpfConfigTabRef) {
        this.jpfConfigTabReference = jpfConfigTabRef;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.setControl((Control)composite);
        Label alternativeLabel = new Label(composite, 0);
        alternativeLabel.setText("Alternative");
        GridDataFactory.generate((Control)alternativeLabel, (int)1, (int)1);
        this.alternativeViewer = (QAlternativesTreeViewer)QAlternativesTreeViewerFactory.createTreeViewer((Composite)composite, (QAlternativesTreeViewerFactory.SelectAlternativesEnum)QAlternativesTreeViewerFactory.SelectAlternativesEnum.NONE).getTreeViewer();
        this.alternativeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectAlternativeTab.this.componentList.setItemCount(0);
                IQAlternative alternative = SelectAlternativeTab.this.alternativeViewer.getFirstSelectedAlternative();
                if (alternative != null) {
                    IQModel staticStructureModel = null;
                    try {
                        staticStructureModel = alternative.getModel("samm_repository");
                        if (staticStructureModel != null) {
                            SelectAlternativeTab.this.selectedModel = staticStructureModel;
                            SelectAlternativeTab.this.updateComponentList(staticStructureModel);
                        }
                    }
                    catch (RepositoryException e) {
                        e.printStackTrace();
                    }
                }
                SelectAlternativeTab.this.setDirty(true);
                SelectAlternativeTab.this.updateLaunchConfigurationDialog();
            }
        });
        GridDataFactory.generate((Control)this.alternativeViewer.getControl(), (int)3, (int)1);
        Label componentLabel = new Label(composite, 0);
        componentLabel.setText("Component");
        GridDataFactory.generate((Control)componentLabel, (int)1, (int)20);
        this.componentList = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.componentList.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new StaticstructureItemProviderAdapterFactory()));
        this.componentList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Boolean isTBPSelected = false;
                if (!event.getChecked()) {
                    SelectAlternativeTab.this.selectedComponent = null;
                    SelectAlternativeTab.this.isImplSelected = false;
                    isTBPSelected = false;
                } else {
                    SelectAlternativeTab.this.componentList.setCheckedElements(new Object[]{event.getElement()});
                    SelectAlternativeTab.this.selectedComponent = (ComponentType)event.getElement();
                    try {
                        IQAlternative alternative = SelectAlternativeTab.this.alternativeViewer.getFirstSelectedAlternative();
                        alternative.getModel("samm_repository");
                        alternative.getModel("sourcecodedecorator");
                        alternative.getModel("gast");
                        IQModel sourceCodeDecoratorInstance = alternative.getModel("sourcecodedecorator");
                        SourceCodeDecoratorRepository sourceCodeRepo = (SourceCodeDecoratorRepository)sourceCodeDecoratorInstance.getTopLevelEObject(SourceCodeDecoratorRepository.class);
                        EList codeLinks = sourceCodeRepo.getFileLevelSourceCodeLink();
                        System.out.println();
                        SelectAlternativeTab.this.isImplSelected = false;
                        for (FileLevelSourceCodeLink codeLink : codeLinks) {
                            block12: {
                                if (codeLink.getFile() == null) {
                                    if (SelectAlternativeTab.this.isImplSelected.booleanValue()) continue;
                                    SelectAlternativeTab.this.compImplText.setText("Selected Component does not have associated a file");
                                    continue;
                                }
                                ComponentType ctype = codeLink.getComponentType();
                                if (!ctype.getId().equals(SelectAlternativeTab.this.selectedComponent.getId())) continue;
                                try {
                                    IJavaProject jp;
                                    IProject project = alternative.getRepository().getQProject().getProject();
                                    if (!project.hasNature("org.eclipse.jdt.core.javanature") || (jp = JavaCore.create((IProject)project)) == null) break block12;
                                    IPackageFragmentRoot[] pfrs = jp.getAllPackageFragmentRoots();
                                    Path path = new Path(codeLink.getFile().getPathName().substring(5));
                                    IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                                    path = path.makeRelativeTo(root);
                                    IPackageFragmentRoot[] iPackageFragmentRootArray = pfrs;
                                    int n = pfrs.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IPackageFragmentRoot pfr = iPackageFragmentRootArray[n2];
                                        if (pfr.getPath().isPrefixOf((IPath)path)) {
                                            String text = path.makeRelativeTo(pfr.getPath()).toString().replaceAll("/", "\\.");
                                            text = text.substring(0, text.length() - 5);
                                            if (!SelectAlternativeTab.this.isImplSelected.booleanValue()) {
                                                SelectAlternativeTab.this.compImplText.setText(text);
                                            } else {
                                                SelectAlternativeTab.this.compImplText.setText(String.valueOf(SelectAlternativeTab.this.compImplText.getText()) + ";" + text);
                                            }
                                            SelectAlternativeTab.this.isImplSelected = true;
                                            break;
                                        }
                                        ++n2;
                                    }
                                }
                                catch (CoreException coreException) {}
                            }
                            if (isTBPSelected.booleanValue()) continue;
                            ((JPFCheckConfigTab)SelectAlternativeTab.this.jpfConfigTabReference).setTBPFile("/" + alternative.getRepository().getQProject().getProject().getName() + "/" + SelectAlternativeTab.createTBPFilename(alternative, SelectAlternativeTab.this.getSelectedComponent().getName()).replaceAll("\\\\", "/"));
                            isTBPSelected = true;
                        }
                    }
                    catch (RepositoryException e) {
                        System.err.println("Cannot get the model");
                        e.printStackTrace();
                    }
                }
                SelectAlternativeTab.this.setDirty(true);
                SelectAlternativeTab.this.updateLaunchConfigurationDialog();
            }
        });
        GridDataFactory.generate((Control)this.componentList.getControl(), (int)3, (int)20);
        Label compImplLabel = new Label(composite, 0);
        compImplLabel.setText("Comp. impl.");
        compImplLabel.setToolTipText("Component implementation");
        GridDataFactory.generate((Control)compImplLabel, (int)2, (int)1);
        this.compImplText = new Text(composite, 2052);
        GridDataFactory.generate((Control)this.compImplText, (int)1, (int)1);
        this.compImplText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectAlternativeTab.this.setDirty(true);
                SelectAlternativeTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.compImplText.setEditable(false);
    }

    protected boolean validatePage() {
        this.selectedAlternative = this.alternativeViewer.getFirstSelectedAlternative();
        if (this.getSelectedAlternative() == null) {
            this.setErrorMessage("An alternative has to be selected!");
            return false;
        }
        if (this.selectedComponent == null) {
            this.setErrorMessage("A primitive component has to be selected!");
            return false;
        }
        if (this.selectedComponent == null) {
            this.setErrorMessage("A primitive component has to be selected!");
            return false;
        }
        if (!this.isImplSelected.booleanValue()) {
            this.setErrorMessage("Selected Component does not have associated source file!");
            return false;
        }
        return true;
    }

    public String getName() {
        return "Select component";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        return this.validatePage();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            IQAlternative alternative = null;
            String attribute = configuration.getAttribute("eu.qimpress.ide.checkers.jpfcheck.alternative.id", null);
            if (attribute != null) {
                IQElement element = QImpressApplicationModelManager.getManager().getQAppModel().getElementByID(attribute);
                if (element != null && element.getElementType().equals((Object)IQElement.ElementType.Q_ALTERNATIVE)) {
                    alternative = (IQAlternative)element;
                }
                if (alternative != null) {
                    this.alternativeViewer.setSelection((ISelection)new StructuredSelection((Object)alternative));
                }
            }
            this.compImplText.setText(configuration.getAttribute("eu.qimpress.ide.checkers.jpfcheck.comp.impl", ""));
            this.compImplText.setText("Select component...");
            this.isImplSelected = false;
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.selectedAlternative = this.alternativeViewer.getFirstSelectedAlternative();
        if (this.getSelectedAlternative() != null) {
            configuration.setAttribute("eu.qimpress.ide.checkers.jpfcheck.alternative.id", this.getSelectedAlternative().getInfo().getId());
        }
        if (this.getSelectedModel() != null) {
            configuration.setAttribute("eu.qimpress.ide.checkers.jpfcheck.input.repository", this.getSelectedModel().getCorrespondingResource().getFullPath().toPortableString());
        }
        if (this.getSelectedComponent() != null) {
            configuration.setAttribute("eu.qimpress.ide.checkers.jpfcheck.component.id", this.getSelectedComponent().getId());
        }
        configuration.setAttribute("eu.qimpress.ide.checkers.jpfcheck.comp.impl", this.compImplText.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected void updateComponentList(IQModel ssModel) {
        EObject topEO = ssModel.getTopLevelEObject();
        if (topEO instanceof Repository) {
            Repository repo = (Repository)topEO;
            EList compTypes = repo.getComponenttype();
            for (ComponentType cType : compTypes) {
                if (!(cType instanceof PrimitiveComponent)) continue;
                this.componentList.add((Object)cType);
                if (this.selectedComponent == null || !cType.getId().equals(this.selectedComponent.getId())) continue;
                this.componentList.setChecked((Object)this.selectedComponent, true);
            }
        }
    }

    public IQModel getSelectedModel() {
        return this.selectedModel;
    }

    public ComponentType getSelectedComponent() {
        return this.selectedComponent;
    }

    public IQAlternative getSelectedAlternative() {
        return this.selectedAlternative;
    }
}

