/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.checkers.jpfcheck.ui.tabs;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.checkers.jpfcheck.ui.BrowseDialogsHelper;
import eu.qimpress.ide.checkers.jpfcheck.ui.tabs.SelectAlternativeTab;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JPFCheckConfigTab
extends AbstractLaunchConfigurationTab {
    private static final String DEFAULT_ENV_EMPTY_SET = "org.ow2.dsrg.fm.tbpjava.envgen.EmptyValueSet";
    protected Text behavProtFilenameText;
    protected Text envValueSetsText;
    private ILaunchConfiguration conf;
    private SelectAlternativeTab selectAlternativeTab;

    public JPFCheckConfigTab(SelectAlternativeTab tab1) {
        this.selectAlternativeTab = tab1;
    }

    public void createControl(Composite parent) {
        Composite rootContainer = new Composite(parent, 0);
        rootContainer.setLayoutData((Object)new GridData(768));
        rootContainer.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)rootContainer);
        Button selectionButton = null;
        GridData data = null;
        Label behavProtFileLabel = new Label(rootContainer, 0);
        behavProtFileLabel.setText("Behavior protocol:");
        behavProtFileLabel.setToolTipText("Select behavior protocol file - e.g., *.tbp");
        this.behavProtFilenameText = new Text(rootContainer, 2052);
        data = new GridData(768);
        data.widthHint = 200;
        this.behavProtFilenameText.setLayoutData((Object)data);
        this.behavProtFilenameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JPFCheckConfigTab.this.setDirty(true);
                JPFCheckConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        selectionButton = new Button(rootContainer, 8);
        selectionButton.setText("Browse");
        selectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile selectedFile = BrowseDialogsHelper.browseForFile(JPFCheckConfigTab.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), "*.tbp");
                if (selectedFile != null) {
                    JPFCheckConfigTab.this.behavProtFilenameText.setText(selectedFile.getFullPath().toPortableString());
                    JPFCheckConfigTab.this.setDirty(true);
                    JPFCheckConfigTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Label envValueSetsLabel = new Label(rootContainer, 0);
        envValueSetsLabel.setText("env.valuesets = ");
        envValueSetsLabel.setToolTipText("Setup class configuration environment parameters for JPF. E.g., env.valuesets=de.itemis.qimpress.showcase.crm_simulator.TestCRMManager");
        this.envValueSetsText = new Text(rootContainer, 2052);
        data = new GridData(768);
        data.widthHint = 200;
        this.envValueSetsText.setLayoutData((Object)data);
        this.envValueSetsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JPFCheckConfigTab.this.setDirty(true);
                JPFCheckConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        selectionButton = new Button(rootContainer, 8);
        selectionButton.setText("Browse");
        selectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IQAlternative selectedAlternative = JPFCheckConfigTab.this.selectAlternativeTab.getSelectedAlternative();
                if (selectedAlternative != null) {
                    IProject project = selectedAlternative.getRepository().getQProject().getProject();
                    IType selectedType = BrowseDialogsHelper.browseForClass(JPFCheckConfigTab.this.getShell(), new IJavaElement[]{JavaCore.create((IProject)project)}, "Test*");
                    if (selectedType != null) {
                        JPFCheckConfigTab.this.envValueSetsText.setText(selectedType.getFullyQualifiedName());
                        JPFCheckConfigTab.this.setDirty(true);
                        JPFCheckConfigTab.this.updateLaunchConfigurationDialog();
                    }
                } else {
                    MessageDialog.openInformation((Shell)JPFCheckConfigTab.this.getShell(), (String)"Browse for type", (String)"Alternative has to be selected before browsing");
                }
            }
        });
    }

    public String getName() {
        return "Consistency checker configuration";
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.conf = config;
            this.behavProtFilenameText.setText(config.getAttribute("eu.qimpress.ide.checkers.jpfcheck.behavprot.file", ""));
            this.envValueSetsText.setText(config.getAttribute("eu.qimpress.ide.checkers.jpfcheck.env.valuesets", DEFAULT_ENV_EMPTY_SET));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void setTBPFile(String tbpFilePath) {
        ((ILaunchConfigurationWorkingCopy)this.conf).setAttribute("eu.qimpress.ide.checkers.jpfcheck.behavprot.file", tbpFilePath);
    }

    public void performApply(ILaunchConfigurationWorkingCopy conf) {
        conf.setAttribute("eu.qimpress.ide.checkers.jpfcheck.behavprot.file", this.behavProtFilenameText.getText());
        conf.setAttribute("eu.qimpress.ide.checkers.jpfcheck.env.valuesets", this.envValueSetsText.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected boolean validatePage() {
        IQAlternative alt = this.selectAlternativeTab.getSelectedAlternative();
        Path path = new Path(this.behavProtFilenameText.getText());
        if (alt == null) {
            return false;
        }
        if (!path.isValidPath(path.toString())) {
            return false;
        }
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        if (!f.exists()) {
            this.setErrorMessage("Behavior Protocol File is not selected or not present in the filesystem");
            return false;
        }
        return true;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        return this.validatePage();
    }
}

