/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.checkers.jpfcheck.ui;

import de.uka.ipd.sdq.workflow.Blackboard;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedLaunchConfigurationDelegate;
import de.uka.ipd.sdq.workflow.launchconfig.LoggerAppenderStruct;
import de.uka.ipd.sdq.workflow.ui.UIBasedWorkflow;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.checkers.jpfcheck.ui.JPFCheckConfiguration;
import eu.qimpress.ide.checkers.jpfcheck.workflow.JPFCheckJob;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.Repository;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.EList;

public class JPFCheckConfigurationDelegate
extends AbstractWorkflowBasedLaunchConfigurationDelegate<JPFCheckConfiguration, UIBasedWorkflow<Blackboard<String>>> {
    protected IJob createWorkflowJob(JPFCheckConfiguration config, ILaunch launch) throws CoreException {
        JPFCheckJob job = new JPFCheckJob(config);
        return job;
    }

    protected JPFCheckConfiguration deriveConfiguration(ILaunchConfiguration conf, String mode) throws CoreException {
        JPFCheckConfiguration jpfConf = new JPFCheckConfiguration();
        try {
            jpfConf.alternative = (IQAlternative)QImpressApplicationModelManager.getManager().getQAppModel().getElementByID(conf.getAttribute("eu.qimpress.ide.checkers.jpfcheck.alternative.id", ""));
            jpfConf.model = jpfConf.alternative.getModel("samm_repository");
            String ctID = conf.getAttribute("eu.qimpress.ide.checkers.jpfcheck.component.id", null);
            Repository repoEO = (Repository)jpfConf.model.getTopLevelEObject();
            EList ctList = repoEO.getComponenttype();
            for (ComponentType cType : ctList) {
                if (!cType.getId().equals(ctID)) continue;
                jpfConf.componentType = cType;
                break;
            }
            jpfConf.componentImpl = conf.getAttribute("eu.qimpress.ide.checkers.jpfcheck.comp.impl", null);
            IFile protocolFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromPortableString((String)conf.getAttribute("eu.qimpress.ide.checkers.jpfcheck.behavprot.file", null)));
            jpfConf.protocolFile = new File(protocolFile.getLocationURI());
            jpfConf.additionalParameters.put("env.valuesets", conf.getAttribute("eu.qimpress.ide.checkers.jpfcheck.env.valuesets", null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jpfConf;
    }

    protected ArrayList<LoggerAppenderStruct> setupLogging(Level logLevel) throws CoreException {
        ArrayList<LoggerAppenderStruct> loggerList = new ArrayList<LoggerAppenderStruct>();
        loggerList.add(this.setupLogger("de.uka.ipd.sdq.workflow", logLevel, "[%-10t] %-5p: %m%n"));
        loggerList.add(this.setupLogger("eu.qimpress.ide.checkers.jpfcheck", logLevel, "[%-10t] %-5p: %m%n"));
        return loggerList;
    }
}

