/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.checkers.jpfcheck.log;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jOutputStream
extends OutputStream {
    public static final int DEFAULT_BUFFER_LENGTH = 2048;
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private ClassLoader classLoader;
    private Logger logger;
    private Level level;
    private boolean hasBeenClosed = false;
    private byte[] buffer;
    private int bufferLength;
    private int count;

    public Log4jOutputStream(Logger logger, Level level, ClassLoader classLoader) {
        this.logger = logger;
        this.level = level;
        this.classLoader = classLoader;
        this.bufferLength = 2048;
        this.buffer = new byte[this.bufferLength];
        this.count = 0;
    }

    public Log4jOutputStream(Logger logger, Level level) {
        this(logger, level, null);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.hasBeenClosed) {
            throw new IOException("The stream has been closed.");
        }
        if (b == 0) {
            return;
        }
        if (this.count == this.bufferLength) {
            int newBufferLength = this.bufferLength + 2048;
            byte[] newBuffer = new byte[newBufferLength];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.bufferLength);
            this.buffer = newBuffer;
            this.bufferLength = newBufferLength;
        }
        this.buffer[this.count++] = (byte)b;
        if (this.bufferEndsWithNewline()) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.count == 0) {
            return;
        }
        if (this.count == LINE_SEPARATOR.length() && this.bufferEndsWithNewline()) {
            this.reset();
            return;
        }
        int lenToOutput = 0;
        lenToOutput = this.bufferEndsWithNewline() ? this.count - LINE_SEPARATOR.length() : this.count;
        byte[] outputBuffer = new byte[lenToOutput];
        System.arraycopy(this.buffer, 0, outputBuffer, 0, lenToOutput);
        ClassLoader cl = null;
        if (this.classLoader != null) {
            cl = this.switchClassLoader(this.classLoader);
        }
        this.logger.log((Priority)this.level, (Object)new String(outputBuffer));
        if (this.classLoader != null) {
            this.switchClassLoader(cl);
        }
        this.reset();
    }

    protected boolean bufferEndsWithNewline() {
        return this.count >= LINE_SEPARATOR.length() && (LINE_SEPARATOR.length() == 1 && (char)this.buffer[this.count - 1] == LINE_SEPARATOR.charAt(0) || LINE_SEPARATOR.length() == 2 && (char)this.buffer[this.count - 1] == LINE_SEPARATOR.charAt(1) && (char)this.buffer[this.count - 2] == LINE_SEPARATOR.charAt(0));
    }

    protected ClassLoader switchClassLoader(ClassLoader cloader) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cloader);
        return cl;
    }

    private void reset() {
        this.count = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.hasBeenClosed = true;
    }
}

