/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.project.listeners;

import eu.qimpress.ide.backbone.project.adapters.IConcreteSyntaxFile;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.core.editor.XtextEditor;

public class XtextResourceChangeListener
implements IResourceChangeListener,
IPartListener {
    private static final Logger logger = Logger.getLogger(XtextResourceChangeListener.class);
    private IConcreteSyntaxFile concreteSyntaxFile;

    public XtextResourceChangeListener(IConcreteSyntaxFile concreteSyntaxFile) {
        this.concreteSyntaxFile = concreteSyntaxFile;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta resourceDelta;
        if (event.getType() == 1 && (resourceDelta = event.getDelta().findMember(this.concreteSyntaxFile.getOutputFile().getFullPath())) != null && resourceDelta.getResource().equals((Object)this.concreteSyntaxFile.getOutputFile()) && (resourceDelta.getFlags() & 0x100) == 256) {
            this.handleFileChange();
        }
    }

    protected void handleFileChange() {
        final Resource ecoreResource = this.concreteSyntaxFile.getOriginalResource();
        final Resource xtextResource = this.concreteSyntaxFile.getConcreteResource();
        try {
            xtextResource.unload();
            xtextResource.load(Collections.EMPTY_MAP);
            if (!xtextResource.getErrors().isEmpty()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Propagation of changes into model", (String)"Changes in the text editor cannot be propageted into ecore model due to errors in concrete syntax");
                    }
                });
                return;
            }
            Job job = new Job("Update Ecore resource"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ecoreResource.unload();
                        ecoreResource.getContents().addAll((Collection)xtextResource.getContents());
                        logger.info((Object)"Transfering content of Xtext resource back into Ecore resource");
                        ecoreResource.save(null);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Cannot transfer content of XText model resource back into ECore resource", (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.schedule();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof XtextEditor) {
            IEditorInput editorInput = ((XtextEditor)part).getEditorInput();
            logger.trace((Object)("Try to close editor with editorinput=" + editorInput));
            if (editorInput instanceof FileEditorInput && ((FileEditorInput)editorInput).getFile().equals((Object)this.concreteSyntaxFile.getOutputFile())) {
                logger.trace((Object)("Closing editor for " + editorInput));
                logger.trace((Object)"Disposing concrete file");
                this.concreteSyntaxFile.dispose();
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

