/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.project.adapters;

import eu.qimpress.ide.backbone.project.Activator;
import eu.qimpress.ide.backbone.project.adapters.IConcreteSyntaxFile;
import eu.qimpress.samm.core.NamedEntity;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mwe.core.WorkflowRunner;
import org.eclipse.ui.PartInitException;

public class MWEBasedConcreteSyntaxFile
implements IConcreteSyntaxFile {
    public static final String MODEL_TEMPLATES_DIR = "/workflow";
    private NamedEntity namedEntity;
    private IProject project;
    private IFile file;

    public MWEBasedConcreteSyntaxFile(NamedEntity namedEntity, IFile file) {
        this.namedEntity = namedEntity;
        this.project = file.getProject();
        this.file = file;
    }

    @Override
    public IFile generate() {
        IFile result = null;
        try {
            this.doGenerate();
            result = this.file;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void doGenerate() throws URISyntaxException, IOException {
        URL mweFileURL = FileLocator.toFileURL((URL)Activator.getDefault().getBundle().getEntry("/workflow/EdificeGenerator.mwe"));
        String mweFile = mweFileURL.getFile();
        HashMap<String, String> properties = new HashMap<String, String>(1);
        Map<String, NamedEntity> slotContents = Collections.singletonMap("model", this.namedEntity);
        properties.put("outputFolder", URIUtil.toFile((URI)this.file.getParent().getLocationURI()).getAbsolutePath());
        new WorkflowRunner().run(mweFile, null, properties, slotContents);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(NamedEntity.class)) {
            return this.namedEntity;
        }
        if (adapter.equals(EObject.class)) {
            return this.namedEntity;
        }
        if (adapter.equals(IProject.class)) {
            return this.project;
        }
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Resource getConcreteResource() {
        return null;
    }

    @Override
    public Resource getOriginalResource() {
        return null;
    }

    @Override
    public IFile getOutputFile() {
        return null;
    }

    @Override
    public void openInEditor(String editorId) throws PartInitException {
    }
}

