/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.operations;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.IQWorkspaceController;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.resultmodel.ResultModelFactory;
import eu.qimpress.resultmodel.ResultRepository;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class InitializeQImpressProjectOperation
extends WorkspaceModifyOperation {
    private static final Logger logger = Logger.getLogger(InitializeQImpressProjectOperation.class);
    private IProject project;

    public InitializeQImpressProjectOperation(IProject project) {
        this.project = project;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            try {
                this.createCommonInfrastructure(this.project);
            }
            catch (Exception e) {
                logger.error((Object)("Cannot setup Q-ImPrESS nature for project " + this.project), (Throwable)e);
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void createCommonInfrastructure(IProject project) throws RepositoryException {
        IQProject qProject = QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);
        IQRepository qRepository = qProject.getRepository();
        IQWorkspaceController repositoryController = (IQWorkspaceController)qRepository.getAdapter(IQWorkspaceController.class);
        if (repositoryController != null) {
            repositoryController.init(false, true);
        }
        boolean foundGlobalAlternative = false;
        boolean foundOtherAlternative = false;
        if (qRepository.listTopLevelAlternatives().length > 0) {
            foundOtherAlternative = true;
            logger.info((Object)"There is already an alternative present in the project that can be used as a main alternative");
        }
        if (qRepository.getAlternative("0") != null) {
            foundGlobalAlternative = true;
            logger.info((Object)"There is already an alternative present in the project that can be used as a main alternative");
        }
        if (!foundOtherAlternative) {
            IQAlternative defaultAlternative = qRepository.createAlternative("main alternative");
            qRepository.setDefaultAlternative(defaultAlternative);
        }
        if (!foundGlobalAlternative) {
            qRepository.createAlternative("global alternative", "0");
        }
        IQModel resultModel = qRepository.getResultModel();
        resultModel.getTopLevelEObject(ResultRepository.class, ResultModelFactory.eINSTANCE.getResultModelPackage().getResultRepository());
        resultModel.save();
    }
}

