/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.listeners;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.QImpressNature;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQInitializer;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.IQWorkspaceController;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class QImpressProjectlResourceChangedListener
implements IResourceChangeListener {
    private static final Logger logger = Logger.getLogger(QImpressProjectlResourceChangedListener.class);

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 4 || event.getType() == 2) {
            IResource resource = event.getResource();
            logger.trace((Object)("PRE_DELETE event received on resource " + resource));
            if (resource != null && resource.getType() == 4) {
                IProject project = (IProject)resource;
                this.handleProjectDelete(project);
            }
        } else if (event.getType() == 1) {
            IResourceDeltaVisitor deltaVisitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if ((delta.getKind() == 1 || delta.getKind() == 4 && (delta.getFlags() & 0x4000) != 0) && delta.getResource().getType() == 4) {
                        IProject project = (IProject)delta.getResource();
                        logger.trace((Object)("POST_CHANGE event received on project: " + project));
                        if (QImpressNature.hasThisNature(project)) {
                            QImpressProjectlResourceChangedListener.this.handleProjectAdded(project);
                        }
                        return true;
                    }
                    return true;
                }
            };
            try {
                event.getDelta().accept(deltaVisitor);
            }
            catch (CoreException e) {
                logger.warn((Object)"Error occurred during the resource delta visiting. ", (Throwable)e);
            }
        }
    }

    protected void handleProjectDelete(IProject project) {
        try {
            IQApplicationModel qAppModel = QImpressApplicationModelManager.getManager().getQAppModel();
            IQProject qProject = qAppModel.getQProject(project);
            if (qProject != null) {
                logger.trace((Object)("PRE_DELETE event performed on Q-I project " + qProject));
                qAppModel.removeQProject(project);
            }
        }
        catch (RepositoryException e) {
            logger.error((Object)("Cannot close repository object for Q-I project: " + project), (Throwable)e);
        }
    }

    protected void handleProjectAdded(IProject project) {
        try {
            IQProject qProject = QImpressCore.getQProject(project);
            IQRepository qRepository = qProject.getRepository();
            IQInitializer initilizer = (IQInitializer)qRepository.getAdapter(IQInitializer.class);
            if (initilizer.needsInitialization()) {
                IQWorkspaceController controller = (IQWorkspaceController)qRepository.getAdapter(IQWorkspaceController.class);
                controller.init(true, false);
            }
        }
        catch (RepositoryException e) {
            logger.error((Object)"Cannot handle project addition.", (Throwable)e);
        }
    }
}

