/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.listeners;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.QImpressNature;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class ModelResourceChangedListener
implements IResourceChangeListener {
    private static final Logger logger = Logger.getLogger(ModelResourceChangedListener.class);

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta resourceDelta = event.getDelta();
            this.handleChangedResource(resourceDelta);
        }
    }

    private void handleChangedResource(IResourceDelta resourceDelta) {
        final ArrayList changedModels = new ArrayList();
        final ArrayList addedModels = new ArrayList();
        final ArrayList deletedModels = new ArrayList();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                IResource resource;
                IQModel model;
                if (delta.getKind() == 4) {
                    if ((delta.getFlags() & 0x100) == 0) {
                        return true;
                    }
                    IResource resource2 = delta.getResource();
                    IQModel model2 = ModelResourceChangedListener.this.getQModel(resource2);
                    if (model2 != null) {
                        logger.trace((Object)("Model changed: " + model2));
                        changedModels.add(model2);
                    }
                } else if (delta.getKind() == 1) {
                    IResource resource3 = delta.getResource();
                    IQModel model3 = ModelResourceChangedListener.this.getQModel(resource3);
                    if (model3 != null) {
                        logger.trace((Object)("Model added: " + model3));
                        addedModels.add(model3);
                    }
                } else if (delta.getKind() == 2 && (model = ModelResourceChangedListener.this.getQModel(resource = delta.getResource())) != null) {
                    logger.trace((Object)("Model deleted: " + model));
                    deletedModels.add(model);
                }
                return true;
            }
        };
        try {
            resourceDelta.accept(visitor);
            if (changedModels.size() > 0) {
                QImpressApplicationModelManager.getManager().getQAppModel().fireModelModified(changedModels.toArray(new IQModel[changedModels.size()]));
            }
            if (addedModels.size() > 0) {
                QImpressApplicationModelManager.getManager().getQAppModel().fireModelCreated(addedModels.toArray(new IQModel[addedModels.size()]));
            }
            if (deletedModels.size() > 0) {
                QImpressApplicationModelManager.getManager().getQAppModel().fireModelDeleted(deletedModels.toArray(new IQModel[deletedModels.size()]));
            }
        }
        catch (CoreException e) {
            logger.error((Object)("Cannot proceed changes in the workspace because of " + e.getMessage()), (Throwable)e);
        }
    }

    private IQModel getQModel(IResource resource) {
        if (resource.getType() == 1 && QImpressNature.hasThisNature(resource.getProject())) {
            IQModel model = QImpressCore.getModelByFile((IFile)resource);
            return model;
        }
        return null;
    }
}

