/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.listeners;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class AlternativeResourceChangedListener
implements IResourceChangeListener {
    private static final Logger logger = Logger.getLogger(AlternativeResourceChangedListener.class);

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta resourceDelta = event.getDelta();
            this.handleChangedResource(resourceDelta);
        }
    }

    private void handleChangedResource(IResourceDelta resourceDelta) {
        final ArrayList<IQAlternative> deletedAlternatives = new ArrayList<IQAlternative>();
        IResourceDeltaVisitor deltaVisitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                String alternativeId;
                if (delta.getKind() == 2 && delta.getResource().getType() == 2 && (alternativeId = AlternativeResourceChangedListener.this.getAlternativeId((IFolder)delta.getResource())) != null) {
                    try {
                        IProject project = delta.getResource().getProject();
                        IQProject qProject = QImpressCore.getQProject(project);
                        if (qProject != null) {
                            IQAlternative qAlternative = qProject.getRepository().getAlternative(alternativeId);
                            if (qAlternative != null) {
                                logger.trace((Object)("Alternative " + qAlternative + " was added to a list of deleted alternatives."));
                                deletedAlternatives.add(qAlternative);
                            }
                        } else {
                            logger.warn((Object)("The Q-I project does not exist for the Eclipse project: " + project));
                        }
                    }
                    catch (RepositoryException e) {
                        logger.error((Object)"Some error occured during getting an alternative. Skipped.", (Throwable)e);
                    }
                }
                return true;
            }
        };
        try {
            resourceDelta.accept(deltaVisitor);
            this.processDeletedAlternatives(deletedAlternatives);
        }
        catch (CoreException e) {
            logger.warn((Object)"Error occured during processsing deleted alternative", (Throwable)e);
        }
    }

    private void processDeletedAlternatives(ArrayList<IQAlternative> deletedAlternatives) {
        ClearAlternativesJob job = new ClearAlternativesJob(deletedAlternatives);
        job.schedule();
    }

    private String getAlternativeId(IFolder folder) {
        String repositoryName = folder.getFullPath().segment(1);
        if ("alternatives".equals(repositoryName)) {
            return folder.getFullPath().lastSegment();
        }
        return null;
    }

    private static final class ClearAlternativesJob
    extends Job {
        private List<IQAlternative> deletedAlternatives;

        public ClearAlternativesJob(List<IQAlternative> deletedAlternatives) {
            super("Clear alternatives");
            this.setSystem(true);
            this.setPriority(20);
            this.deletedAlternatives = deletedAlternatives;
        }

        protected IStatus run(IProgressMonitor monitor) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    monitor.beginTask("", ClearAlternativesJob.this.deletedAlternatives.size());
                    try {
                        for (IQAlternative alt : ClearAlternativesJob.this.deletedAlternatives) {
                            IQRepository qRepository = alt.getRepository();
                            logger.trace((Object)("Clearing alternative, because its folder does not exist. Alternative: " + alt));
                            try {
                                qRepository.deleteAlternative(alt, false, true);
                            }
                            catch (RepositoryException e) {
                                logger.warn((Object)("Cannot clear alternative: " + alt), (Throwable)e);
                            }
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            monitor.beginTask("", this.deletedAlternatives.size());
            try {
                try {
                    operation.run((IProgressMonitor)new SubProgressMonitor(monitor, this.deletedAlternatives.size()));
                }
                catch (Exception e) {
                    logger.error((Object)"Exception occured during clearing alternatives!", (Throwable)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

