/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.wizards;

import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NewQAlternativePage
extends WizardPage {
    Text alternativeNameField;
    TreeViewer alternativeViewer;
    private IQElement parentElement;

    protected NewQAlternativePage(IQElement parentElement) {
        super("Create new alternative");
        this.setTitle("Create new alternative");
        this.setDescription("Select parent for new alternative and its name");
        this.setPageComplete(false);
        this.parentElement = parentElement;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.setControl((Control)composite);
        Label parentAlternativeLabel = new Label(composite, 0);
        parentAlternativeLabel.setText("Parent alternative");
        GridDataFactory.generate((Control)parentAlternativeLabel, (int)1, (int)1);
        this.alternativeViewer = QAlternativesTreeViewerFactory.createTreeViewer(composite, QAlternativesTreeViewerFactory.SelectAlternativesEnum.SELECT_ONE).setParentElement(this.parentElement).getTreeViewer();
        GridDataFactory.generate((Control)this.alternativeViewer.getControl(), (int)3, (int)1);
        Label alternativeNameLabel = new Label(composite, 0);
        alternativeNameLabel.setText("Name");
        GridDataFactory.generate((Control)alternativeNameLabel, (int)1, (int)1);
        this.alternativeNameField = new Text(composite, 2048);
        this.alternativeNameField.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                boolean valid = NewQAlternativePage.this.validatePage();
                NewQAlternativePage.this.setPageComplete(valid);
            }
        });
        GridDataFactory.generate((Control)this.alternativeNameField, (int)3, (int)1);
    }

    public IStructuredSelection getAlternativeParentSelection() {
        ISelection selection = this.alternativeViewer.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public String getAlternativeName() {
        return this.alternativeNameField.getText();
    }

    protected boolean validatePage() {
        String altName = this.getAlternativeName();
        this.setErrorMessage(null);
        this.setMessage(null);
        if (altName == null || altName.equals("")) {
            this.setErrorMessage("Alternative name cannot be null!");
            return false;
        }
        if (this.getAlternativeParentSelection() == null) {
            this.setErrorMessage("Parent alternative or alternative repository/project has to be selected!");
        }
        return true;
    }
}

