/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.tabs;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.ui.tabs.QImpressAlternativeSelectionTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class QImpressAlternativeUsageScenarioSelectionTab
extends QImpressAlternativeSelectionTab {
    public static final String SELECTED_ALTERNATIVE_GUID = "eu.qimpress.reverseengineering.alternativeselection";
    private CheckboxTreeViewer myAlternativesViewer;
    private Label selectionText;

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        IQApplicationModel model;
        IQElement alternative;
        String guid = "";
        try {
            guid = configuration.getAttribute(SELECTED_ALTERNATIVE_GUID, "");
        }
        catch (CoreException coreException) {}
        if (!guid.equals("") && (alternative = (model = (IQApplicationModel)this.myAlternativesViewer.getInput()).getElementByID(guid)) != null) {
            this.myAlternativesViewer.expandAll();
            this.myAlternativesViewer.setChecked((Object)alternative, true);
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Object[] elements = this.myAlternativesViewer.getCheckedElements();
        if (elements.length != 1 || !(elements[0] instanceof IQAlternative)) {
            configuration.setAttribute(SELECTED_ALTERNATIVE_GUID, "");
        } else {
            IQAlternative selectedAlternative = (IQAlternative)elements[0];
            configuration.setAttribute(SELECTED_ALTERNATIVE_GUID, selectedAlternative.getInfo().getId());
        }
    }

    @Override
    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!super.isValid(launchConfig)) {
            return false;
        }
        return this.getErrorMessage() == null;
    }

    @Override
    public String getErrorMessage() {
        Object[] elements = this.myAlternativesViewer.getCheckedElements();
        if (elements.length != 1) {
            return "Select a single alternative";
        }
        if (!(elements[0] instanceof IQAlternative)) {
            return "Selection is not an alternative";
        }
        return null;
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SELECTED_ALTERNATIVE_GUID, "");
    }
}

