/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.ui.actions.QElementSelectionDispatchAction;
import eu.qimpress.ide.backbone.core.ui.internal.QImpressUICorePluginImages;
import eu.qimpress.ide.backbone.core.ui.wizards.NewQAlternativeWizard;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class OpenNewAlternativeWizardAction
extends QElementSelectionDispatchAction {
    public OpenNewAlternativeWizardAction(IWorkbenchSite site) {
        this(site, null);
    }

    public OpenNewAlternativeWizardAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget) {
        super(site, selectionTarget);
        this.setText("New alternative");
        this.setDescription("Create new alternative");
        this.setImageDescriptor(QImpressUICorePluginImages.DESC_ALTERNATIVE);
    }

    @Override
    public void run() {
        Shell shell = this.getShell();
        try {
            INewWizard wizard = this.createWizard();
            wizard.init(PlatformUI.getWorkbench(), this.getSelection());
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
            dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
            dialog.create();
            int res = dialog.open();
            this.notifyResult(res == 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected INewWizard createWizard() {
        return new NewQAlternativeWizard();
    }

    @Override
    protected void postSelectionChanged(IQElement[] elements) {
        if (elements.length == 1 && elements[0].getElementType() == IQElement.ElementType.Q_ALTERNATIVE) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

