/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import eu.qimpress.ide.backbone.core.ui.actions.CompleteDeleteAlternativeAction;
import eu.qimpress.ide.backbone.core.ui.actions.DeleteAlternativeAction;
import eu.qimpress.ide.backbone.core.ui.actions.MakeAlternativeDefaultAction;
import eu.qimpress.ide.backbone.core.ui.actions.OpenNewAlternativeWizardAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.ISetSelectionTarget;

public class AlternativesActionGroup
extends ActionGroup {
    public static final String ALTERNATIVES_MENU_ID = "eu.qimpress.ide.backbone.core.ui.alternatives.menu";
    private OpenNewAlternativeWizardAction createAlternativeAction;
    private MakeAlternativeDefaultAction makeAlternativeDefaultAction;
    private DeleteAlternativeAction deleteAlternativeAction;
    private CompleteDeleteAlternativeAction completeDeleteAlternativeAction;
    private ISelectionProvider selectionProvider;
    private IWorkbenchSite site;

    public AlternativesActionGroup(IViewPart viewPart) {
        this(viewPart, null);
    }

    public AlternativesActionGroup(IViewPart viewPart, ISelectionProvider selectionProvider) {
        this.site = viewPart.getSite();
        this.selectionProvider = selectionProvider;
        ISetSelectionTarget selectionTarget = null;
        selectionTarget = viewPart instanceof ISetSelectionTarget ? (ISetSelectionTarget)viewPart : (ISetSelectionTarget)viewPart.getAdapter(ISetSelectionTarget.class);
        this.createSiteActions((IWorkbenchSite)viewPart.getSite(), selectionProvider, selectionTarget);
    }

    private void createSiteActions(IWorkbenchSite site, ISelectionProvider selectionProvider, ISetSelectionTarget selectionTarget) {
        this.createAlternativeAction = new OpenNewAlternativeWizardAction(site, selectionTarget);
        this.makeAlternativeDefaultAction = new MakeAlternativeDefaultAction(site, selectionTarget);
        this.deleteAlternativeAction = new DeleteAlternativeAction(site);
        this.completeDeleteAlternativeAction = new CompleteDeleteAlternativeAction(site);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.createAlternativeAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.makeAlternativeDefaultAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteAlternativeAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.completeDeleteAlternativeAction);
        this.createAlternativeAction.selectionChanged(new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection()));
        this.makeAlternativeDefaultAction.selectionChanged(new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection()));
        this.deleteAlternativeAction.selectionChanged(new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection()));
        this.completeDeleteAlternativeAction.selectionChanged(new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection()));
    }

    public void fillActionBars(IActionBars actionBars) {
        this.shareGlobalActions(actionBars);
    }

    public void fillContextMenu(IMenuManager menu) {
        this.fillViewSubMenu(menu);
    }

    private void fillViewSubMenu(IMenuManager menu) {
        this.addToGroup(menu, "group.new", (IAction)this.createAlternativeAction);
        this.addToGroup(menu, "additions", (IAction)this.makeAlternativeDefaultAction);
        this.addToGroup(menu, "group.edit", (IAction)this.deleteAlternativeAction);
        this.addToGroup(menu, "group.edit", (IAction)this.completeDeleteAlternativeAction);
    }

    private void addToGroup(IMenuManager menu, String groupName, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup(groupName, action);
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
    }

    public void dispose() {
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.completeDeleteAlternativeAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteAlternativeAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.makeAlternativeDefaultAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.createAlternativeAction);
        super.dispose();
    }

    protected void shareGlobalActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAlternativeAction);
    }
}

