/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui;

import eu.qimpress.ide.backbone.core.ui.actions.AlternativesActionGroup;
import eu.qimpress.ide.backbone.core.ui.actions.ModelsActionGroup;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class QAppNavigatorActionProvider
extends CommonActionProvider {
    private AlternativesActionGroup alternativesActionGroup;
    private ModelsActionGroup modelsActionGroup;
    private boolean inViewPart = false;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        ICommonViewerWorkbenchSite workbenchSite = null;
        if (aSite.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            workbenchSite = (ICommonViewerWorkbenchSite)aSite.getViewSite();
        }
        if (workbenchSite != null && workbenchSite.getPart() != null && workbenchSite.getPart() instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)workbenchSite.getPart();
            this.alternativesActionGroup = new AlternativesActionGroup(viewPart, (ISelectionProvider)aSite.getStructuredViewer());
            this.modelsActionGroup = new ModelsActionGroup(viewPart, (ISelectionProvider)aSite.getStructuredViewer());
            this.inViewPart = true;
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.inViewPart) {
            this.alternativesActionGroup.fillActionBars(actionBars);
            this.modelsActionGroup.fillActionBars(actionBars);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.inViewPart) {
            this.alternativesActionGroup.fillContextMenu(menu);
            this.modelsActionGroup.fillContextMenu(menu);
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (this.inViewPart) {
            this.alternativesActionGroup.setContext(context);
            this.modelsActionGroup.setContext(context);
        }
    }

    public void dispose() {
        if (this.inViewPart) {
            this.alternativesActionGroup.dispose();
            this.modelsActionGroup.dispose();
        }
        super.dispose();
    }
}

