/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.models.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;

public class SammModelFamilyActionsGroup
extends ActionGroup
implements ISelectionChangedListener {
    protected IAction showPropertiesViewAction = new Action("Show properties view"){

        public void run() {
            try {
                SammModelFamilyActionsGroup.this.activePart.getSite().getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    };
    protected DeleteAction deleteAction;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    private ISelectionProvider selectionProvider;
    private IWorkbenchPart activePart;
    private IMenuManager createChildMenuManager;
    private Collection<IAction> createChildActions;
    private IMenuManager createSiblingMenuManager;
    private Collection<IAction> createSiblingActions;

    public SammModelFamilyActionsGroup(IViewPart viewPart) {
        this(viewPart, null);
    }

    public SammModelFamilyActionsGroup(IViewPart viewPart, ISelectionProvider selectionProvider) {
        this.activePart = viewPart;
        this.selectionProvider = selectionProvider;
        this.createChildMenuManager = new MenuManager("Create child");
        this.createSiblingMenuManager = new MenuManager("Create sibling");
        this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        this.initActions();
    }

    private void initActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.deleteAction = new DeleteAction(true);
        this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.undoAction = new UndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.redoAction = new RedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
    }

    private void initMenus(IMenuManager menu) {
        menu.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        menu.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.shareGlobalActions(actionBars);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection) {
            ArrayList<EObject> eos = new ArrayList<EObject>(5);
            for (Object o : (IStructuredSelection)selection) {
                if (!(o instanceof EObject)) {
                    return;
                }
                eos.add((EObject)o);
            }
            if (eos.size() > 0) {
                this.fillMenus(menu, eos, selection);
            }
        }
    }

    private EditingDomain getEditingDomain(EObject eo) {
        return ((IEditingDomainProvider)eo.eResource().getResourceSet()).getEditingDomain();
    }

    protected void fillMenus(IMenuManager menu, List<EObject> selectedEntity, ISelection selection) {
        this.initMenus(menu);
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        EditingDomain domain = null;
        domain = this.getEditingDomain(selectedEntity.get(0));
        if (selectedEntity.size() == 1) {
            newChildDescriptors = domain.getNewChildDescriptors((Object)selectedEntity.get(0), null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, (Object)selectedEntity.get(0));
            this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
            this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
            if (this.createChildMenuManager != null) {
                this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            }
            if (this.createSiblingMenuManager != null) {
                this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            }
            menu.insertAfter("additions", this.showPropertiesViewAction);
        }
        this.updateGlobalActions(domain, (IStructuredSelection)selection);
        menu.add((IAction)this.undoAction);
        menu.add((IAction)this.redoAction);
        menu.add((IAction)this.deleteAction);
    }

    protected void updateGlobalActions(EditingDomain domain, IStructuredSelection selection) {
        this.deleteAction.setEditingDomain(domain);
        this.undoAction.setEditingDomain(domain);
        this.redoAction.setEditingDomain(domain);
        this.undoAction.update();
        this.redoAction.update();
    }

    protected void shareGlobalActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activePart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activePart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    public void dispose() {
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.createChildMenuManager.dispose();
        this.createSiblingMenuManager.dispose();
        super.dispose();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object o;
        if (event.getSelection() instanceof IStructuredSelection && !event.getSelection().isEmpty() && (o = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof EObject) {
            this.deleteAction.setEditingDomain(this.getEditingDomain((EObject)o));
        }
        this.deleteAction.selectionChanged(event);
    }
}

