/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Add
extends PostfixMathCommand {
    public Add() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object sum = stack.pop();
        int i = 1;
        while (i < this.curNumberOfParameters) {
            Object param = stack.pop();
            sum = this.add(param, sum);
            ++i;
        }
        stack.push(sum);
    }

    public Object add(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Complex) {
            if (param2 instanceof Complex) {
                return this.add((Complex)param1, (Complex)param2);
            }
            if (param2 instanceof Number) {
                return this.add((Complex)param1, (Number)param2);
            }
        } else if (param1 instanceof Number) {
            if (param2 instanceof Complex) {
                return this.add((Complex)param2, (Number)param1);
            }
            if (param2 instanceof Number) {
                return this.add((Number)param1, (Number)param2);
            }
        } else if (param1 instanceof String && param2 instanceof String) {
            return String.valueOf((String)param1) + (String)param2;
        }
        throw new ParseException("Invalid parameter type");
    }

    public Double add(Number d1, Number d2) {
        return new Double(d1.doubleValue() + d2.doubleValue());
    }

    public Complex add(Complex c1, Complex c2) {
        return new Complex(c1.re() + c2.re(), c1.im() + c2.im());
    }

    public Complex add(Complex c, Number d) {
        return new Complex(c.re() + d.doubleValue(), c.im());
    }
}

