/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep;

import org.lsmp.djep.xjep.XOperator;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.Complex;

public class TreeUtils {
    protected static Double ZERO = new Double(0.0);
    protected static Double ONE = new Double(1.0);
    protected static Double MINUSONE = new Double(-1.0);
    protected static Complex CZERO = new Complex(0.0, 0.0);
    protected static Complex CONE = new Complex(1.0, 0.0);
    protected static Complex CI = new Complex(0.0, 1.0);
    protected static Complex CMINUSONE = new Complex(-1.0, 0.0);
    protected static Complex CMINUSI = new Complex(0.0, -1.0);
    protected static Double NAN = new Double(Double.NaN);
    protected static Double PosInf = new Double(Double.POSITIVE_INFINITY);
    protected static Double NegInf = new Double(Double.NEGATIVE_INFINITY);

    public String getName(Node node) throws IllegalArgumentException {
        if (this.isVariable(node)) {
            return ((ASTVarNode)node).getName();
        }
        if (this.isFunction(node)) {
            return ((ASTFunNode)node).getName();
        }
        throw new IllegalArgumentException("Tried to find the name of constant node");
    }

    public Object getValue(Node node) throws IllegalArgumentException {
        if (!this.isConstant(node)) {
            throw new IllegalArgumentException("Tried to find the value of a non constant node");
        }
        return ((ASTConstant)node).getValue();
    }

    public double doubleValue(Node node) throws IllegalArgumentException {
        return (Double)this.getValue(node);
    }

    public long longValue(Node node) throws IllegalArgumentException {
        return ((Number)this.getValue(node)).longValue();
    }

    public int intValue(Node node) throws IllegalArgumentException {
        return ((Number)this.getValue(node)).intValue();
    }

    public Complex complexValue(Node node) throws IllegalArgumentException {
        return (Complex)this.getValue(node);
    }

    public boolean isConstant(Node node) {
        return node instanceof ASTConstant;
    }

    public boolean isReal(Node node) {
        return node instanceof ASTConstant && ((ASTConstant)node).getValue() instanceof Double;
    }

    public boolean isInteger(Node node) {
        if (this.isReal(node)) {
            double xInt;
            Number val = (Number)((ASTConstant)node).getValue();
            double x = val.doubleValue();
            return x == (xInt = Math.rint(x));
        }
        return false;
    }

    public boolean isZero(Node node) {
        return this.isReal(node) && ((ASTConstant)node).getValue().equals(ZERO) || this.isComplex(node) && ((Complex)((ASTConstant)node).getValue()).equals(CZERO, 0.0);
    }

    public boolean isZero(Node node, double tol) {
        return this.isReal(node) && ((ASTConstant)node).getValue().equals(ZERO) || Math.abs(this.doubleValue(node)) < tol || this.isComplex(node) && ((Complex)((ASTConstant)node).getValue()).equals(CZERO, tol);
    }

    public boolean isOne(Node node) {
        return this.isReal(node) && ((ASTConstant)node).getValue().equals(ONE) || this.isComplex(node) && ((Complex)((ASTConstant)node).getValue()).equals(CONE, 0.0);
    }

    public boolean isMinusOne(Node node) {
        return this.isReal(node) && ((ASTConstant)node).getValue().equals(MINUSONE) || this.isComplex(node) && ((Complex)((ASTConstant)node).getValue()).equals(CMINUSONE, 0.0);
    }

    public boolean isInfinity(Node node) {
        if (this.isReal(node)) {
            Double dub = (Double)((ASTConstant)node).getValue();
            return dub.isInfinite();
        }
        if (this.isComplex(node)) {
            Complex z = (Complex)((ASTConstant)node).getValue();
            return Double.isInfinite(z.re()) || Double.isInfinite(z.im());
        }
        return false;
    }

    public boolean isNaN(Node node) {
        if (this.isReal(node)) {
            Double dub = (Double)((ASTConstant)node).getValue();
            return dub.isNaN();
        }
        if (this.isComplex(node)) {
            Complex z = (Complex)((ASTConstant)node).getValue();
            return Double.isNaN(z.re()) || Double.isNaN(z.im());
        }
        return false;
    }

    public boolean isNegative(Node node) {
        return this.isReal(node) && (Double)((ASTConstant)node).getValue() < 0.0;
    }

    public boolean isPositive(Node node) {
        return this.isReal(node) && (Double)((ASTConstant)node).getValue() > 0.0;
    }

    public boolean isComplex(Node node) {
        return this.isConstant(node) && ((ASTConstant)node).getValue() instanceof Complex;
    }

    public boolean isVariable(Node node) {
        return node instanceof ASTVarNode;
    }

    public boolean isOperator(Node node) {
        return node instanceof ASTFunNode && ((ASTFunNode)node).isOperator();
    }

    public boolean isBinaryOperator(Node node) {
        if (this.isOperator(node)) {
            return ((XOperator)((ASTFunNode)node).getOperator()).isBinary();
        }
        return false;
    }

    public boolean isUnaryOperator(Node node) {
        if (this.isOperator(node)) {
            return ((XOperator)((ASTFunNode)node).getOperator()).isUnary();
        }
        return false;
    }

    public Operator getOperator(Node node) {
        if (this.isOperator(node)) {
            return ((ASTFunNode)node).getOperator();
        }
        return null;
    }

    public boolean isFunction(Node node) {
        return node instanceof ASTFunNode;
    }

    public static Node copyChildrenIfNeeded(Node node, Node[] children) throws ParseException {
        int n = node.jjtGetNumChildren();
        if (n != children.length) {
            throw new ParseException("copyChildrenIfNeeded: umber of children of node not the same as supplied children");
        }
        int i = 0;
        while (i < n) {
            if (node.jjtGetChild(i) != children[i]) {
                node.jjtAddChild(children[i], i);
                children[i].jjtSetParent(node);
            }
            ++i;
        }
        return node;
    }

    public static Node[] getChildrenAsArray(Node node) {
        int n = node.jjtGetNumChildren();
        Node[] children = new Node[n];
        int i = 0;
        while (i < n) {
            children[i] = node.jjtGetChild(i);
            ++i;
        }
        return children;
    }

    public Object getCI() {
        return CI;
    }

    public Object getCMINUSI() {
        return CMINUSI;
    }

    public Object getCMINUSONE() {
        return CMINUSONE;
    }

    public Object getCONE() {
        return CONE;
    }

    public Object getCZERO() {
        return CZERO;
    }

    public Object getMINUSONE() {
        return MINUSONE;
    }

    public Object getONE() {
        return ONE;
    }

    public Object getZERO() {
        return ZERO;
    }

    public Object getNAN() {
        return NAN;
    }

    public Object getPositiveInfinity() {
        return PosInf;
    }

    public Object getNegativeInfinity() {
        return NegInf;
    }

    public Object getNumber(double val) {
        return new Double(val);
    }
}

