/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import java.util.Stack;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Comparative;

public class ElementComparative
extends Comparative
implements BinaryOperatorI {
    public ElementComparative(int index) {
        super(index);
    }

    public Dimensions calcDim(Dimensions ldim, Dimensions rdim) {
        if (ldim.equals(rdim)) {
            return ldim;
        }
        return null;
    }

    public MatrixValueI calcValue(MatrixValueI res, MatrixValueI lhs, MatrixValueI rhs) throws ParseException {
        int len = res.getNumEles();
        int i = 0;
        while (i < len) {
            boolean val = false;
            switch (this.id) {
                case 0: {
                    val = this.lt(lhs.getEle(i), rhs.getEle(i));
                    break;
                }
                case 1: {
                    val = this.gt(lhs.getEle(i), rhs.getEle(i));
                    break;
                }
                case 2: {
                    val = this.le(lhs.getEle(i), rhs.getEle(i));
                    break;
                }
                case 3: {
                    val = this.ge(lhs.getEle(i), rhs.getEle(i));
                    break;
                }
                case 4: {
                    val = this.ne(lhs.getEle(i), rhs.getEle(i));
                    break;
                }
                case 5: {
                    val = this.eq(lhs.getEle(i), rhs.getEle(i));
                }
            }
            res.setEle(i, (Object)(val ? new Double(1.0) : new Double(0.0)));
            ++i;
        }
        return res;
    }

    public void run(Stack inStack) throws ParseException {
        MatrixValueI rhs;
        MatrixValueI lhs;
        Object rhsObj = inStack.pop();
        Object lhsObj = inStack.pop();
        if (lhsObj instanceof MatrixValueI && rhsObj instanceof MatrixValueI) {
            lhs = (MatrixValueI)lhsObj;
            rhs = (MatrixValueI)rhsObj;
            if (!lhs.getDim().equals(rhs.getDim())) {
                throw new ParseException("ElementComparative: dimensions of both sides must be equal");
            }
        } else {
            throw new ParseException("ElementComparative: arguments must be a Matric or Vector type");
        }
        Dimensions dims = this.calcDim(lhs.getDim(), lhs.getDim());
        MatrixValueI res = Tensor.getInstance((Dimensions)dims);
        this.calcValue(res, lhs, rhs);
        inStack.push(res);
    }
}

