/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.AbstractPNode;
import org.lsmp.djep.sjep.Monomial;
import org.lsmp.djep.sjep.MutiablePolynomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class Polynomial
extends AbstractPNode {
    PNodeI[] terms;

    Polynomial(PolynomialCreator pc, PNodeI[] terms) {
        super(pc);
        this.terms = terms;
    }

    MutiablePolynomial toMutiablePolynomial() {
        PNodeI[] newTerms = new PNodeI[this.terms.length];
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i];
            ++i;
        }
        return new MutiablePolynomial(this.pc, newTerms);
    }

    public PNodeI add(PNodeI node) throws ParseException {
        if (node instanceof Polynomial) {
            return this.add((Polynomial)node);
        }
        MutiablePolynomial mp = this.toMutiablePolynomial();
        mp.add(node);
        return mp.toPNode();
    }

    public PNodeI sub(PNodeI node) throws ParseException {
        if (node instanceof Polynomial) {
            return this.sub((Polynomial)node);
        }
        MutiablePolynomial mp = this.toMutiablePolynomial();
        mp.add(node.negate());
        return mp.toPNode();
    }

    public PNodeI add(Polynomial p) throws ParseException {
        MutiablePolynomial mp = this.toMutiablePolynomial();
        int i = 0;
        while (i < p.terms.length) {
            mp.add(p.terms[i]);
            ++i;
        }
        return mp.toPNode();
    }

    public PNodeI sub(Polynomial p) throws ParseException {
        MutiablePolynomial mp = this.toMutiablePolynomial();
        int i = 0;
        while (i < p.terms.length) {
            mp.add(p.terms[i].negate());
            ++i;
        }
        return mp.toPNode();
    }

    public PNodeI negate() throws ParseException {
        PNodeI[] newTerms = new PNodeI[this.terms.length];
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].negate();
            ++i;
        }
        return new Polynomial(this.pc, newTerms);
    }

    public PNodeI mul(PNodeI node) throws ParseException {
        if (node instanceof PConstant) {
            PConstant c = (PConstant)node;
            if (c.isZero()) {
                return this.pc.zeroConstant;
            }
            if (c.isOne()) {
                return this;
            }
        }
        return super.mul(node);
    }

    public PNodeI div(PNodeI node) throws ParseException {
        if (node instanceof PConstant) {
            PConstant c = (PConstant)node;
            if (c.isZero()) {
                return this.pc.infConstant;
            }
            if (c.isOne()) {
                return this;
            }
            PNodeI[] newTerms = new PNodeI[this.terms.length];
            int i = 0;
            while (i < this.terms.length) {
                newTerms[i] = this.terms[i].div((PNodeI)c);
                ++i;
            }
            return new Polynomial(this.pc, newTerms);
        }
        return super.div(node);
    }

    public boolean equals(PNodeI node) {
        if (!(node instanceof Polynomial)) {
            return false;
        }
        Polynomial p = (Polynomial)node;
        if (this.terms.length != p.terms.length) {
            return false;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].equals(p.terms[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int compareTo(PNodeI node) {
        if (node instanceof Polynomial) {
            return this.compareTo((Polynomial)node);
        }
        int res = this.terms[0].compareTo(node);
        if (res != 0) {
            return res;
        }
        if (this.terms.length == 1) {
            return 0;
        }
        return 1;
    }

    public int compareTo(Polynomial p) {
        int i = 0;
        while (i < this.terms.length) {
            if (i >= p.terms.length) {
                return 1;
            }
            int res = this.terms[i].compareTo(p.terms[i]);
            if (res != 0) {
                return res;
            }
            ++i;
        }
        if (this.terms.length < p.terms.length) {
            return -1;
        }
        return 0;
    }

    private boolean isNegative(PNodeI node) {
        if (node instanceof PConstant) {
            return ((PConstant)node).isNegative();
        }
        if (node instanceof Monomial) {
            return ((Monomial)node).negativeCoefficient();
        }
        return false;
    }

    public String toString() {
        if (this.terms.length == 0) {
            return "0";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.terms.length) {
            if (i > 0 && !this.isNegative(this.terms[i])) {
                sb.append('+');
            }
            sb.append(this.terms[i].toString());
            ++i;
        }
        return sb.toString();
    }

    public Node toNode() throws ParseException {
        if (this.terms.length == 0) {
            return this.pc.nf.buildConstantNode(this.pc.zero);
        }
        Node[] args = new Node[this.terms.length];
        int i = 0;
        while (i < this.terms.length) {
            args[i] = this.terms[i].toNode();
            ++i;
        }
        if (this.terms.length == 1) {
            return args[0];
        }
        return this.pc.nf.buildOperatorNode(this.pc.os.getAdd(), args);
    }

    public PNodeI expand() throws ParseException {
        MutiablePolynomial mp = new MutiablePolynomial(this.pc, new PNodeI[]{this.pc.zeroConstant});
        int i = 0;
        while (i < this.terms.length) {
            PNodeI exp = this.terms[i].expand();
            mp.add(exp);
            ++i;
        }
        return mp.toPNode();
    }

    public int getNTerms() {
        return this.terms.length;
    }

    public PNodeI getTerm(int i) {
        return this.terms[i];
    }
}

