/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.mrpe;

import java.util.Hashtable;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.matrixJep.MatrixOperatorSet;
import org.lsmp.djep.matrixJep.MatrixVariableI;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMFunNode;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMVarNode;
import org.lsmp.djep.matrixJep.nodeTypes.MatrixNodeI;
import org.lsmp.djep.mrpe.MRpCommandList;
import org.lsmp.djep.mrpe.MRpEval;
import org.lsmp.djep.mrpe.MRpRes;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.xjep.XOperator;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.Variable;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MRpEval
implements ParserVisitor {
    private MatrixOperatorSet opSet;
    static final short CONST = 0;
    static final short VAR = 1;
    static final short ADD = 2;
    static final short SUB = 3;
    static final short MUL = 4;
    static final short DIV = 5;
    static final short MOD = 6;
    static final short POW = 7;
    static final short AND = 8;
    static final short OR = 9;
    static final short NOT = 10;
    static final short LT = 11;
    static final short LE = 12;
    static final short GT = 13;
    static final short GE = 14;
    static final short NE = 15;
    static final short EQ = 16;
    static final short LIST = 17;
    static final short DOT = 18;
    static final short CROSS = 19;
    static final short ASSIGN = 20;
    static final short VLIST = 21;
    static final short MLIST = 22;
    static final short FUN = 23;
    static final short UMINUS = 24;
    static final short FUN2 = 25;
    static final short FUN3 = 26;
    static final short FUN4 = 27;
    static final short POWN = 28;
    static final short RECIP = 29;
    private static final short SCALER = 0;
    private static final short V2 = 2;
    private static final short V3 = 3;
    private static final short V4 = 4;
    private static final short Vn = 5;
    private static final short M22 = 6;
    private static final short M23 = 7;
    private static final short M24 = 8;
    private static final short M32 = 9;
    private static final short M33 = 10;
    private static final short M34 = 11;
    private static final short M42 = 12;
    private static final short M43 = 13;
    private static final short M44 = 14;
    private static final short Mnn = 15;
    private static final short Dtens = 16;
    private static final short SIN = 1;
    private static final short COS = 2;
    private static final short TAN = 3;
    private static final short ASIN = 4;
    private static final short ACOS = 5;
    private static final short ATAN = 6;
    private static final short SINH = 7;
    private static final short COSH = 8;
    private static final short TANH = 9;
    private static final short ASINH = 10;
    private static final short ACOSH = 11;
    private static final short ATANH = 12;
    private static final short ABS = 13;
    private static final short EXP = 14;
    private static final short LOG = 15;
    private static final short LN = 16;
    private static final short SQRT = 17;
    private static final short SEC = 18;
    private static final short COSEC = 19;
    private static final short COT = 20;
    private static final short ATAN2 = 21;
    private static final short IF = 22;
    private static final Hashtable functionHash = new Hashtable();
    private double[] constVals;
    private ScalerObj scalerRes;
    ScalerStore scalerStore;
    private V2Store v2Store;
    private V3Store v3Store;
    private V4Store v4Store;
    private VnStore vnStore;
    private M22Store m22Store;
    private M23Store m23Store;
    private M24Store m24Store;
    private M32Store m32Store;
    private M33Store m33Store;
    private M34Store m34Store;
    private M42Store m42Store;
    private M43Store m43Store;
    private M44Store m44Store;
    private MnnStore mnnStore;
    private MRpCommandList curCommandList;
    private static double LOG10 = Math.log(10.0);

    public MRpEval(MatrixJep mjep) {
        functionHash.put("sin", new Short(1));
        functionHash.put("cos", new Short(2));
        functionHash.put("tan", new Short(3));
        functionHash.put("asin", new Short(4));
        functionHash.put("acos", new Short(5));
        functionHash.put("atan", new Short(6));
        functionHash.put("sinh", new Short(7));
        functionHash.put("cosh", new Short(8));
        functionHash.put("tanh", new Short(9));
        functionHash.put("asinh", new Short(10));
        functionHash.put("acosh", new Short(11));
        functionHash.put("atanh", new Short(12));
        functionHash.put("abs", new Short(13));
        functionHash.put("exp", new Short(14));
        functionHash.put("log", new Short(15));
        functionHash.put("ln", new Short(16));
        functionHash.put("sqrt", new Short(17));
        functionHash.put("sec", new Short(18));
        functionHash.put("cosec", new Short(19));
        functionHash.put("cot", new Short(20));
        functionHash.put("atan2", new Short(21));
        functionHash.put("if", new Short(22));
        this.constVals = new double[0];
        this.scalerRes = new ScalerObj(0.0);
        this.scalerStore = new ScalerStore(this);
        this.v2Store = new V2Store(this);
        this.v3Store = new V3Store(this);
        this.v4Store = new V4Store(this);
        this.vnStore = new VnStore(this);
        this.m22Store = new M22Store(this);
        this.m23Store = new M23Store(this);
        this.m24Store = new M24Store(this);
        this.m32Store = new M32Store(this);
        this.m33Store = new M33Store(this);
        this.m34Store = new M34Store(this);
        this.m42Store = new M42Store(this);
        this.m43Store = new M43Store(this);
        this.m44Store = new M44Store(this);
        this.mnnStore = new MnnStore(this);
        this.opSet = (MatrixOperatorSet)mjep.getOperatorSet();
    }

    private MRpEval() {
        functionHash.put("sin", new Short(1));
        functionHash.put("cos", new Short(2));
        functionHash.put("tan", new Short(3));
        functionHash.put("asin", new Short(4));
        functionHash.put("acos", new Short(5));
        functionHash.put("atan", new Short(6));
        functionHash.put("sinh", new Short(7));
        functionHash.put("cosh", new Short(8));
        functionHash.put("tanh", new Short(9));
        functionHash.put("asinh", new Short(10));
        functionHash.put("acosh", new Short(11));
        functionHash.put("atanh", new Short(12));
        functionHash.put("abs", new Short(13));
        functionHash.put("exp", new Short(14));
        functionHash.put("log", new Short(15));
        functionHash.put("ln", new Short(16));
        functionHash.put("sqrt", new Short(17));
        functionHash.put("sec", new Short(18));
        functionHash.put("cosec", new Short(19));
        functionHash.put("cot", new Short(20));
        functionHash.put("atan2", new Short(21));
        functionHash.put("if", new Short(22));
        this.constVals = new double[0];
        this.scalerRes = new ScalerObj(0.0);
        this.scalerStore = new ScalerStore(this);
        this.v2Store = new V2Store(this);
        this.v3Store = new V3Store(this);
        this.v4Store = new V4Store(this);
        this.vnStore = new VnStore(this);
        this.m22Store = new M22Store(this);
        this.m23Store = new M23Store(this);
        this.m24Store = new M24Store(this);
        this.m32Store = new M32Store(this);
        this.m33Store = new M33Store(this);
        this.m34Store = new M34Store(this);
        this.m42Store = new M42Store(this);
        this.m43Store = new M43Store(this);
        this.m44Store = new M44Store(this);
        this.mnnStore = new MnnStore(this);
    }

    public final MRpCommandList compile(MatrixVariableI var, Node node) throws ParseException {
        MRpCommandList list = this.compile(node);
        ObjStore store = this.getStoreByDim(var.getDimensions());
        short vRef = (short)store.addVar(var);
        store.decStack();
        list.addCommand((short)20, MRpEval.getDimType((Dimensions)var.getDimensions()), vRef);
        return list;
    }

    public final MRpCommandList compile(Node node) throws ParseException {
        this.curCommandList = new MRpCommandList();
        node.jjtAccept((ParserVisitor)this, null);
        this.scalerStore.alloc();
        this.v2Store.alloc();
        this.v3Store.alloc();
        this.v4Store.alloc();
        this.vnStore.alloc();
        this.m22Store.alloc();
        this.m23Store.alloc();
        this.m24Store.alloc();
        this.m32Store.alloc();
        this.m33Store.alloc();
        this.m34Store.alloc();
        this.m42Store.alloc();
        this.m43Store.alloc();
        this.m44Store.alloc();
        this.mnnStore.alloc();
        Dimensions dims = ((MatrixNodeI)node).getDim();
        this.curCommandList.setResultDim(dims);
        return this.curCommandList;
    }

    public int getVarRef(Variable var) throws ParseException {
        Dimensions dims = ((MatrixVariableI)var).getDimensions();
        ObjStore store = this.getStoreByDim(dims);
        int ref = store.addVar((MatrixVariableI)var);
        return ref;
    }

    public int getVarRef(MatrixVariableI var) throws ParseException {
        Dimensions dims = var.getDimensions();
        ObjStore store = this.getStoreByDim(dims);
        int ref = store.addVar(var);
        return ref;
    }

    public final void setVarValue(int ref, MatrixValueI val) throws ParseException {
        ObjStore store = this.getStoreByDim(val.getDim());
        store.setVarValue(ref, val);
    }

    public final void setVarValue(int ref, double val) {
        this.scalerStore.setVarValue(ref, val);
    }

    static final Dimensions dimTypeToDimension(int dt) {
        switch (dt) {
            case 0: {
                return Dimensions.ONE;
            }
            case 2: {
                return Dimensions.TWO;
            }
            case 3: {
                return Dimensions.THREE;
            }
            case 4: {
                return Dimensions.valueOf((int)4);
            }
            case 6: {
                return Dimensions.valueOf((int)2, (int)2);
            }
            case 7: {
                return Dimensions.valueOf((int)2, (int)3);
            }
            case 8: {
                return Dimensions.valueOf((int)2, (int)4);
            }
            case 9: {
                return Dimensions.valueOf((int)3, (int)2);
            }
            case 10: {
                return Dimensions.valueOf((int)3, (int)3);
            }
            case 11: {
                return Dimensions.valueOf((int)3, (int)4);
            }
            case 12: {
                return Dimensions.valueOf((int)4, (int)2);
            }
            case 13: {
                return Dimensions.valueOf((int)4, (int)3);
            }
            case 14: {
                return Dimensions.valueOf((int)4, (int)4);
            }
        }
        return null;
    }

    static final short getDimType(Dimensions dims) {
        if (dims.is0D()) {
            return 0;
        }
        if (dims.is1D()) {
            switch (dims.getFirstDim()) {
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
            return 5;
        }
        if (dims.is2D()) {
            switch (dims.getFirstDim()) {
                case 2: {
                    switch (dims.getLastDim()) {
                        case 2: {
                            return 6;
                        }
                        case 3: {
                            return 7;
                        }
                        case 4: {
                            return 8;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (dims.getLastDim()) {
                        case 2: {
                            return 9;
                        }
                        case 3: {
                            return 10;
                        }
                        case 4: {
                            return 11;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (dims.getLastDim()) {
                        case 2: {
                            return 12;
                        }
                        case 3: {
                            return 13;
                        }
                        case 4: {
                            return 14;
                        }
                    }
                }
            }
            return 15;
        }
        return 16;
    }

    private final ObjStore getStoreByDim(Dimensions dims) throws ParseException {
        switch (MRpEval.getDimType((Dimensions)dims)) {
            case 0: {
                return this.scalerStore;
            }
            case 2: {
                return this.v2Store;
            }
            case 3: {
                return this.v3Store;
            }
            case 4: {
                return this.v4Store;
            }
            case 5: {
                return this.vnStore;
            }
            case 6: {
                return this.m22Store;
            }
            case 7: {
                return this.m23Store;
            }
            case 8: {
                return this.m24Store;
            }
            case 9: {
                return this.m32Store;
            }
            case 10: {
                return this.m33Store;
            }
            case 11: {
                return this.m34Store;
            }
            case 12: {
                return this.m42Store;
            }
            case 13: {
                return this.m43Store;
            }
            case 14: {
                return this.m44Store;
            }
            case 15: {
                return this.mnnStore;
            }
        }
        throw new ParseException("Sorry, can only handle scaler, 2, 3 and 4 dimensional vectors and matrices");
    }

    private final void incByDim(Dimensions dims) throws ParseException {
        this.getStoreByDim(dims).incStack();
    }

    private final void decByDim(Dimensions dims) throws ParseException {
        this.getStoreByDim(dims).decStack();
    }

    private final void incheapByDim(Dimensions dims) throws ParseException {
        this.getStoreByDim(dims).incHeap();
    }

    public final Object visit(ASTStart node, Object data) throws ParseException {
        throw new ParseException("RpeEval: Start node encountered");
    }

    public final Object visit(SimpleNode node, Object data) throws ParseException {
        throw new ParseException("RpeEval: Simple node encountered");
    }

    final void addConstant(Object obj) throws ParseException {
        if (!(obj instanceof Number)) {
            throw new ParseException("RpeEval: only constants of double type allowed");
        }
        double val = ((Number)obj).doubleValue();
        this.scalerStore.incStack();
        short i = 0;
        while (i < this.constVals.length) {
            if (val == this.constVals[i]) {
                this.curCommandList.addCommand((short)0, i);
                return;
            }
            i = (short)(i + 1);
        }
        double[] newConst = new double[this.constVals.length + 1];
        System.arraycopy(this.constVals, 0, newConst, 0, this.constVals.length);
        newConst[this.constVals.length] = val;
        this.curCommandList.addCommand((short)0, (short)this.constVals.length);
        this.constVals = newConst;
    }

    public final Object visit(ASTConstant node, Object data) throws ParseException {
        this.addConstant(node.getValue());
        return null;
    }

    public final Object visit(ASTVarNode node, Object data) throws ParseException {
        MatrixVariableI var = (MatrixVariableI)node.getVar();
        if (var.isConstant()) {
            this.addConstant((Object)var.getMValue());
            return null;
        }
        Dimensions dims = var.getDimensions();
        ObjStore store = this.getStoreByDim(dims);
        short vRef = (short)store.addVar(var);
        store.incStack();
        this.curCommandList.addCommand((short)1, MRpEval.getDimType((Dimensions)dims), vRef);
        return null;
    }

    public final Object visit(ASTFunNode node, Object data) throws ParseException {
        ASTMFunNode mnode = (ASTMFunNode)node;
        MatrixNodeI leftnode = null;
        MatrixNodeI rightnode = null;
        int nChild = mnode.jjtGetNumChildren();
        Dimensions dims = mnode.getDim();
        Dimensions ldims = null;
        Dimensions rdims = null;
        if (!(node.isOperator() && node.getOperator() == this.opSet.getAssign() || node.isOperator() && node.getOperator() == this.opSet.getPower())) {
            node.childrenAccept((ParserVisitor)this, null);
        }
        if (nChild >= 1) {
            leftnode = (MatrixNodeI)node.jjtGetChild(0);
            ldims = leftnode.getDim();
        }
        if (nChild >= 2) {
            rightnode = (MatrixNodeI)node.jjtGetChild(1);
            rdims = rightnode.getDim();
        }
        if (mnode.isOperator()) {
            XOperator op = (XOperator)mnode.getOperator();
            if (op.isBinary() && nChild != 2) {
                throw new ParseException("RpeEval: binary operator must have two children, but it has " + nChild);
            }
            if (op.isUnary() && nChild != 1) {
                throw new ParseException("RpeEval: unary operator must have one child, but it has " + nChild);
            }
            if (op == this.opSet.getAdd()) {
                if (!dims.equals(ldims) || !dims.equals(rdims)) {
                    throw new ParseException("RpeEval: dims for add must be equal");
                }
                this.curCommandList.addCommand((short)2, MRpEval.getDimType((Dimensions)dims));
                this.decByDim(dims);
                this.incheapByDim(dims);
                return null;
            }
            if (op == this.opSet.getSubtract()) {
                if (!dims.equals(ldims) || !dims.equals(rdims)) {
                    throw new ParseException("RpeEval: dims for add must be equal");
                }
                this.curCommandList.addCommand((short)3, MRpEval.getDimType((Dimensions)dims));
                this.decByDim(dims);
                this.incheapByDim(dims);
                return null;
            }
            if (op == this.opSet.getUMinus()) {
                this.curCommandList.addCommand((short)24, MRpEval.getDimType((Dimensions)dims));
                this.incheapByDim(dims);
                return null;
            }
            if (op == this.opSet.getMultiply()) {
                this.decByDim(rdims);
                this.decByDim(ldims);
                this.incByDim(dims);
                this.incheapByDim(dims);
                this.curCommandList.addCommand((short)4, MRpEval.getDimType((Dimensions)ldims), MRpEval.getDimType((Dimensions)rdims));
                return null;
            }
            if (op == this.opSet.getMList()) {
                this.incByDim(dims);
                this.incheapByDim(dims);
                int j = 0;
                while (j < dims.numEles()) {
                    this.scalerStore.decStack();
                    ++j;
                }
                short d = MRpEval.getDimType((Dimensions)dims);
                if (d == 5) {
                    this.curCommandList.addCommand((short)21, (short)dims.getFirstDim());
                } else if (d == 15) {
                    this.curCommandList.addCommand((short)22, (short)dims.getFirstDim(), (short)dims.getLastDim());
                } else {
                    this.curCommandList.addCommand((short)17, MRpEval.getDimType((Dimensions)dims));
                }
                return null;
            }
            if (op == this.opSet.getDot()) {
                this.scalerStore.incStack();
                this.decByDim(rdims);
                this.decByDim(ldims);
                this.curCommandList.addCommand((short)18, MRpEval.getDimType((Dimensions)ldims));
                return null;
            }
            if (op == this.opSet.getCross()) {
                if (ldims.equals(Dimensions.THREE) && rdims.equals(Dimensions.THREE)) {
                    this.v3Store.decStack();
                    this.v3Store.incHeap();
                    this.curCommandList.addCommand((short)19, (short)3);
                    return null;
                }
                if (ldims.equals(Dimensions.TWO) && rdims.equals(Dimensions.TWO)) {
                    this.scalerStore.incStack();
                    this.decByDim(ldims);
                    this.decByDim(rdims);
                    this.curCommandList.addCommand((short)19, (short)2);
                    return null;
                }
                throw new ParseException("Bad dimensions for cross product " + ldims + " " + rdims);
            }
            if (op == this.opSet.getAssign()) {
                rightnode.jjtAccept((ParserVisitor)this, null);
                MatrixVariableI var = (MatrixVariableI)((ASTMVarNode)node.jjtGetChild(0)).getVar();
                ObjStore store = this.getStoreByDim(dims);
                short vRef = (short)store.addVar(var);
                store.decStack();
                this.curCommandList.addCommand((short)20, MRpEval.getDimType((Dimensions)dims), vRef);
                return null;
            }
            if (op == this.opSet.getEQ()) {
                if (!ldims.equals(rdims)) {
                    throw new ParseException("Dimensions of operands for equals operator must be the same");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)16, MRpEval.getDimType((Dimensions)ldims));
                return null;
            }
            if (op == this.opSet.getNE()) {
                if (!ldims.equals(rdims)) {
                    throw new ParseException("Dimensions of operands for not-equals operator must be the same");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)15, MRpEval.getDimType((Dimensions)ldims));
                return null;
            }
            if (op == this.opSet.getLT()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for < operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)11, (short)0);
                return null;
            }
            if (op == this.opSet.getGT()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for > operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)13, (short)0);
                return null;
            }
            if (op == this.opSet.getLE()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for <= operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)12, (short)0);
                return null;
            }
            if (op == this.opSet.getGE()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for >= operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)14, (short)0);
                return null;
            }
            if (op == this.opSet.getAnd()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for && operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)8, (short)0);
                return null;
            }
            if (op == this.opSet.getOr()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for || operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)9, (short)0);
                return null;
            }
            if (op == this.opSet.getNot()) {
                if (!ldims.is0D()) {
                    throw new ParseException("Dimension of operand for not operator must be one");
                }
                this.scalerStore.incStack();
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)10, (short)0);
                return null;
            }
            if (op == this.opSet.getDivide()) {
                if (!rdims.is0D()) {
                    throw new ParseException("RHS operands of / operator must be a Scaler");
                }
                this.decByDim(rdims);
                this.decByDim(ldims);
                this.incByDim(dims);
                this.incheapByDim(dims);
                this.curCommandList.addCommand((short)5, MRpEval.getDimType((Dimensions)ldims), MRpEval.getDimType((Dimensions)rdims));
                return null;
            }
            if (op == this.opSet.getMod()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for || operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)6, (short)0);
                return null;
            }
            if (op == this.opSet.getPower()) {
                Object val;
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for || operator must both be one");
                }
                Node lhs = node.jjtGetChild(0);
                Node rhs = node.jjtGetChild(1);
                lhs.jjtAccept((ParserVisitor)this, null);
                if (rhs instanceof ASTConstant && (val = ((ASTConstant)rhs).getValue()) instanceof Number) {
                    double dval = ((Number)val).doubleValue();
                    short sval = ((Number)val).shortValue();
                    if (dval >= 0.0 && dval == (double)sval) {
                        this.curCommandList.addCommand((short)28, sval);
                        return null;
                    }
                    if (dval == (double)sval) {
                        this.curCommandList.addCommand((short)28, -sval);
                        this.curCommandList.addCommand((short)29, (short)0);
                    }
                }
                rhs.jjtAccept((ParserVisitor)this, null);
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)7, (short)0);
                return null;
            }
            throw new ParseException("RpeEval: Sorry unsupported operator/function: " + mnode.getName());
        }
        Short val = (Short)functionHash.get(mnode.getName());
        if (val == null) {
            throw new ParseException("RpeEval: Sorry unsupported operator/function: " + mnode.getName());
        }
        if (mnode.getPFMC().getNumberOfParameters() == 1 && nChild == 1) {
            this.scalerStore.incStack();
            this.decByDim(ldims);
            this.curCommandList.addCommand((short)23, val.shortValue());
            return null;
        }
        if (nChild == 1) {
            this.scalerStore.incStack();
            this.decByDim(ldims);
            this.curCommandList.addCommand((short)23, val.shortValue());
            return null;
        }
        if (nChild == 2) {
            this.scalerStore.incStack();
            this.decByDim(ldims);
            this.decByDim(rdims);
            this.curCommandList.addCommand((short)25, val.shortValue());
            return null;
        }
        if (nChild == 3) {
            this.scalerStore.incStack();
            this.decByDim(ldims);
            this.decByDim(ldims);
            this.decByDim(ldims);
            this.curCommandList.addCommand((short)26, val.shortValue());
            return null;
        }
        if (nChild == 4) {
            this.scalerStore.incStack();
            this.decByDim(ldims);
            this.decByDim(ldims);
            this.decByDim(ldims);
            this.decByDim(ldims);
            this.curCommandList.addCommand((short)27, val.shortValue());
            return null;
        }
        throw new ParseException("RpeEval: Sorry unsupported operator/function: " + mnode.getName());
    }

    public final MRpRes evaluate(MRpCommandList comList) {
        this.scalerStore.reset();
        this.v2Store.reset();
        this.v3Store.reset();
        this.v4Store.reset();
        this.vnStore.reset();
        this.m22Store.reset();
        this.m23Store.reset();
        this.m24Store.reset();
        this.m32Store.reset();
        this.m33Store.reset();
        this.m34Store.reset();
        this.m42Store.reset();
        this.m43Store.reset();
        this.m44Store.reset();
        this.mnnStore.reset();
        int num = comList.getNumCommands();
        int commandNum = 0;
        while (commandNum < num) {
            MRpCommandList.MRpCommand command = comList.commands[commandNum];
            short aux1 = command.aux1;
            short aux2 = command.aux2;
            switch (command.command) {
                case 0: {
                    this.scalerStore.stack[this.scalerStore.sp++] = this.constVals[aux1];
                    break;
                }
                case 1: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.stack[this.scalerStore.sp++] = this.scalerStore.vars[aux2];
                            break;
                        }
                        case 2: {
                            this.v2Store.stack[this.v2Store.sp++] = this.v2Store.vars[aux2];
                            break;
                        }
                        case 3: {
                            this.v3Store.stack[this.v3Store.sp++] = this.v3Store.vars[aux2];
                            break;
                        }
                        case 4: {
                            this.v4Store.stack[this.v4Store.sp++] = this.v4Store.vars[aux2];
                            break;
                        }
                        case 5: {
                            this.vnStore.stack[this.vnStore.sp++] = this.vnStore.vars[aux2];
                            break;
                        }
                        case 6: {
                            this.m22Store.stack[this.m22Store.sp++] = this.m22Store.vars[aux2];
                            break;
                        }
                        case 7: {
                            this.m23Store.stack[this.m23Store.sp++] = this.m23Store.vars[aux2];
                            break;
                        }
                        case 8: {
                            this.m24Store.stack[this.m24Store.sp++] = this.m24Store.vars[aux2];
                            break;
                        }
                        case 9: {
                            this.m32Store.stack[this.m32Store.sp++] = this.m32Store.vars[aux2];
                            break;
                        }
                        case 10: {
                            this.m33Store.stack[this.m33Store.sp++] = this.m33Store.vars[aux2];
                            break;
                        }
                        case 11: {
                            this.m34Store.stack[this.m34Store.sp++] = this.m34Store.vars[aux2];
                            break;
                        }
                        case 12: {
                            this.m42Store.stack[this.m42Store.sp++] = this.m42Store.vars[aux2];
                            break;
                        }
                        case 13: {
                            this.m43Store.stack[this.m43Store.sp++] = this.m43Store.vars[aux2];
                            break;
                        }
                        case 14: {
                            this.m44Store.stack[this.m44Store.sp++] = this.m44Store.vars[aux2];
                            break;
                        }
                        case 15: {
                            this.mnnStore.stack[this.mnnStore.sp++] = this.mnnStore.vars[aux2];
                        }
                    }
                    break;
                }
                case 2: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.add();
                            break;
                        }
                        case 2: {
                            this.v2Store.add();
                            break;
                        }
                        case 3: {
                            this.v3Store.add();
                            break;
                        }
                        case 4: {
                            this.v4Store.add();
                            break;
                        }
                        case 5: {
                            this.vnStore.add();
                            break;
                        }
                        case 6: {
                            this.m22Store.add();
                            break;
                        }
                        case 7: {
                            this.m23Store.add();
                            break;
                        }
                        case 8: {
                            this.m24Store.add();
                            break;
                        }
                        case 9: {
                            this.m32Store.add();
                            break;
                        }
                        case 10: {
                            this.m33Store.add();
                            break;
                        }
                        case 11: {
                            this.m34Store.add();
                            break;
                        }
                        case 12: {
                            this.m42Store.add();
                            break;
                        }
                        case 13: {
                            this.m43Store.add();
                            break;
                        }
                        case 14: {
                            this.m44Store.add();
                            break;
                        }
                        case 15: {
                            this.mnnStore.add();
                        }
                    }
                    break;
                }
                case 3: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.sub();
                            break;
                        }
                        case 2: {
                            this.v2Store.sub();
                            break;
                        }
                        case 3: {
                            this.v3Store.sub();
                            break;
                        }
                        case 4: {
                            this.v4Store.sub();
                            break;
                        }
                        case 5: {
                            this.vnStore.sub();
                            break;
                        }
                        case 6: {
                            this.m22Store.sub();
                            break;
                        }
                        case 7: {
                            this.m23Store.sub();
                            break;
                        }
                        case 8: {
                            this.m24Store.sub();
                            break;
                        }
                        case 9: {
                            this.m32Store.sub();
                            break;
                        }
                        case 10: {
                            this.m33Store.sub();
                            break;
                        }
                        case 11: {
                            this.m34Store.sub();
                            break;
                        }
                        case 12: {
                            this.m42Store.sub();
                            break;
                        }
                        case 13: {
                            this.m43Store.sub();
                            break;
                        }
                        case 14: {
                            this.m44Store.sub();
                            break;
                        }
                        case 15: {
                            this.mnnStore.sub();
                        }
                    }
                    break;
                }
                case 4: {
                    block83 : switch (aux1) {
                        case 0: {
                            switch (aux2) {
                                case 0: {
                                    this.scalerStore.mulS();
                                    break;
                                }
                                case 2: {
                                    this.v2Store.mulS();
                                    break;
                                }
                                case 3: {
                                    this.v3Store.mulS();
                                    break;
                                }
                                case 4: {
                                    this.v4Store.mulS();
                                    break;
                                }
                                case 5: {
                                    this.vnStore.mulS();
                                    break;
                                }
                                case 6: {
                                    this.m22Store.mulS();
                                    break;
                                }
                                case 7: {
                                    this.m23Store.mulS();
                                    break;
                                }
                                case 8: {
                                    this.m24Store.mulS();
                                    break;
                                }
                                case 9: {
                                    this.m32Store.mulS();
                                    break;
                                }
                                case 10: {
                                    this.m33Store.mulS();
                                    break;
                                }
                                case 11: {
                                    this.m34Store.mulS();
                                    break;
                                }
                                case 12: {
                                    this.m42Store.mulS();
                                    break;
                                }
                                case 13: {
                                    this.m43Store.mulS();
                                    break;
                                }
                                case 14: {
                                    this.m44Store.mulS();
                                    break;
                                }
                                case 15: {
                                    this.mnnStore.mulS();
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (aux2) {
                                case 0: {
                                    this.v2Store.mulS();
                                    break;
                                }
                                case 2: {
                                    this.mulV2V2();
                                    break;
                                }
                                case 6: {
                                    this.mulV2M22();
                                    break;
                                }
                                case 7: {
                                    this.mulV2M23();
                                    break;
                                }
                                case 8: {
                                    this.mulV2M24();
                                    break;
                                }
                                case 15: {
                                    this.mulVnMnn((VecObj)this.v2Store.stack[--this.v2Store.sp], (MatObj)this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (aux2) {
                                case 0: {
                                    this.v3Store.mulS();
                                    break;
                                }
                                case 3: {
                                    this.mulV3V3();
                                    break;
                                }
                                case 9: {
                                    this.mulV3M32();
                                    break;
                                }
                                case 10: {
                                    this.mulV3M33();
                                    break;
                                }
                                case 11: {
                                    this.mulV3M34();
                                    break;
                                }
                                case 15: {
                                    this.mulVnMnn((VecObj)this.v3Store.stack[--this.v3Store.sp], (MatObj)this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 4: {
                            switch (aux2) {
                                case 0: {
                                    this.v4Store.mulS();
                                    break;
                                }
                                case 4: {
                                    this.mulV4V4();
                                    break;
                                }
                                case 12: {
                                    this.mulV4M42();
                                    break;
                                }
                                case 13: {
                                    this.mulV4M43();
                                    break;
                                }
                                case 14: {
                                    this.mulV4M44();
                                    break;
                                }
                                case 15: {
                                    this.mulVnMnn((VecObj)this.v4Store.stack[--this.v4Store.sp], (MatObj)this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 5: {
                            VnObj l;
                            VnObj r;
                            switch (aux2) {
                                case 0: {
                                    this.mnnStore.mulS();
                                    break;
                                }
                                case 5: {
                                    r = this.vnStore.stack[--this.vnStore.sp];
                                    l = this.vnStore.stack[--this.vnStore.sp];
                                    this.mulVnVn((VecObj)l, (VecObj)r);
                                    break;
                                }
                                case 15: {
                                    this.mulVnMnn((VecObj)this.vnStore.stack[--this.vnStore.sp], (MatObj)this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 6: {
                            switch (aux2) {
                                case 0: {
                                    this.m22Store.mulS();
                                    break;
                                }
                                case 2: {
                                    this.mulM22V2();
                                    break;
                                }
                                case 6: {
                                    this.mulM22M22();
                                    break;
                                }
                                case 7: {
                                    this.mulM22M23();
                                    break;
                                }
                                case 8: {
                                    this.mulM22M24();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn((MatObj)this.m22Store.stack[--this.m22Store.sp], (MatObj)this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 7: {
                            switch (aux2) {
                                case 0: {
                                    this.m23Store.mulS();
                                    break;
                                }
                                case 3: {
                                    this.mulM23V3();
                                    break;
                                }
                                case 9: {
                                    this.mulM23M32();
                                    break;
                                }
                                case 10: {
                                    this.mulM23M33();
                                    break;
                                }
                                case 11: {
                                    this.mulM23M34();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn((MatObj)this.m23Store.stack[--this.m23Store.sp], (MatObj)this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 8: {
                            switch (aux2) {
                                case 0: {
                                    this.m24Store.mulS();
                                    break;
                                }
                                case 4: {
                                    this.mulM24V4();
                                    break;
                                }
                                case 12: {
                                    this.mulM24M42();
                                    break;
                                }
                                case 13: {
                                    this.mulM24M43();
                                    break;
                                }
                                case 14: {
                                    this.mulM24M44();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn((MatObj)this.m24Store.stack[--this.m24Store.sp], (MatObj)this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 9: {
                            switch (aux2) {
                                case 0: {
                                    this.m32Store.mulS();
                                    break;
                                }
                                case 2: {
                                    this.mulM32V2();
                                    break;
                                }
                                case 6: {
                                    this.mulM32M22();
                                    break;
                                }
                                case 7: {
                                    this.mulM32M23();
                                    break;
                                }
                                case 8: {
                                    this.mulM32M24();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn((MatObj)this.m32Store.stack[--this.m32Store.sp], (MatObj)this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 10: {
                            switch (aux2) {
                                case 0: {
                                    this.m33Store.mulS();
                                    break;
                                }
                                case 3: {
                                    this.mulM33V3();
                                    break;
                                }
                                case 9: {
                                    this.mulM33M32();
                                    break;
                                }
                                case 10: {
                                    this.mulM33M33();
                                    break;
                                }
                                case 11: {
                                    this.mulM33M34();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn((MatObj)this.m33Store.stack[--this.m33Store.sp], (MatObj)this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 11: {
                            switch (aux2) {
                                case 0: {
                                    this.m34Store.mulS();
                                    break;
                                }
                                case 4: {
                                    this.mulM34V4();
                                    break;
                                }
                                case 12: {
                                    this.mulM34M42();
                                    break;
                                }
                                case 13: {
                                    this.mulM34M43();
                                    break;
                                }
                                case 14: {
                                    this.mulM34M44();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn((MatObj)this.m34Store.stack[--this.m34Store.sp], (MatObj)this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 12: {
                            switch (aux2) {
                                case 0: {
                                    this.m42Store.mulS();
                                    break;
                                }
                                case 2: {
                                    this.mulM42V2();
                                    break;
                                }
                                case 6: {
                                    this.mulM42M22();
                                    break;
                                }
                                case 7: {
                                    this.mulM42M23();
                                    break;
                                }
                                case 8: {
                                    this.mulM42M24();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn((MatObj)this.m42Store.stack[--this.m42Store.sp], (MatObj)this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 13: {
                            switch (aux2) {
                                case 0: {
                                    this.m43Store.mulS();
                                    break;
                                }
                                case 3: {
                                    this.mulM43V3();
                                    break;
                                }
                                case 9: {
                                    this.mulM43M32();
                                    break;
                                }
                                case 10: {
                                    this.mulM43M33();
                                    break;
                                }
                                case 11: {
                                    this.mulM43M34();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn((MatObj)this.m43Store.stack[--this.m43Store.sp], (MatObj)this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 14: {
                            switch (aux2) {
                                case 0: {
                                    this.m44Store.mulS();
                                    break;
                                }
                                case 4: {
                                    this.mulM44V4();
                                    break;
                                }
                                case 12: {
                                    this.mulM44M42();
                                    break;
                                }
                                case 13: {
                                    this.mulM44M43();
                                    break;
                                }
                                case 14: {
                                    this.mulM44M44();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn((MatObj)this.m44Store.stack[--this.m44Store.sp], (MatObj)this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 15: {
                            VnObj l;
                            VnObj r;
                            switch (aux2) {
                                case 0: {
                                    this.mnnStore.mulS();
                                    break block83;
                                }
                                case 2: {
                                    this.mulMnnVn((MatObj)this.mnnStore.stack[--this.mnnStore.sp], (VecObj)this.v2Store.stack[--this.v2Store.sp]);
                                    break block83;
                                }
                                case 3: {
                                    this.mulMnnVn((MatObj)this.mnnStore.stack[--this.mnnStore.sp], (VecObj)this.v3Store.stack[--this.v3Store.sp]);
                                    break block83;
                                }
                                case 4: {
                                    this.mulMnnVn((MatObj)this.mnnStore.stack[--this.mnnStore.sp], (VecObj)this.v4Store.stack[--this.v4Store.sp]);
                                    break block83;
                                }
                                case 5: {
                                    this.mulMnnVn((MatObj)this.mnnStore.stack[--this.mnnStore.sp], (VecObj)this.vnStore.stack[--this.vnStore.sp]);
                                    break block83;
                                }
                                case 6: {
                                    this.mulMnnMnn((MatObj)this.mnnStore.stack[--this.mnnStore.sp], (MatObj)this.m22Store.stack[--this.m22Store.sp]);
                                    break block83;
                                }
                                case 7: {
                                    this.mulMnnMnn((MatObj)this.mnnStore.stack[--this.mnnStore.sp], (MatObj)this.m23Store.stack[--this.m23Store.sp]);
                                    break block83;
                                }
                                case 8: {
                                    this.mulMnnMnn((MatObj)this.mnnStore.stack[--this.mnnStore.sp], (MatObj)this.m24Store.stack[--this.m24Store.sp]);
                                    break block83;
                                }
                                case 9: {
                                    this.mulMnnMnn((MatObj)this.mnnStore.stack[--this.mnnStore.sp], (MatObj)this.m32Store.stack[--this.m32Store.sp]);
                                    break block83;
                                }
                                case 10: {
                                    this.mulMnnMnn((MatObj)this.mnnStore.stack[--this.mnnStore.sp], (MatObj)this.m33Store.stack[--this.m33Store.sp]);
                                    break block83;
                                }
                                case 11: {
                                    this.mulMnnMnn((MatObj)this.mnnStore.stack[--this.mnnStore.sp], (MatObj)this.m34Store.stack[--this.m34Store.sp]);
                                    break block83;
                                }
                                case 12: {
                                    this.mulMnnMnn((MatObj)this.mnnStore.stack[--this.mnnStore.sp], (MatObj)this.m42Store.stack[--this.m42Store.sp]);
                                    break block83;
                                }
                                case 13: {
                                    this.mulMnnMnn((MatObj)this.mnnStore.stack[--this.mnnStore.sp], (MatObj)this.m43Store.stack[--this.m43Store.sp]);
                                    break block83;
                                }
                                case 14: {
                                    this.mulMnnMnn((MatObj)this.mnnStore.stack[--this.mnnStore.sp], (MatObj)this.m44Store.stack[--this.m44Store.sp]);
                                    break block83;
                                }
                                case 15: {
                                    r = this.mnnStore.stack[--this.mnnStore.sp];
                                    l = this.mnnStore.stack[--this.mnnStore.sp];
                                    this.mulMnnMnn((MatObj)l, (MatObj)r);
                                }
                            }
                        }
                    }
                    break;
                }
                case 5: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.divS();
                            break;
                        }
                        case 2: {
                            this.v2Store.divS();
                            break;
                        }
                        case 3: {
                            this.v3Store.divS();
                            break;
                        }
                        case 4: {
                            this.v4Store.divS();
                            break;
                        }
                        case 5: {
                            this.vnStore.divS();
                            break;
                        }
                        case 6: {
                            this.m22Store.divS();
                            break;
                        }
                        case 7: {
                            this.m23Store.divS();
                            break;
                        }
                        case 8: {
                            this.m24Store.divS();
                            break;
                        }
                        case 9: {
                            this.m32Store.divS();
                            break;
                        }
                        case 10: {
                            this.m33Store.divS();
                            break;
                        }
                        case 11: {
                            this.m34Store.divS();
                            break;
                        }
                        case 12: {
                            this.m42Store.divS();
                            break;
                        }
                        case 13: {
                            this.m43Store.divS();
                            break;
                        }
                        case 14: {
                            this.m44Store.divS();
                            break;
                        }
                        case 15: {
                            this.mnnStore.divS();
                        }
                    }
                    break;
                }
                case 6: {
                    this.scalerStore.mod();
                    break;
                }
                case 7: {
                    this.scalerStore.pow();
                    break;
                }
                case 8: {
                    this.scalerStore.and();
                    break;
                }
                case 9: {
                    this.scalerStore.or();
                    break;
                }
                case 10: {
                    this.scalerStore.not();
                    break;
                }
                case 11: {
                    this.scalerStore.lt();
                    break;
                }
                case 12: {
                    this.scalerStore.le();
                    break;
                }
                case 13: {
                    this.scalerStore.gt();
                    break;
                }
                case 14: {
                    this.scalerStore.ge();
                    break;
                }
                case 15: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.neq();
                            break;
                        }
                        case 2: {
                            this.v2Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 3: {
                            this.v3Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 4: {
                            this.v4Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 6: {
                            this.m22Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 7: {
                            this.m23Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 8: {
                            this.m24Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 9: {
                            this.m32Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 10: {
                            this.m33Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 11: {
                            this.m34Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 12: {
                            this.m42Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 13: {
                            this.m43Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 14: {
                            this.m44Store.eq();
                            this.scalerStore.not();
                        }
                    }
                    break;
                }
                case 16: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.eq();
                            break;
                        }
                        case 2: {
                            this.v2Store.eq();
                            break;
                        }
                        case 3: {
                            this.v3Store.eq();
                            break;
                        }
                        case 4: {
                            this.v4Store.eq();
                            break;
                        }
                        case 6: {
                            this.m22Store.eq();
                            break;
                        }
                        case 7: {
                            this.m23Store.eq();
                            break;
                        }
                        case 8: {
                            this.m24Store.eq();
                            break;
                        }
                        case 9: {
                            this.m32Store.eq();
                            break;
                        }
                        case 10: {
                            this.m33Store.eq();
                            break;
                        }
                        case 11: {
                            this.m34Store.eq();
                            break;
                        }
                        case 12: {
                            this.m42Store.eq();
                            break;
                        }
                        case 13: {
                            this.m43Store.eq();
                            break;
                        }
                        case 14: {
                            this.m44Store.eq();
                        }
                    }
                    break;
                }
                case 20: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.assign((int)aux2);
                            break;
                        }
                        case 2: {
                            this.v2Store.assign((int)aux2);
                            break;
                        }
                        case 3: {
                            this.v3Store.assign((int)aux2);
                            break;
                        }
                        case 4: {
                            this.v4Store.assign((int)aux2);
                            break;
                        }
                        case 5: {
                            this.vnStore.assign((int)aux2);
                            break;
                        }
                        case 6: {
                            this.m22Store.assign((int)aux2);
                            break;
                        }
                        case 7: {
                            this.m23Store.assign((int)aux2);
                            break;
                        }
                        case 8: {
                            this.m24Store.assign((int)aux2);
                            break;
                        }
                        case 9: {
                            this.m32Store.assign((int)aux2);
                            break;
                        }
                        case 10: {
                            this.m33Store.assign((int)aux2);
                            break;
                        }
                        case 11: {
                            this.m34Store.assign((int)aux2);
                            break;
                        }
                        case 12: {
                            this.m42Store.assign((int)aux2);
                            break;
                        }
                        case 13: {
                            this.m43Store.assign((int)aux2);
                            break;
                        }
                        case 14: {
                            this.m44Store.assign((int)aux2);
                            break;
                        }
                        case 15: {
                            this.mnnStore.assign((int)aux2);
                        }
                    }
                    break;
                }
                case 17: {
                    switch (aux1) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            this.v2Store.makeList();
                            break;
                        }
                        case 3: {
                            this.v3Store.makeList();
                            break;
                        }
                        case 4: {
                            this.v4Store.makeList();
                            break;
                        }
                        case 6: {
                            this.m22Store.makeList();
                            break;
                        }
                        case 7: {
                            this.m23Store.makeList();
                            break;
                        }
                        case 8: {
                            this.m24Store.makeList();
                            break;
                        }
                        case 9: {
                            this.m32Store.makeList();
                            break;
                        }
                        case 10: {
                            this.m33Store.makeList();
                            break;
                        }
                        case 11: {
                            this.m34Store.makeList();
                            break;
                        }
                        case 12: {
                            this.m42Store.makeList();
                            break;
                        }
                        case 13: {
                            this.m43Store.makeList();
                            break;
                        }
                        case 14: {
                            this.m44Store.makeList();
                        }
                    }
                    break;
                }
                case 21: {
                    this.vnStore.makeList((int)aux1);
                    break;
                }
                case 22: {
                    this.mnnStore.makeList((int)aux1, (int)aux2);
                    break;
                }
                case 18: {
                    switch (aux1) {
                        case 2: {
                            this.dotV2();
                            break;
                        }
                        case 3: {
                            this.dotV3();
                            break;
                        }
                        case 4: {
                            this.dotV4();
                            break;
                        }
                        case 5: {
                            this.dotVn();
                        }
                    }
                    break;
                }
                case 19: {
                    switch (aux1) {
                        case 2: {
                            this.crossV2();
                            break;
                        }
                        case 3: {
                            this.crossV3();
                        }
                    }
                    break;
                }
                case 23: {
                    this.unitaryFunction(aux1);
                    break;
                }
                case 24: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.uminus();
                            break;
                        }
                        case 2: {
                            this.v2Store.uminus();
                            break;
                        }
                        case 3: {
                            this.v3Store.uminus();
                            break;
                        }
                        case 4: {
                            this.v4Store.uminus();
                            break;
                        }
                        case 5: {
                            this.vnStore.uminus();
                            break;
                        }
                        case 6: {
                            this.m22Store.uminus();
                            break;
                        }
                        case 7: {
                            this.m23Store.uminus();
                            break;
                        }
                        case 8: {
                            this.m24Store.uminus();
                            break;
                        }
                        case 9: {
                            this.m32Store.uminus();
                            break;
                        }
                        case 10: {
                            this.m33Store.uminus();
                            break;
                        }
                        case 11: {
                            this.m34Store.uminus();
                            break;
                        }
                        case 12: {
                            this.m42Store.uminus();
                            break;
                        }
                        case 13: {
                            this.m43Store.uminus();
                            break;
                        }
                        case 14: {
                            this.m44Store.uminus();
                            break;
                        }
                        case 15: {
                            this.mnnStore.uminus();
                        }
                    }
                    break;
                }
                case 25: {
                    this.binaryFunction(aux1);
                    break;
                }
                case 26: {
                    this.trianaryFunction(aux1);
                    break;
                }
                case 27: {
                    this.quarteraryFunction(aux1);
                    break;
                }
                case 28: {
                    this.scalerStore.powN(aux1);
                    break;
                }
                case 29: {
                    this.scalerStore.recroprical();
                }
            }
            commandNum = (short)(commandNum + 1);
        }
        switch (comList.getFinalType()) {
            case 0: {
                this.scalerRes.a = this.scalerStore.stack[--this.scalerStore.sp];
                return this.scalerRes;
            }
            case 2: {
                return this.v2Store.stack[--this.v2Store.sp];
            }
            case 3: {
                return this.v3Store.stack[--this.v3Store.sp];
            }
            case 4: {
                return this.v4Store.stack[--this.v4Store.sp];
            }
            case 5: {
                return this.vnStore.stack[--this.vnStore.sp];
            }
            case 6: {
                return this.m22Store.stack[--this.m22Store.sp];
            }
            case 7: {
                return this.m23Store.stack[--this.m23Store.sp];
            }
            case 8: {
                return this.m24Store.stack[--this.m24Store.sp];
            }
            case 9: {
                return this.m32Store.stack[--this.m32Store.sp];
            }
            case 10: {
                return this.m33Store.stack[--this.m33Store.sp];
            }
            case 11: {
                return this.m34Store.stack[--this.m34Store.sp];
            }
            case 12: {
                return this.m42Store.stack[--this.m42Store.sp];
            }
            case 13: {
                return this.m43Store.stack[--this.m43Store.sp];
            }
            case 14: {
                return this.m44Store.stack[--this.m44Store.sp];
            }
            case 15: {
                return this.mnnStore.stack[--this.mnnStore.sp];
            }
        }
        return null;
    }

    private final void dotV2() {
        V2Obj r = this.v2Store.stack[--this.v2Store.sp];
        V2Obj l = this.v2Store.stack[--this.v2Store.sp];
        this.scalerStore.stack[this.scalerStore.sp++] = l.a * r.a + l.b * r.b;
    }

    private final void crossV2() {
        V2Obj r = this.v2Store.stack[--this.v2Store.sp];
        V2Obj l = this.v2Store.stack[--this.v2Store.sp];
        this.scalerStore.stack[this.scalerStore.sp++] = l.a * r.b - l.b * r.a;
    }

    private final void dotV3() {
        V3Obj r = this.v3Store.stack[--this.v3Store.sp];
        V3Obj l = this.v3Store.stack[--this.v3Store.sp];
        this.scalerStore.stack[this.scalerStore.sp++] = l.a * r.a + l.b * r.b + l.c * r.c;
    }

    private final void crossV3() {
        V3Obj r = this.v3Store.stack[--this.v3Store.sp];
        V3Obj l = this.v3Store.stack[--this.v3Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.b * r.c - l.c * r.b;
        res.b = l.c * r.a - l.a * r.c;
        res.c = l.a * r.b - l.b * r.a;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void dotV4() {
        V4Obj r = this.v4Store.stack[--this.v4Store.sp];
        V4Obj l = this.v4Store.stack[--this.v4Store.sp];
        this.scalerStore.stack[this.scalerStore.sp++] = l.a * r.a + l.b * r.b + l.c * r.c + l.d * r.d;
    }

    private final void dotVn() {
        VnObj r = this.vnStore.stack[--this.vnStore.sp];
        VnObj l = this.vnStore.stack[--this.vnStore.sp];
        double res = l.data[0] * r.data[0];
        int i = 1;
        while (i < l.data.length) {
            res += l.data[i] * r.data[i];
            ++i;
        }
        this.scalerStore.stack[this.scalerStore.sp++] = res;
    }

    private final void mulV2V2() {
        V2Obj r = this.v2Store.stack[--this.v2Store.sp];
        V2Obj l = this.v2Store.stack[--this.v2Store.sp];
        M22Obj res = this.m22Store.heap[this.m22Store.hp++];
        res.a = l.a * r.a;
        res.b = l.a * r.b;
        res.c = l.b * r.a;
        res.d = l.b * r.b;
        this.m22Store.stack[this.m22Store.sp++] = res;
    }

    private final void mulM22V2() {
        V2Obj r = this.v2Store.stack[--this.v2Store.sp];
        M22Obj l = this.m22Store.stack[--this.m22Store.sp];
        V2Obj res = this.v2Store.heap[this.v2Store.hp++];
        res.a = l.a * r.a + l.b * r.b;
        res.b = l.c * r.a + l.d * r.b;
        this.v2Store.stack[this.v2Store.sp++] = res;
    }

    private final void mulV2M22() {
        M22Obj r = this.m22Store.stack[--this.m22Store.sp];
        V2Obj l = this.v2Store.stack[--this.v2Store.sp];
        V2Obj res = this.v2Store.heap[this.v2Store.hp++];
        res.a = l.a * r.a + l.b * r.c;
        res.b = l.a * r.b + l.b * r.d;
        this.v2Store.stack[this.v2Store.sp++] = res;
    }

    private final void mulM32V2() {
        V2Obj r = this.v2Store.stack[--this.v2Store.sp];
        M32Obj l = this.m32Store.stack[--this.m32Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.a * r.a + l.b * r.b;
        res.b = l.c * r.a + l.d * r.b;
        res.c = l.e * r.a + l.f * r.b;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void mulV2M23() {
        M23Obj r = this.m23Store.stack[--this.m23Store.sp];
        V2Obj l = this.v2Store.stack[--this.v2Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.a * r.a + l.b * r.d;
        res.b = l.a * r.b + l.b * r.e;
        res.c = l.a * r.c + l.b * r.f;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void mulM42V2() {
        V2Obj r = this.v2Store.stack[--this.v2Store.sp];
        M42Obj l = this.m42Store.stack[--this.m42Store.sp];
        V4Obj res = this.v4Store.heap[this.v4Store.hp++];
        res.a = l.a * r.a + l.b * r.b;
        res.b = l.c * r.a + l.d * r.b;
        res.c = l.e * r.a + l.f * r.b;
        res.d = l.g * r.a + l.h * r.b;
        this.v4Store.stack[this.v4Store.sp++] = res;
    }

    private final void mulV2M24() {
        M24Obj r = this.m24Store.stack[--this.m24Store.sp];
        V2Obj l = this.v2Store.stack[--this.v2Store.sp];
        V4Obj res = this.v4Store.heap[this.v4Store.hp++];
        res.a = l.a * r.a + l.b * r.e;
        res.b = l.a * r.b + l.b * r.f;
        res.c = l.a * r.c + l.b * r.g;
        res.d = l.a * r.d + l.b * r.h;
        this.v4Store.stack[this.v4Store.sp++] = res;
    }

    private final void mulM23V3() {
        V3Obj r = this.v3Store.stack[--this.v3Store.sp];
        M23Obj l = this.m23Store.stack[--this.m23Store.sp];
        V2Obj res = this.v2Store.heap[this.v2Store.hp++];
        res.a = l.a * r.a + l.b * r.b + l.c * r.c;
        res.b = l.d * r.a + l.e * r.b + l.f * r.c;
        this.v2Store.stack[this.v2Store.sp++] = res;
    }

    private final void mulV3M32() {
        M32Obj r = this.m32Store.stack[--this.m32Store.sp];
        V3Obj l = this.v3Store.stack[--this.v3Store.sp];
        V2Obj res = this.v2Store.heap[this.v2Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f;
        this.v2Store.stack[this.v2Store.sp++] = res;
    }

    private final void mulM33V3() {
        V3Obj r = this.v3Store.stack[--this.v3Store.sp];
        M33Obj l = this.m33Store.stack[--this.m33Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.a * r.a + l.b * r.b + l.c * r.c;
        res.b = l.d * r.a + l.e * r.b + l.f * r.c;
        res.c = l.g * r.a + l.h * r.b + l.i * r.c;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void mulV3V3() {
        V3Obj r = this.v3Store.stack[--this.v3Store.sp];
        V3Obj l = this.v3Store.stack[--this.v3Store.sp];
        M33Obj res = this.m33Store.heap[this.m33Store.hp++];
        res.a = l.a * r.a;
        res.b = l.a * r.b;
        res.c = l.a * r.c;
        res.d = l.b * r.a;
        res.e = l.b * r.b;
        res.f = l.b * r.c;
        res.g = l.c * r.a;
        res.h = l.c * r.b;
        res.i = l.c * r.c;
        this.m33Store.stack[this.m33Store.sp++] = res;
    }

    private final void mulV3M33() {
        M33Obj r = this.m33Store.stack[--this.m33Store.sp];
        V3Obj l = this.v3Store.stack[--this.v3Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void mulM43V3() {
        V3Obj r = this.v3Store.stack[--this.v3Store.sp];
        M43Obj l = this.m43Store.stack[--this.m43Store.sp];
        V4Obj res = this.v4Store.heap[this.v4Store.hp++];
        res.a = l.a * r.a + l.b * r.b + l.c * r.c;
        res.b = l.d * r.a + l.e * r.b + l.f * r.c;
        res.c = l.g * r.a + l.h * r.b + l.i * r.c;
        res.d = l.j * r.a + l.k * r.b + l.l * r.c;
        this.v4Store.stack[this.v4Store.sp++] = res;
    }

    private final void mulV3M34() {
        M34Obj r = this.m34Store.stack[--this.m34Store.sp];
        V3Obj l = this.v3Store.stack[--this.v3Store.sp];
        V4Obj res = this.v4Store.heap[this.v4Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l;
        this.v4Store.stack[this.v4Store.sp++] = res;
    }

    private final void mulM24V4() {
        V4Obj r = this.v4Store.stack[--this.v4Store.sp];
        M24Obj l = this.m24Store.stack[--this.m24Store.sp];
        V2Obj res = this.v2Store.heap[this.v2Store.hp++];
        res.a = l.a * r.a + l.b * r.b + l.c * r.c + l.d * r.d;
        res.b = l.e * r.a + l.f * r.b + l.g * r.c + l.h * r.d;
        this.v2Store.stack[this.v2Store.sp++] = res;
    }

    private final void mulV4M42() {
        M42Obj r = this.m42Store.stack[--this.m42Store.sp];
        V4Obj l = this.v4Store.stack[--this.v4Store.sp];
        V2Obj res = this.v2Store.heap[this.v2Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e + l.d * r.g;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f + l.d * r.h;
        this.v2Store.stack[this.v2Store.sp++] = res;
    }

    private final void mulM34V4() {
        V4Obj r = this.v4Store.stack[--this.v4Store.sp];
        M34Obj l = this.m34Store.stack[--this.m34Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.a * r.a + l.b * r.b + l.c * r.c + l.d * r.d;
        res.b = l.e * r.a + l.f * r.b + l.g * r.c + l.h * r.d;
        res.c = l.i * r.a + l.j * r.b + l.k * r.c + l.l * r.d;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void mulV4M43() {
        M43Obj r = this.m43Store.stack[--this.m43Store.sp];
        V4Obj l = this.v4Store.stack[--this.v4Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g + l.d * r.j;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h + l.d * r.k;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i + l.d * r.l;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void mulV4V4() {
        V4Obj r = this.v4Store.stack[--this.v4Store.sp];
        V4Obj l = this.v4Store.stack[--this.v4Store.sp];
        M44Obj res = this.m44Store.heap[this.m44Store.hp++];
        res.a = l.a * r.a;
        res.b = l.a * r.b;
        res.c = l.a * r.c;
        res.d = l.a * r.d;
        res.e = l.b * r.a;
        res.f = l.b * r.b;
        res.g = l.b * r.c;
        res.h = l.b * r.d;
        res.i = l.c * r.a;
        res.j = l.c * r.b;
        res.k = l.c * r.c;
        res.l = l.c * r.d;
        res.m = l.d * r.a;
        res.n = l.d * r.b;
        res.o = l.d * r.c;
        res.p = l.d * r.d;
        this.m44Store.stack[this.m44Store.sp++] = res;
    }

    private final void mulM44V4() {
        V4Obj r = this.v4Store.stack[--this.v4Store.sp];
        M44Obj l = this.m44Store.stack[--this.m44Store.sp];
        V4Obj res = this.v4Store.heap[this.v4Store.hp++];
        res.a = l.a * r.a + l.b * r.b + l.c * r.c + l.d * r.d;
        res.b = l.e * r.a + l.f * r.b + l.g * r.c + l.h * r.d;
        res.c = l.i * r.a + l.j * r.b + l.k * r.c + l.l * r.d;
        res.d = l.m * r.a + l.n * r.b + l.o * r.c + l.p * r.d;
        this.v4Store.stack[this.v4Store.sp++] = res;
    }

    private final void mulV4M44() {
        M44Obj r = this.m44Store.stack[--this.m44Store.sp];
        V4Obj l = this.v4Store.stack[--this.v4Store.sp];
        V4Obj res = this.v4Store.heap[this.v4Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i + l.d * r.m;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j + l.d * r.n;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k + l.d * r.o;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l + l.d * r.p;
        this.v4Store.stack[this.v4Store.sp++] = res;
    }

    private final void mulM22M22() {
        M22Obj r = this.m22Store.stack[--this.m22Store.sp];
        M22Obj l = this.m22Store.stack[--this.m22Store.sp];
        M22Obj res = this.m22Store.heap[this.m22Store.hp++];
        res.a = l.a * r.a + l.b * r.c;
        res.b = l.a * r.b + l.b * r.d;
        res.c = l.c * r.a + l.d * r.c;
        res.d = l.c * r.b + l.d * r.d;
        this.m22Store.stack[this.m22Store.sp++] = res;
    }

    private final void mulM22M23() {
        M23Obj r = this.m23Store.stack[--this.m23Store.sp];
        M22Obj l = this.m22Store.stack[--this.m22Store.sp];
        M23Obj res = this.m23Store.heap[this.m23Store.hp++];
        res.a = l.a * r.a + l.b * r.d;
        res.b = l.a * r.b + l.b * r.e;
        res.c = l.a * r.c + l.b * r.f;
        res.d = l.c * r.a + l.d * r.d;
        res.e = l.c * r.b + l.d * r.e;
        res.f = l.c * r.c + l.d * r.f;
        this.m23Store.stack[this.m23Store.sp++] = res;
    }

    private final void mulM22M24() {
        M24Obj r = this.m24Store.stack[--this.m24Store.sp];
        M22Obj l = this.m22Store.stack[--this.m22Store.sp];
        M24Obj res = this.m24Store.heap[this.m24Store.hp++];
        res.a = l.a * r.a + l.b * r.e;
        res.b = l.a * r.b + l.b * r.f;
        res.c = l.a * r.c + l.b * r.g;
        res.d = l.a * r.d + l.b * r.h;
        res.e = l.c * r.a + l.d * r.e;
        res.f = l.c * r.b + l.d * r.f;
        res.g = l.c * r.c + l.d * r.g;
        res.h = l.c * r.d + l.d * r.h;
        this.m24Store.stack[this.m24Store.sp++] = res;
    }

    private final void mulM23M32() {
        M32Obj r = this.m32Store.stack[--this.m32Store.sp];
        M23Obj l = this.m23Store.stack[--this.m23Store.sp];
        M22Obj res = this.m22Store.heap[this.m22Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f;
        res.c = l.d * r.a + l.e * r.c + l.f * r.e;
        res.d = l.d * r.b + l.e * r.d + l.f * r.f;
        this.m22Store.stack[this.m22Store.sp++] = res;
    }

    private final void mulM23M33() {
        M33Obj r = this.m33Store.stack[--this.m33Store.sp];
        M23Obj l = this.m23Store.stack[--this.m23Store.sp];
        M23Obj res = this.m23Store.heap[this.m23Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i;
        res.d = l.d * r.a + l.e * r.d + l.f * r.g;
        res.e = l.d * r.b + l.e * r.e + l.f * r.h;
        res.f = l.d * r.c + l.e * r.f + l.f * r.i;
        this.m23Store.stack[this.m23Store.sp++] = res;
    }

    private final void mulM23M34() {
        M34Obj r = this.m34Store.stack[--this.m34Store.sp];
        M23Obj l = this.m23Store.stack[--this.m23Store.sp];
        M24Obj res = this.m24Store.heap[this.m24Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l;
        res.e = l.d * r.a + l.e * r.e + l.f * r.i;
        res.f = l.d * r.b + l.e * r.f + l.f * r.j;
        res.g = l.d * r.c + l.e * r.g + l.f * r.k;
        res.h = l.d * r.d + l.e * r.h + l.f * r.l;
        this.m24Store.stack[this.m24Store.sp++] = res;
    }

    private final void mulM24M42() {
        M42Obj r = this.m42Store.stack[--this.m42Store.sp];
        M24Obj l = this.m24Store.stack[--this.m24Store.sp];
        M22Obj res = this.m22Store.heap[this.m22Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e + l.d * r.g;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f + l.d * r.h;
        res.c = l.e * r.a + l.f * r.c + l.g * r.e + l.h * r.g;
        res.d = l.e * r.b + l.f * r.d + l.g * r.f + l.h * r.h;
        this.m22Store.stack[this.m22Store.sp++] = res;
    }

    private final void mulM24M43() {
        M43Obj r = this.m43Store.stack[--this.m43Store.sp];
        M24Obj l = this.m24Store.stack[--this.m24Store.sp];
        M23Obj res = this.m23Store.heap[this.m23Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g + l.d * r.j;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h + l.d * r.k;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i + l.d * r.l;
        res.d = l.e * r.a + l.f * r.d + l.g * r.g + l.h * r.j;
        res.e = l.e * r.b + l.f * r.e + l.g * r.h + l.h * r.k;
        res.f = l.e * r.c + l.f * r.f + l.g * r.i + l.h * r.l;
        this.m23Store.stack[this.m23Store.sp++] = res;
    }

    private final void mulM24M44() {
        M44Obj r = this.m44Store.stack[--this.m44Store.sp];
        M24Obj l = this.m24Store.stack[--this.m24Store.sp];
        M24Obj res = this.m24Store.heap[this.m24Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i + l.d * r.m;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j + l.d * r.n;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k + l.d * r.o;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l + l.d * r.p;
        res.e = l.e * r.a + l.f * r.e + l.g * r.i + l.h * r.m;
        res.f = l.e * r.b + l.f * r.f + l.g * r.j + l.h * r.n;
        res.g = l.e * r.c + l.f * r.g + l.g * r.k + l.h * r.o;
        res.h = l.e * r.d + l.f * r.h + l.g * r.l + l.h * r.p;
        this.m24Store.stack[this.m24Store.sp++] = res;
    }

    private final void mulM32M22() {
        M22Obj r = this.m22Store.stack[--this.m22Store.sp];
        M32Obj l = this.m32Store.stack[--this.m32Store.sp];
        M32Obj res = this.m32Store.heap[this.m32Store.hp++];
        res.a = l.a * r.a + l.b * r.c;
        res.b = l.a * r.b + l.b * r.d;
        res.c = l.c * r.a + l.d * r.c;
        res.d = l.c * r.b + l.d * r.d;
        res.e = l.e * r.a + l.f * r.c;
        res.f = l.e * r.b + l.f * r.d;
        this.m32Store.stack[this.m32Store.sp++] = res;
    }

    private final void mulM32M23() {
        M23Obj r = this.m23Store.stack[--this.m23Store.sp];
        M32Obj l = this.m32Store.stack[--this.m32Store.sp];
        M33Obj res = this.m33Store.heap[this.m33Store.hp++];
        res.a = l.a * r.a + l.b * r.d;
        res.b = l.a * r.b + l.b * r.e;
        res.c = l.a * r.c + l.b * r.f;
        res.d = l.c * r.a + l.d * r.d;
        res.e = l.c * r.b + l.d * r.e;
        res.f = l.c * r.c + l.d * r.f;
        res.g = l.e * r.a + l.f * r.d;
        res.h = l.e * r.b + l.f * r.e;
        res.i = l.e * r.c + l.f * r.f;
        this.m33Store.stack[this.m33Store.sp++] = res;
    }

    private final void mulM32M24() {
        M24Obj r = this.m24Store.stack[--this.m24Store.sp];
        M32Obj l = this.m32Store.stack[--this.m32Store.sp];
        M34Obj res = this.m34Store.heap[this.m34Store.hp++];
        res.a = l.a * r.a + l.b * r.e;
        res.b = l.a * r.b + l.b * r.f;
        res.c = l.a * r.c + l.b * r.g;
        res.d = l.a * r.d + l.b * r.h;
        res.e = l.c * r.a + l.d * r.e;
        res.f = l.c * r.b + l.d * r.f;
        res.g = l.c * r.c + l.d * r.g;
        res.h = l.c * r.d + l.d * r.h;
        res.i = l.e * r.a + l.f * r.e;
        res.j = l.e * r.b + l.f * r.f;
        res.k = l.e * r.c + l.f * r.g;
        res.l = l.e * r.d + l.f * r.h;
        this.m34Store.stack[this.m34Store.sp++] = res;
    }

    private final void mulM33M32() {
        M32Obj r = this.m32Store.stack[--this.m32Store.sp];
        M33Obj l = this.m33Store.stack[--this.m33Store.sp];
        M32Obj res = this.m32Store.heap[this.m32Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f;
        res.c = l.d * r.a + l.e * r.c + l.f * r.e;
        res.d = l.d * r.b + l.e * r.d + l.f * r.f;
        res.e = l.g * r.a + l.h * r.c + l.i * r.e;
        res.f = l.g * r.b + l.h * r.d + l.i * r.f;
        this.m32Store.stack[this.m32Store.sp++] = res;
    }

    private final void mulM33M33() {
        M33Obj r = this.m33Store.stack[--this.m33Store.sp];
        M33Obj l = this.m33Store.stack[--this.m33Store.sp];
        M33Obj res = this.m33Store.heap[this.m33Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i;
        res.d = l.d * r.a + l.e * r.d + l.f * r.g;
        res.e = l.d * r.b + l.e * r.e + l.f * r.h;
        res.f = l.d * r.c + l.e * r.f + l.f * r.i;
        res.g = l.g * r.a + l.h * r.d + l.i * r.g;
        res.h = l.g * r.b + l.h * r.e + l.i * r.h;
        res.i = l.g * r.c + l.h * r.f + l.i * r.i;
        this.m33Store.stack[this.m33Store.sp++] = res;
    }

    private final void mulM33M34() {
        M34Obj r = this.m34Store.stack[--this.m34Store.sp];
        M33Obj l = this.m33Store.stack[--this.m33Store.sp];
        M34Obj res = this.m34Store.heap[this.m34Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l;
        res.e = l.d * r.a + l.e * r.e + l.f * r.i;
        res.f = l.d * r.b + l.e * r.f + l.f * r.j;
        res.g = l.d * r.c + l.e * r.g + l.f * r.k;
        res.h = l.d * r.d + l.e * r.h + l.f * r.l;
        res.i = l.g * r.a + l.h * r.e + l.i * r.i;
        res.j = l.g * r.b + l.h * r.f + l.i * r.j;
        res.k = l.g * r.c + l.h * r.g + l.i * r.k;
        res.l = l.g * r.d + l.h * r.h + l.i * r.l;
        this.m34Store.stack[this.m34Store.sp++] = res;
    }

    private final void mulM34M42() {
        M42Obj r = this.m42Store.stack[--this.m42Store.sp];
        M34Obj l = this.m34Store.stack[--this.m34Store.sp];
        M32Obj res = this.m32Store.heap[this.m32Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e + l.d * r.g;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f + l.d * r.h;
        res.c = l.e * r.a + l.f * r.c + l.g * r.e + l.h * r.g;
        res.d = l.e * r.b + l.f * r.d + l.g * r.f + l.h * r.h;
        res.e = l.i * r.a + l.j * r.c + l.k * r.e + l.l * r.g;
        res.f = l.i * r.b + l.j * r.d + l.k * r.f + l.l * r.h;
        this.m32Store.stack[this.m32Store.sp++] = res;
    }

    private final void mulM34M43() {
        M43Obj r = this.m43Store.stack[--this.m43Store.sp];
        M34Obj l = this.m34Store.stack[--this.m34Store.sp];
        M33Obj res = this.m33Store.heap[this.m33Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g + l.d * r.j;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h + l.d * r.k;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i + l.d * r.l;
        res.d = l.e * r.a + l.f * r.d + l.g * r.g + l.h * r.j;
        res.e = l.e * r.b + l.f * r.e + l.g * r.h + l.h * r.k;
        res.f = l.e * r.c + l.f * r.f + l.g * r.i + l.h * r.l;
        res.g = l.i * r.a + l.j * r.d + l.k * r.g + l.l * r.j;
        res.h = l.i * r.b + l.j * r.e + l.k * r.h + l.l * r.k;
        res.i = l.i * r.c + l.j * r.f + l.k * r.i + l.l * r.l;
        this.m33Store.stack[this.m33Store.sp++] = res;
    }

    private final void mulM34M44() {
        M44Obj r = this.m44Store.stack[--this.m44Store.sp];
        M34Obj l = this.m34Store.stack[--this.m34Store.sp];
        M34Obj res = this.m34Store.heap[this.m34Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i + l.d * r.m;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j + l.d * r.n;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k + l.d * r.o;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l + l.d * r.p;
        res.e = l.e * r.a + l.f * r.e + l.g * r.i + l.h * r.m;
        res.f = l.e * r.b + l.f * r.f + l.g * r.j + l.h * r.n;
        res.g = l.e * r.c + l.f * r.g + l.g * r.k + l.h * r.o;
        res.h = l.e * r.d + l.f * r.h + l.g * r.l + l.h * r.p;
        res.i = l.i * r.a + l.j * r.e + l.k * r.i + l.l * r.m;
        res.j = l.i * r.b + l.j * r.f + l.k * r.j + l.l * r.n;
        res.k = l.i * r.c + l.j * r.g + l.k * r.k + l.l * r.o;
        res.l = l.i * r.d + l.j * r.h + l.k * r.l + l.l * r.p;
        this.m34Store.stack[this.m34Store.sp++] = res;
    }

    private final void mulM42M22() {
        M22Obj r = this.m22Store.stack[--this.m22Store.sp];
        M42Obj l = this.m42Store.stack[--this.m42Store.sp];
        M42Obj res = this.m42Store.heap[this.m42Store.hp++];
        res.a = l.a * r.a + l.b * r.c;
        res.b = l.a * r.b + l.b * r.d;
        res.c = l.c * r.a + l.d * r.c;
        res.d = l.c * r.b + l.d * r.d;
        res.e = l.e * r.a + l.f * r.c;
        res.f = l.e * r.b + l.f * r.d;
        res.g = l.g * r.a + l.h * r.c;
        res.h = l.g * r.b + l.h * r.d;
        this.m42Store.stack[this.m42Store.sp++] = res;
    }

    private final void mulM42M23() {
        M23Obj r = this.m23Store.stack[--this.m23Store.sp];
        M42Obj l = this.m42Store.stack[--this.m42Store.sp];
        M43Obj res = this.m43Store.heap[this.m43Store.hp++];
        res.a = l.a * r.a + l.b * r.d;
        res.b = l.a * r.b + l.b * r.e;
        res.c = l.a * r.c + l.b * r.f;
        res.d = l.c * r.a + l.d * r.d;
        res.e = l.c * r.b + l.d * r.e;
        res.f = l.c * r.c + l.d * r.f;
        res.g = l.e * r.a + l.f * r.d;
        res.h = l.e * r.b + l.f * r.e;
        res.i = l.e * r.c + l.f * r.f;
        res.j = l.g * r.a + l.h * r.d;
        res.k = l.g * r.b + l.h * r.e;
        res.l = l.g * r.c + l.h * r.f;
        this.m43Store.stack[this.m43Store.sp++] = res;
    }

    private final void mulM42M24() {
        M24Obj r = this.m24Store.stack[--this.m24Store.sp];
        M42Obj l = this.m42Store.stack[--this.m42Store.sp];
        M44Obj res = this.m44Store.heap[this.m44Store.hp++];
        res.a = l.a * r.a + l.b * r.e;
        res.b = l.a * r.b + l.b * r.f;
        res.c = l.a * r.c + l.b * r.g;
        res.d = l.a * r.d + l.b * r.h;
        res.e = l.c * r.a + l.d * r.e;
        res.f = l.c * r.b + l.d * r.f;
        res.g = l.c * r.c + l.d * r.g;
        res.h = l.c * r.d + l.d * r.h;
        res.i = l.e * r.a + l.f * r.e;
        res.j = l.e * r.b + l.f * r.f;
        res.k = l.e * r.c + l.f * r.g;
        res.l = l.e * r.d + l.f * r.h;
        res.m = l.g * r.a + l.h * r.e;
        res.n = l.g * r.b + l.h * r.f;
        res.o = l.g * r.c + l.h * r.g;
        res.p = l.g * r.d + l.h * r.h;
        this.m44Store.stack[this.m44Store.sp++] = res;
    }

    private final void mulM43M32() {
        M32Obj r = this.m32Store.stack[--this.m32Store.sp];
        M43Obj l = this.m43Store.stack[--this.m43Store.sp];
        M42Obj res = this.m42Store.heap[this.m42Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f;
        res.c = l.d * r.a + l.e * r.c + l.f * r.e;
        res.d = l.d * r.b + l.e * r.d + l.f * r.f;
        res.e = l.g * r.a + l.h * r.c + l.i * r.e;
        res.f = l.g * r.b + l.h * r.d + l.i * r.f;
        res.g = l.j * r.a + l.k * r.c + l.l * r.e;
        res.h = l.j * r.b + l.k * r.d + l.l * r.f;
        this.m42Store.stack[this.m42Store.sp++] = res;
    }

    private final void mulM43M33() {
        M33Obj r = this.m33Store.stack[--this.m33Store.sp];
        M43Obj l = this.m43Store.stack[--this.m43Store.sp];
        M43Obj res = this.m43Store.heap[this.m43Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i;
        res.d = l.d * r.a + l.e * r.d + l.f * r.g;
        res.e = l.d * r.b + l.e * r.e + l.f * r.h;
        res.f = l.d * r.c + l.e * r.f + l.f * r.i;
        res.g = l.g * r.a + l.h * r.d + l.i * r.g;
        res.h = l.g * r.b + l.h * r.e + l.i * r.h;
        res.i = l.g * r.c + l.h * r.f + l.i * r.i;
        res.j = l.j * r.a + l.k * r.d + l.l * r.g;
        res.k = l.j * r.b + l.k * r.e + l.l * r.h;
        res.l = l.j * r.c + l.k * r.f + l.l * r.i;
        this.m43Store.stack[this.m43Store.sp++] = res;
    }

    private final void mulM43M34() {
        M34Obj r = this.m34Store.stack[--this.m34Store.sp];
        M43Obj l = this.m43Store.stack[--this.m43Store.sp];
        M44Obj res = this.m44Store.heap[this.m44Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l;
        res.e = l.d * r.a + l.e * r.e + l.f * r.i;
        res.f = l.d * r.b + l.e * r.f + l.f * r.j;
        res.g = l.d * r.c + l.e * r.g + l.f * r.k;
        res.h = l.d * r.d + l.e * r.h + l.f * r.l;
        res.i = l.g * r.a + l.h * r.e + l.i * r.i;
        res.j = l.g * r.b + l.h * r.f + l.i * r.j;
        res.k = l.g * r.c + l.h * r.g + l.i * r.k;
        res.l = l.g * r.d + l.h * r.h + l.i * r.l;
        res.m = l.j * r.a + l.k * r.e + l.l * r.i;
        res.n = l.j * r.b + l.k * r.f + l.l * r.j;
        res.o = l.j * r.c + l.k * r.g + l.l * r.k;
        res.p = l.j * r.d + l.k * r.h + l.l * r.l;
        this.m44Store.stack[this.m44Store.sp++] = res;
    }

    private final void mulM44M42() {
        M42Obj r = this.m42Store.stack[--this.m42Store.sp];
        M44Obj l = this.m44Store.stack[--this.m44Store.sp];
        M42Obj res = this.m42Store.heap[this.m42Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e + l.d * r.g;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f + l.d * r.h;
        res.c = l.e * r.a + l.f * r.c + l.g * r.e + l.h * r.g;
        res.d = l.e * r.b + l.f * r.d + l.g * r.f + l.h * r.h;
        res.e = l.i * r.a + l.j * r.c + l.k * r.e + l.l * r.g;
        res.f = l.i * r.b + l.j * r.d + l.k * r.f + l.l * r.h;
        res.g = l.m * r.a + l.n * r.c + l.o * r.e + l.p * r.g;
        res.h = l.m * r.b + l.n * r.d + l.o * r.f + l.p * r.h;
        this.m42Store.stack[this.m42Store.sp++] = res;
    }

    private final void mulM44M43() {
        M43Obj r = this.m43Store.stack[--this.m43Store.sp];
        M44Obj l = this.m44Store.stack[--this.m44Store.sp];
        M43Obj res = this.m43Store.heap[this.m43Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g + l.d * r.j;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h + l.d * r.k;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i + l.d * r.l;
        res.d = l.e * r.a + l.f * r.d + l.g * r.g + l.h * r.j;
        res.e = l.e * r.b + l.f * r.e + l.g * r.h + l.h * r.k;
        res.f = l.e * r.c + l.f * r.f + l.g * r.i + l.h * r.l;
        res.g = l.i * r.a + l.j * r.d + l.k * r.g + l.l * r.j;
        res.h = l.i * r.b + l.j * r.e + l.k * r.h + l.l * r.k;
        res.i = l.i * r.c + l.j * r.f + l.k * r.i + l.l * r.l;
        res.j = l.m * r.a + l.n * r.d + l.o * r.g + l.p * r.j;
        res.k = l.m * r.b + l.n * r.e + l.o * r.h + l.p * r.k;
        res.l = l.m * r.c + l.n * r.f + l.o * r.i + l.p * r.l;
        this.m43Store.stack[this.m43Store.sp++] = res;
    }

    private final void mulM44M44() {
        M44Obj r = this.m44Store.stack[--this.m44Store.sp];
        M44Obj l = this.m44Store.stack[--this.m44Store.sp];
        M44Obj res = this.m44Store.heap[this.m44Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i + l.d * r.m;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j + l.d * r.n;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k + l.d * r.o;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l + l.d * r.p;
        res.e = l.e * r.a + l.f * r.e + l.g * r.i + l.h * r.m;
        res.f = l.e * r.b + l.f * r.f + l.g * r.j + l.h * r.n;
        res.g = l.e * r.c + l.f * r.g + l.g * r.k + l.h * r.o;
        res.h = l.e * r.d + l.f * r.h + l.g * r.l + l.h * r.p;
        res.i = l.i * r.a + l.j * r.e + l.k * r.i + l.l * r.m;
        res.j = l.i * r.b + l.j * r.f + l.k * r.j + l.l * r.n;
        res.k = l.i * r.c + l.j * r.g + l.k * r.k + l.l * r.o;
        res.l = l.i * r.d + l.j * r.h + l.k * r.l + l.l * r.p;
        res.m = l.m * r.a + l.n * r.e + l.o * r.i + l.p * r.m;
        res.n = l.m * r.b + l.n * r.f + l.o * r.j + l.p * r.n;
        res.o = l.m * r.c + l.n * r.g + l.o * r.k + l.p * r.o;
        res.p = l.m * r.d + l.n * r.h + l.o * r.l + l.p * r.p;
        this.m44Store.stack[this.m44Store.sp++] = res;
    }

    private final void mulVnMnn(VecObj l, MatObj r) {
        double[] ldata = l.toArrayVec();
        double[][] rdata = r.toArrayMat();
        int rrows = rdata.length;
        int rcols = rdata[0].length;
        double[] res = new double[rcols];
        int j = 0;
        while (j < rcols) {
            double ele = ldata[0] * rdata[0][j];
            int k = 1;
            while (k < rrows) {
                ele += ldata[k] * rdata[k][j];
                ++k;
            }
            res[j] = ele;
            ++j;
        }
        this.pushVec(res);
    }

    private final void mulMnnVn(MatObj l, VecObj r) {
        double[][] ldata = l.toArrayMat();
        double[] rdata = r.toArrayVec();
        int lrows = ldata.length;
        int lcols = ldata[0].length;
        double[] res = new double[lrows];
        int i = 0;
        while (i < lrows) {
            double ele = ldata[i][0] * rdata[0];
            int k = 1;
            while (k < lcols) {
                ele += ldata[i][k] * rdata[k];
                ++k;
            }
            res[i] = ele;
            ++i;
        }
        this.pushVec(res);
    }

    private final void mulVnVn(VecObj l, VecObj r) {
        double[] ldata = l.toArrayVec();
        double[] rdata = r.toArrayVec();
        int rows = ldata.length;
        int cols = rdata.length;
        double[][] res = new double[rows][cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                res[i][j] = ldata[i] * rdata[j];
                ++j;
            }
            ++i;
        }
        this.pushMat(res);
    }

    private final void mulMnnMnn(MatObj l, MatObj r) {
        double[][] ldata = l.toArrayMat();
        double[][] rdata = r.toArrayMat();
        int lrows = ldata.length;
        int rrows = rdata.length;
        int rcols = rdata[0].length;
        double[][] res = new double[lrows][rcols];
        int i = 0;
        while (i < lrows) {
            int j = 0;
            while (j < rcols) {
                double ele = ldata[i][0] * rdata[0][j];
                int k = 1;
                while (k < rrows) {
                    ele += ldata[i][k] * rdata[k][j];
                    ++k;
                }
                res[i][j] = ele;
                ++j;
            }
            ++i;
        }
        this.pushMat(res);
    }

    private final void pushVec(double[] vec) {
        switch (vec.length) {
            case 2: {
                V2Obj v2 = this.v2Store.heap[this.v2Store.hp++];
                v2.a = vec[0];
                v2.b = vec[1];
                this.v2Store.stack[this.v2Store.sp++] = v2;
                break;
            }
            case 3: {
                V3Obj v3 = this.v3Store.heap[this.v3Store.hp++];
                v3.a = vec[0];
                v3.b = vec[1];
                v3.c = vec[2];
                this.v3Store.stack[this.v3Store.sp++] = v3;
                break;
            }
            case 4: {
                V4Obj v4 = this.v4Store.heap[this.v4Store.hp++];
                v4.a = vec[0];
                v4.b = vec[1];
                v4.c = vec[2];
                v4.d = vec[3];
                this.v4Store.stack[this.v4Store.sp++] = v4;
                break;
            }
            default: {
                this.vnStore.stack[this.vnStore.sp++] = new VnObj(vec);
            }
        }
    }

    private final void pushMat(double[][] mat) {
        switch (mat.length) {
            case 2: {
                switch (mat[0].length) {
                    case 2: {
                        M22Obj m22 = this.m22Store.heap[this.m22Store.hp++];
                        m22.a = mat[0][0];
                        m22.b = mat[0][1];
                        m22.c = mat[1][0];
                        m22.d = mat[1][1];
                        this.m22Store.stack[this.m22Store.sp++] = m22;
                        return;
                    }
                    case 3: {
                        M23Obj m23 = this.m23Store.heap[this.m23Store.hp++];
                        m23.a = mat[0][0];
                        m23.b = mat[0][1];
                        m23.c = mat[0][2];
                        m23.d = mat[1][0];
                        m23.e = mat[1][1];
                        m23.f = mat[1][2];
                        this.m23Store.stack[this.m23Store.sp++] = m23;
                        return;
                    }
                    case 4: {
                        M24Obj m24 = this.m24Store.heap[this.m24Store.hp++];
                        m24.a = mat[0][0];
                        m24.b = mat[0][1];
                        m24.c = mat[0][2];
                        m24.d = mat[0][3];
                        m24.e = mat[1][0];
                        m24.f = mat[1][1];
                        m24.g = mat[1][2];
                        m24.h = mat[1][3];
                        this.m24Store.stack[this.m24Store.sp++] = m24;
                        return;
                    }
                }
                break;
            }
            case 3: {
                switch (mat[0].length) {
                    case 2: {
                        M32Obj m32 = this.m32Store.heap[this.m32Store.hp++];
                        m32.a = mat[0][0];
                        m32.b = mat[0][1];
                        m32.c = mat[1][0];
                        m32.d = mat[1][1];
                        m32.e = mat[2][0];
                        m32.f = mat[2][1];
                        this.m32Store.stack[this.m32Store.sp++] = m32;
                        return;
                    }
                    case 3: {
                        M33Obj m33 = this.m33Store.heap[this.m33Store.hp++];
                        m33.a = mat[0][0];
                        m33.b = mat[0][1];
                        m33.c = mat[0][2];
                        m33.d = mat[1][0];
                        m33.e = mat[1][1];
                        m33.f = mat[1][2];
                        m33.g = mat[2][0];
                        m33.h = mat[2][1];
                        m33.i = mat[2][2];
                        this.m33Store.stack[this.m33Store.sp++] = m33;
                        return;
                    }
                    case 4: {
                        M34Obj m34 = this.m34Store.heap[this.m34Store.hp++];
                        m34.a = mat[0][0];
                        m34.b = mat[0][1];
                        m34.c = mat[0][2];
                        m34.d = mat[0][3];
                        m34.e = mat[1][0];
                        m34.f = mat[1][1];
                        m34.g = mat[1][2];
                        m34.h = mat[1][3];
                        m34.i = mat[2][0];
                        m34.j = mat[2][1];
                        m34.k = mat[2][2];
                        m34.l = mat[2][3];
                        this.m34Store.stack[this.m34Store.sp++] = m34;
                        return;
                    }
                }
                break;
            }
            case 4: {
                switch (mat[0].length) {
                    case 2: {
                        M42Obj m42 = this.m42Store.heap[this.m42Store.hp++];
                        m42.a = mat[0][0];
                        m42.b = mat[0][1];
                        m42.c = mat[1][0];
                        m42.d = mat[1][1];
                        m42.e = mat[2][0];
                        m42.f = mat[2][1];
                        m42.g = mat[3][0];
                        m42.h = mat[3][1];
                        this.m42Store.stack[this.m42Store.sp++] = m42;
                        return;
                    }
                    case 3: {
                        M43Obj m43 = this.m43Store.heap[this.m43Store.hp++];
                        m43.a = mat[0][0];
                        m43.b = mat[0][1];
                        m43.c = mat[0][2];
                        m43.d = mat[1][0];
                        m43.e = mat[1][1];
                        m43.f = mat[1][2];
                        m43.g = mat[2][0];
                        m43.h = mat[2][1];
                        m43.i = mat[2][2];
                        m43.j = mat[3][0];
                        m43.k = mat[3][1];
                        m43.l = mat[3][2];
                        this.m43Store.stack[this.m43Store.sp++] = m43;
                        return;
                    }
                    case 4: {
                        M44Obj m44 = this.m44Store.heap[this.m44Store.hp++];
                        m44.a = mat[0][0];
                        m44.b = mat[0][1];
                        m44.c = mat[0][2];
                        m44.d = mat[0][3];
                        m44.e = mat[1][0];
                        m44.f = mat[1][1];
                        m44.g = mat[1][2];
                        m44.h = mat[1][3];
                        m44.i = mat[2][0];
                        m44.j = mat[2][1];
                        m44.k = mat[2][2];
                        m44.l = mat[2][3];
                        m44.m = mat[3][0];
                        m44.n = mat[3][1];
                        m44.o = mat[3][2];
                        m44.p = mat[3][3];
                        this.m44Store.stack[this.m44Store.sp++] = m44;
                        return;
                    }
                }
            }
        }
        this.mnnStore.stack[this.mnnStore.sp++] = new MnnObj(mat);
    }

    private final void unitaryFunction(short fun) {
        double r = this.scalerStore.stack[--this.scalerStore.sp];
        switch (fun) {
            case 1: {
                r = Math.sin(r);
                break;
            }
            case 2: {
                r = Math.cos(r);
                break;
            }
            case 3: {
                r = Math.tan(r);
                break;
            }
            case 4: {
                r = Math.asin(r);
                break;
            }
            case 5: {
                r = Math.acos(r);
                break;
            }
            case 6: {
                r = Math.atan(r);
                break;
            }
            case 7: {
                r = (Math.exp(r) - Math.exp(-r)) / 2.0;
                break;
            }
            case 8: {
                r = (Math.exp(r) + Math.exp(-r)) / 2.0;
                break;
            }
            case 9: {
                double ex = Math.exp(r * 2.0);
                r = (ex - 1.0) / (ex + 1.0);
                break;
            }
            case 10: {
                r = Math.log(r + Math.sqrt(1.0 + r * r));
                break;
            }
            case 11: {
                r = Math.log(r + Math.sqrt(r * r - 1.0));
                break;
            }
            case 12: {
                r = Math.log((1.0 + r) / (1.0 - r)) / 2.0;
                break;
            }
            case 13: {
                r = Math.abs(r);
                break;
            }
            case 14: {
                r = Math.exp(r);
                break;
            }
            case 15: {
                r = Math.log(r) / LOG10;
                break;
            }
            case 16: {
                r = Math.log(r);
                break;
            }
            case 17: {
                r = Math.sqrt(r);
                break;
            }
            case 18: {
                r = 1.0 / Math.cos(r);
                break;
            }
            case 19: {
                r = 1.0 / Math.sin(r);
                break;
            }
            case 20: {
                r = 1.0 / Math.tan(r);
            }
        }
        this.scalerStore.stack[this.scalerStore.sp++] = r;
    }

    private final void binaryFunction(short fun) {
        double r = this.scalerStore.stack[--this.scalerStore.sp];
        double l = this.scalerStore.stack[--this.scalerStore.sp];
        switch (fun) {
            case 21: {
                r = Math.atan2(l, r);
            }
        }
        this.scalerStore.stack[this.scalerStore.sp++] = r;
    }

    private final void trianaryFunction(short fun) {
        double a = this.scalerStore.stack[--this.scalerStore.sp];
        double r = this.scalerStore.stack[--this.scalerStore.sp];
        double l = this.scalerStore.stack[--this.scalerStore.sp];
        switch (fun) {
            case 22: {
                r = l > 0.0 ? r : a;
            }
        }
        this.scalerStore.stack[this.scalerStore.sp++] = r;
    }

    private final void quarteraryFunction(short fun) {
        double b = this.scalerStore.stack[--this.scalerStore.sp];
        double a = this.scalerStore.stack[--this.scalerStore.sp];
        double r = this.scalerStore.stack[--this.scalerStore.sp];
        double l = this.scalerStore.stack[--this.scalerStore.sp];
        switch (fun) {
            case 22: {
                r = l > 0.0 ? r : (l < 0.0 ? a : b);
            }
        }
        this.scalerStore.stack[this.scalerStore.sp++] = r;
    }

    public void cleanUp() {
        this.scalerStore.cleanUp();
        this.v2Store.cleanUp();
        this.v3Store.cleanUp();
        this.v4Store.cleanUp();
        this.vnStore.cleanUp();
        this.m22Store.cleanUp();
        this.m23Store.cleanUp();
        this.m24Store.cleanUp();
        this.m32Store.cleanUp();
        this.m33Store.cleanUp();
        this.m34Store.cleanUp();
        this.m42Store.cleanUp();
        this.m43Store.cleanUp();
        this.m44Store.cleanUp();
        this.mnnStore.cleanUp();
    }
}

